/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.PublicAccessBlockConfiguration;
import software.amazon.awssdk.services.s3control.model.Region;
import software.amazon.awssdk.services.s3control.model.RegionCreationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMultiRegionAccessPointInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateMultiRegionAccessPointInput> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateMultiRegionAccessPointInput.getter(CreateMultiRegionAccessPointInput::name)).setter(CreateMultiRegionAccessPointInput.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<PublicAccessBlockConfiguration> PUBLIC_ACCESS_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PublicAccessBlock").getter(CreateMultiRegionAccessPointInput.getter(CreateMultiRegionAccessPointInput::publicAccessBlock)).setter(CreateMultiRegionAccessPointInput.setter(Builder::publicAccessBlock)).constructor(PublicAccessBlockConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicAccessBlock").unmarshallLocationName("PublicAccessBlock").build()}).build();
    private static final SdkField<List<Region>> REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Regions").getter(CreateMultiRegionAccessPointInput.getter(CreateMultiRegionAccessPointInput::regions)).setter(CreateMultiRegionAccessPointInput.setter(Builder::regions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Regions").unmarshallLocationName("Regions").build(), ListTrait.builder().memberLocationName("Region").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Region::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").unmarshallLocationName("Region").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PUBLIC_ACCESS_BLOCK_FIELD, REGIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final PublicAccessBlockConfiguration publicAccessBlock;
    private final List<Region> regions;

    private CreateMultiRegionAccessPointInput(BuilderImpl builder) {
        this.name = builder.name;
        this.publicAccessBlock = builder.publicAccessBlock;
        this.regions = builder.regions;
    }

    public final String name() {
        return this.name;
    }

    public final PublicAccessBlockConfiguration publicAccessBlock() {
        return this.publicAccessBlock;
    }

    public final boolean hasRegions() {
        return this.regions != null && !(this.regions instanceof SdkAutoConstructList);
    }

    public final List<Region> regions() {
        return this.regions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicAccessBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegions() ? this.regions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMultiRegionAccessPointInput)) {
            return false;
        }
        CreateMultiRegionAccessPointInput other = (CreateMultiRegionAccessPointInput)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.publicAccessBlock(), other.publicAccessBlock()) && this.hasRegions() == other.hasRegions() && Objects.equals(this.regions(), other.regions());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMultiRegionAccessPointInput").add("Name", (Object)this.name()).add("PublicAccessBlock", (Object)this.publicAccessBlock()).add("Regions", this.hasRegions() ? this.regions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "PublicAccessBlock": {
                return Optional.ofNullable(clazz.cast(this.publicAccessBlock()));
            }
            case "Regions": {
                return Optional.ofNullable(clazz.cast(this.regions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMultiRegionAccessPointInput, T> g) {
        return obj -> g.apply((CreateMultiRegionAccessPointInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private PublicAccessBlockConfiguration publicAccessBlock;
        private List<Region> regions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMultiRegionAccessPointInput model) {
            this.name(model.name);
            this.publicAccessBlock(model.publicAccessBlock);
            this.regions(model.regions);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PublicAccessBlockConfiguration.Builder getPublicAccessBlock() {
            return this.publicAccessBlock != null ? this.publicAccessBlock.toBuilder() : null;
        }

        public final void setPublicAccessBlock(PublicAccessBlockConfiguration.BuilderImpl publicAccessBlock) {
            this.publicAccessBlock = publicAccessBlock != null ? publicAccessBlock.build() : null;
        }

        @Override
        public final Builder publicAccessBlock(PublicAccessBlockConfiguration publicAccessBlock) {
            this.publicAccessBlock = publicAccessBlock;
            return this;
        }

        public final List<Region.Builder> getRegions() {
            List<Region.Builder> result = RegionCreationListCopier.copyToBuilder(this.regions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegions(Collection<Region.BuilderImpl> regions) {
            this.regions = RegionCreationListCopier.copyFromBuilder(regions);
        }

        @Override
        public final Builder regions(Collection<Region> regions) {
            this.regions = RegionCreationListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(Region ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(Consumer<Region.Builder> ... regions) {
            this.regions(Stream.of(regions).map(c -> (Region)((Region.Builder)Region.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CreateMultiRegionAccessPointInput build() {
            return new CreateMultiRegionAccessPointInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateMultiRegionAccessPointInput> {
        public Builder name(String var1);

        public Builder publicAccessBlock(PublicAccessBlockConfiguration var1);

        default public Builder publicAccessBlock(Consumer<PublicAccessBlockConfiguration.Builder> publicAccessBlock) {
            return this.publicAccessBlock((PublicAccessBlockConfiguration)((PublicAccessBlockConfiguration.Builder)PublicAccessBlockConfiguration.builder().applyMutation(publicAccessBlock)).build());
        }

        public Builder regions(Collection<Region> var1);

        public Builder regions(Region ... var1);

        public Builder regions(Consumer<Region.Builder> ... var1);
    }
}

