/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.interceptor.trait.HttpChecksumRequired;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.xml.AwsXmlProtocolFactory;
import software.amazon.awssdk.protocols.xml.XmlOperationMetadata;
import software.amazon.awssdk.services.s3.internal.resource.S3AccessPointResource;
import software.amazon.awssdk.services.s3.internal.resource.S3Resource;
import software.amazon.awssdk.services.s3control.S3ControlAsyncClient;
import software.amazon.awssdk.services.s3control.S3ControlBucketResource;
import software.amazon.awssdk.services.s3control.internal.S3ArnableField;
import software.amazon.awssdk.services.s3control.internal.S3ControlArnConverter;
import software.amazon.awssdk.services.s3control.internal.S3ControlInternalExecutionAttribute;
import software.amazon.awssdk.services.s3control.model.BadRequestException;
import software.amazon.awssdk.services.s3control.model.BucketAlreadyExistsException;
import software.amazon.awssdk.services.s3control.model.BucketAlreadyOwnedByYouException;
import software.amazon.awssdk.services.s3control.model.CreateAccessPointForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.CreateAccessPointForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.CreateAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.CreateAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3control.model.CreateBucketResponse;
import software.amazon.awssdk.services.s3control.model.CreateJobRequest;
import software.amazon.awssdk.services.s3control.model.CreateJobResponse;
import software.amazon.awssdk.services.s3control.model.CreateMultiRegionAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.CreateMultiRegionAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointPolicyForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointPolicyForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointPolicyResponse;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.DeleteAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.DeleteBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.DeleteBucketLifecycleConfigurationResponse;
import software.amazon.awssdk.services.s3control.model.DeleteBucketPolicyRequest;
import software.amazon.awssdk.services.s3control.model.DeleteBucketPolicyResponse;
import software.amazon.awssdk.services.s3control.model.DeleteBucketRequest;
import software.amazon.awssdk.services.s3control.model.DeleteBucketResponse;
import software.amazon.awssdk.services.s3control.model.DeleteBucketTaggingRequest;
import software.amazon.awssdk.services.s3control.model.DeleteBucketTaggingResponse;
import software.amazon.awssdk.services.s3control.model.DeleteJobTaggingRequest;
import software.amazon.awssdk.services.s3control.model.DeleteJobTaggingResponse;
import software.amazon.awssdk.services.s3control.model.DeleteMultiRegionAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.DeleteMultiRegionAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.DeletePublicAccessBlockRequest;
import software.amazon.awssdk.services.s3control.model.DeletePublicAccessBlockResponse;
import software.amazon.awssdk.services.s3control.model.DeleteStorageLensConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.DeleteStorageLensConfigurationResponse;
import software.amazon.awssdk.services.s3control.model.DeleteStorageLensConfigurationTaggingRequest;
import software.amazon.awssdk.services.s3control.model.DeleteStorageLensConfigurationTaggingResponse;
import software.amazon.awssdk.services.s3control.model.DescribeJobRequest;
import software.amazon.awssdk.services.s3control.model.DescribeJobResponse;
import software.amazon.awssdk.services.s3control.model.DescribeMultiRegionAccessPointOperationRequest;
import software.amazon.awssdk.services.s3control.model.DescribeMultiRegionAccessPointOperationResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointConfigurationForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointConfigurationForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyStatusResponse;
import software.amazon.awssdk.services.s3control.model.GetAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.GetAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.GetBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketLifecycleConfigurationResponse;
import software.amazon.awssdk.services.s3control.model.GetBucketPolicyRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketPolicyResponse;
import software.amazon.awssdk.services.s3control.model.GetBucketRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketResponse;
import software.amazon.awssdk.services.s3control.model.GetBucketTaggingRequest;
import software.amazon.awssdk.services.s3control.model.GetBucketTaggingResponse;
import software.amazon.awssdk.services.s3control.model.GetJobTaggingRequest;
import software.amazon.awssdk.services.s3control.model.GetJobTaggingResponse;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyResponse;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyStatusRequest;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointPolicyStatusResponse;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointRequest;
import software.amazon.awssdk.services.s3control.model.GetMultiRegionAccessPointResponse;
import software.amazon.awssdk.services.s3control.model.GetPublicAccessBlockRequest;
import software.amazon.awssdk.services.s3control.model.GetPublicAccessBlockResponse;
import software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationResponse;
import software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationTaggingRequest;
import software.amazon.awssdk.services.s3control.model.GetStorageLensConfigurationTaggingResponse;
import software.amazon.awssdk.services.s3control.model.IdempotencyException;
import software.amazon.awssdk.services.s3control.model.InternalServiceException;
import software.amazon.awssdk.services.s3control.model.InvalidNextTokenException;
import software.amazon.awssdk.services.s3control.model.InvalidRequestException;
import software.amazon.awssdk.services.s3control.model.JobStatusException;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsRequest;
import software.amazon.awssdk.services.s3control.model.ListAccessPointsResponse;
import software.amazon.awssdk.services.s3control.model.ListJobsRequest;
import software.amazon.awssdk.services.s3control.model.ListJobsResponse;
import software.amazon.awssdk.services.s3control.model.ListMultiRegionAccessPointsRequest;
import software.amazon.awssdk.services.s3control.model.ListMultiRegionAccessPointsResponse;
import software.amazon.awssdk.services.s3control.model.ListRegionalBucketsRequest;
import software.amazon.awssdk.services.s3control.model.ListRegionalBucketsResponse;
import software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationsRequest;
import software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationsResponse;
import software.amazon.awssdk.services.s3control.model.NoSuchPublicAccessBlockConfigurationException;
import software.amazon.awssdk.services.s3control.model.NotFoundException;
import software.amazon.awssdk.services.s3control.model.PutAccessPointConfigurationForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.PutAccessPointConfigurationForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyForObjectLambdaRequest;
import software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyForObjectLambdaResponse;
import software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyResponse;
import software.amazon.awssdk.services.s3control.model.PutBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.PutBucketLifecycleConfigurationResponse;
import software.amazon.awssdk.services.s3control.model.PutBucketPolicyRequest;
import software.amazon.awssdk.services.s3control.model.PutBucketPolicyResponse;
import software.amazon.awssdk.services.s3control.model.PutBucketTaggingRequest;
import software.amazon.awssdk.services.s3control.model.PutBucketTaggingResponse;
import software.amazon.awssdk.services.s3control.model.PutJobTaggingRequest;
import software.amazon.awssdk.services.s3control.model.PutJobTaggingResponse;
import software.amazon.awssdk.services.s3control.model.PutMultiRegionAccessPointPolicyRequest;
import software.amazon.awssdk.services.s3control.model.PutMultiRegionAccessPointPolicyResponse;
import software.amazon.awssdk.services.s3control.model.PutPublicAccessBlockRequest;
import software.amazon.awssdk.services.s3control.model.PutPublicAccessBlockResponse;
import software.amazon.awssdk.services.s3control.model.PutStorageLensConfigurationRequest;
import software.amazon.awssdk.services.s3control.model.PutStorageLensConfigurationResponse;
import software.amazon.awssdk.services.s3control.model.PutStorageLensConfigurationTaggingRequest;
import software.amazon.awssdk.services.s3control.model.PutStorageLensConfigurationTaggingResponse;
import software.amazon.awssdk.services.s3control.model.S3ControlException;
import software.amazon.awssdk.services.s3control.model.S3ControlRequest;
import software.amazon.awssdk.services.s3control.model.TooManyRequestsException;
import software.amazon.awssdk.services.s3control.model.TooManyTagsException;
import software.amazon.awssdk.services.s3control.model.UpdateJobPriorityRequest;
import software.amazon.awssdk.services.s3control.model.UpdateJobPriorityResponse;
import software.amazon.awssdk.services.s3control.model.UpdateJobStatusRequest;
import software.amazon.awssdk.services.s3control.model.UpdateJobStatusResponse;
import software.amazon.awssdk.services.s3control.paginators.ListAccessPointsForObjectLambdaPublisher;
import software.amazon.awssdk.services.s3control.paginators.ListAccessPointsPublisher;
import software.amazon.awssdk.services.s3control.paginators.ListJobsPublisher;
import software.amazon.awssdk.services.s3control.paginators.ListMultiRegionAccessPointsPublisher;
import software.amazon.awssdk.services.s3control.paginators.ListRegionalBucketsPublisher;
import software.amazon.awssdk.services.s3control.paginators.ListStorageLensConfigurationsPublisher;
import software.amazon.awssdk.services.s3control.transform.CreateAccessPointForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.CreateAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.CreateBucketRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.CreateJobRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.CreateMultiRegionAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteAccessPointForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteAccessPointPolicyForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteAccessPointPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteBucketLifecycleConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteBucketRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteBucketTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteJobTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteMultiRegionAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeletePublicAccessBlockRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteStorageLensConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DeleteStorageLensConfigurationTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DescribeJobRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.DescribeMultiRegionAccessPointOperationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointConfigurationForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointPolicyForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointPolicyStatusForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointPolicyStatusRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetBucketLifecycleConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetBucketRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetBucketTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetJobTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetMultiRegionAccessPointPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetMultiRegionAccessPointPolicyStatusRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetMultiRegionAccessPointRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetPublicAccessBlockRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetStorageLensConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.GetStorageLensConfigurationTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListAccessPointsForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListAccessPointsRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListJobsRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListMultiRegionAccessPointsRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListRegionalBucketsRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.ListStorageLensConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutAccessPointConfigurationForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutAccessPointPolicyForObjectLambdaRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutAccessPointPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutBucketLifecycleConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutBucketTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutJobTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutMultiRegionAccessPointPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutPublicAccessBlockRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutStorageLensConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.PutStorageLensConfigurationTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.UpdateJobPriorityRequestMarshaller;
import software.amazon.awssdk.services.s3control.transform.UpdateJobStatusRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.HostnameValidator;

@SdkInternalApi
final class DefaultS3ControlAsyncClient
implements S3ControlAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultS3ControlAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsXmlProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultS3ControlAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "s3";
    }

    @Override
    public CompletableFuture<CreateAccessPointResponse> createAccessPoint(CreateAccessPointRequest createAccessPointRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, createAccessPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAccessPoint");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateAccessPointResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String bucket = createAccessPointRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = createAccessPointRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                createAccessPointRequest = (CreateAccessPointRequest)((Object)createAccessPointRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)createAccessPointRequest.accountId(), (String)"AccountId", (String)"createAccessPointRequest");
            String resolvedHostExpression = String.format("%s.", createAccessPointRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAccessPoint").withMarshaller((Marshaller)new CreateAccessPointRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withInput((SdkRequest)createAccessPointRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$createAccessPoint$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$createAccessPoint$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateAccessPointForObjectLambdaResponse> createAccessPointForObjectLambda(CreateAccessPointForObjectLambdaRequest createAccessPointForObjectLambdaRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, createAccessPointForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAccessPointForObjectLambda");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateAccessPointForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)createAccessPointForObjectLambdaRequest.accountId(), (String)"AccountId", (String)"createAccessPointForObjectLambdaRequest");
            String resolvedHostExpression = String.format("%s.", createAccessPointForObjectLambdaRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAccessPointForObjectLambda").withMarshaller((Marshaller)new CreateAccessPointForObjectLambdaRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createAccessPointForObjectLambdaRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$createAccessPointForObjectLambda$5(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$createAccessPointForObjectLambda$6((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateBucketResponse> createBucket(CreateBucketRequest createBucketRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, createBucketRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBucket");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateBucketResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBucket").withMarshaller((Marshaller)new CreateBucketRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withInput((SdkRequest)createBucketRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$createBucket$8(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$createBucket$9((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateJobResponse> createJob(CreateJobRequest createJobRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, createJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateJob");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateJobResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)createJobRequest.accountId(), (String)"AccountId", (String)"createJobRequest");
            String resolvedHostExpression = String.format("%s.", createJobRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateJob").withMarshaller((Marshaller)new CreateJobRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createJobRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$createJob$11(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$createJob$12((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateMultiRegionAccessPointResponse> createMultiRegionAccessPoint(CreateMultiRegionAccessPointRequest createMultiRegionAccessPointRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, createMultiRegionAccessPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMultiRegionAccessPoint");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateMultiRegionAccessPointResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)createMultiRegionAccessPointRequest.accountId(), (String)"AccountId", (String)"createMultiRegionAccessPointRequest");
            String resolvedHostExpression = String.format("%s.", createMultiRegionAccessPointRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMultiRegionAccessPoint").withMarshaller((Marshaller)new CreateMultiRegionAccessPointRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withInput((SdkRequest)createMultiRegionAccessPointRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$createMultiRegionAccessPoint$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$createMultiRegionAccessPoint$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAccessPointResponse> deleteAccessPoint(DeleteAccessPointRequest deleteAccessPointRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteAccessPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccessPoint");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteAccessPointResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String name = deleteAccessPointRequest.name();
            Arn arn = null;
            if (name != null && name.startsWith("arn:")) {
                arn = Arn.fromString((String)name);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3AccessPointResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3AccessPointResource resource = (S3AccessPointResource)s3Resource;
                String accountId = deleteAccessPointRequest.accountId();
                String accountIdInArn = (String)resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                deleteAccessPointRequest = (DeleteAccessPointRequest)((Object)deleteAccessPointRequest.toBuilder().name(resource.accessPointName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteAccessPointRequest.accountId(), (String)"AccountId", (String)"deleteAccessPointRequest");
            String resolvedHostExpression = String.format("%s.", deleteAccessPointRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccessPoint").withMarshaller((Marshaller)new DeleteAccessPointRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withInput((SdkRequest)deleteAccessPointRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$deleteAccessPoint$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$deleteAccessPoint$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAccessPointForObjectLambdaResponse> deleteAccessPointForObjectLambda(DeleteAccessPointForObjectLambdaRequest deleteAccessPointForObjectLambdaRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteAccessPointForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccessPointForObjectLambda");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteAccessPointForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteAccessPointForObjectLambdaRequest.accountId(), (String)"AccountId", (String)"deleteAccessPointForObjectLambdaRequest");
            String resolvedHostExpression = String.format("%s.", deleteAccessPointForObjectLambdaRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccessPointForObjectLambda").withMarshaller((Marshaller)new DeleteAccessPointForObjectLambdaRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAccessPointForObjectLambdaRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$deleteAccessPointForObjectLambda$21(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$deleteAccessPointForObjectLambda$22((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAccessPointPolicyResponse> deleteAccessPointPolicy(DeleteAccessPointPolicyRequest deleteAccessPointPolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteAccessPointPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccessPointPolicy");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteAccessPointPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String name = deleteAccessPointPolicyRequest.name();
            Arn arn = null;
            if (name != null && name.startsWith("arn:")) {
                arn = Arn.fromString((String)name);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3AccessPointResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3AccessPointResource resource = (S3AccessPointResource)s3Resource;
                String accountId = deleteAccessPointPolicyRequest.accountId();
                String accountIdInArn = (String)resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                deleteAccessPointPolicyRequest = (DeleteAccessPointPolicyRequest)((Object)deleteAccessPointPolicyRequest.toBuilder().name(resource.accessPointName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteAccessPointPolicyRequest.accountId(), (String)"AccountId", (String)"deleteAccessPointPolicyRequest");
            String resolvedHostExpression = String.format("%s.", deleteAccessPointPolicyRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccessPointPolicy").withMarshaller((Marshaller)new DeleteAccessPointPolicyRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withInput((SdkRequest)deleteAccessPointPolicyRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$deleteAccessPointPolicy$25(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$deleteAccessPointPolicy$26((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAccessPointPolicyForObjectLambdaResponse> deleteAccessPointPolicyForObjectLambda(DeleteAccessPointPolicyForObjectLambdaRequest deleteAccessPointPolicyForObjectLambdaRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteAccessPointPolicyForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAccessPointPolicyForObjectLambda");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteAccessPointPolicyForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteAccessPointPolicyForObjectLambdaRequest.accountId(), (String)"AccountId", (String)"deleteAccessPointPolicyForObjectLambdaRequest");
            String resolvedHostExpression = String.format("%s.", deleteAccessPointPolicyForObjectLambdaRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccessPointPolicyForObjectLambda").withMarshaller((Marshaller)new DeleteAccessPointPolicyForObjectLambdaRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAccessPointPolicyForObjectLambdaRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$deleteAccessPointPolicyForObjectLambda$28(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$deleteAccessPointPolicyForObjectLambda$29((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBucketResponse> deleteBucket(DeleteBucketRequest deleteBucketRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteBucketRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBucket");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String bucket = deleteBucketRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = deleteBucketRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                deleteBucketRequest = (DeleteBucketRequest)((Object)deleteBucketRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteBucketRequest.accountId(), (String)"AccountId", (String)"deleteBucketRequest");
            String resolvedHostExpression = String.format("%s.", deleteBucketRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucket").withMarshaller((Marshaller)new DeleteBucketRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withInput((SdkRequest)deleteBucketRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$deleteBucket$32(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$deleteBucket$33((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBucketLifecycleConfigurationResponse> deleteBucketLifecycleConfiguration(DeleteBucketLifecycleConfigurationRequest deleteBucketLifecycleConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteBucketLifecycleConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBucketLifecycleConfiguration");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketLifecycleConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String bucket = deleteBucketLifecycleConfigurationRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = deleteBucketLifecycleConfigurationRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                deleteBucketLifecycleConfigurationRequest = (DeleteBucketLifecycleConfigurationRequest)((Object)deleteBucketLifecycleConfigurationRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteBucketLifecycleConfigurationRequest.accountId(), (String)"AccountId", (String)"deleteBucketLifecycleConfigurationRequest");
            String resolvedHostExpression = String.format("%s.", deleteBucketLifecycleConfigurationRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketLifecycleConfiguration").withMarshaller((Marshaller)new DeleteBucketLifecycleConfigurationRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withInput((SdkRequest)deleteBucketLifecycleConfigurationRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$deleteBucketLifecycleConfiguration$36(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$deleteBucketLifecycleConfiguration$37((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBucketPolicyResponse> deleteBucketPolicy(DeleteBucketPolicyRequest deleteBucketPolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteBucketPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBucketPolicy");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String bucket = deleteBucketPolicyRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = deleteBucketPolicyRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                deleteBucketPolicyRequest = (DeleteBucketPolicyRequest)((Object)deleteBucketPolicyRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteBucketPolicyRequest.accountId(), (String)"AccountId", (String)"deleteBucketPolicyRequest");
            String resolvedHostExpression = String.format("%s.", deleteBucketPolicyRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketPolicy").withMarshaller((Marshaller)new DeleteBucketPolicyRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withInput((SdkRequest)deleteBucketPolicyRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$deleteBucketPolicy$40(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$deleteBucketPolicy$41((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBucketTaggingResponse> deleteBucketTagging(DeleteBucketTaggingRequest deleteBucketTaggingRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteBucketTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBucketTagging");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String bucket = deleteBucketTaggingRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = deleteBucketTaggingRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                deleteBucketTaggingRequest = (DeleteBucketTaggingRequest)((Object)deleteBucketTaggingRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteBucketTaggingRequest.accountId(), (String)"AccountId", (String)"deleteBucketTaggingRequest");
            String resolvedHostExpression = String.format("%s.", deleteBucketTaggingRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketTagging").withMarshaller((Marshaller)new DeleteBucketTaggingRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withInput((SdkRequest)deleteBucketTaggingRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$deleteBucketTagging$44(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$deleteBucketTagging$45((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteJobTaggingResponse> deleteJobTagging(DeleteJobTaggingRequest deleteJobTaggingRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteJobTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteJobTagging");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteJobTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteJobTaggingRequest.accountId(), (String)"AccountId", (String)"deleteJobTaggingRequest");
            String resolvedHostExpression = String.format("%s.", deleteJobTaggingRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteJobTagging").withMarshaller((Marshaller)new DeleteJobTaggingRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteJobTaggingRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$deleteJobTagging$47(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$deleteJobTagging$48((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteMultiRegionAccessPointResponse> deleteMultiRegionAccessPoint(DeleteMultiRegionAccessPointRequest deleteMultiRegionAccessPointRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteMultiRegionAccessPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMultiRegionAccessPoint");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteMultiRegionAccessPointResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteMultiRegionAccessPointRequest.accountId(), (String)"AccountId", (String)"deleteMultiRegionAccessPointRequest");
            String resolvedHostExpression = String.format("%s.", deleteMultiRegionAccessPointRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMultiRegionAccessPoint").withMarshaller((Marshaller)new DeleteMultiRegionAccessPointRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withInput((SdkRequest)deleteMultiRegionAccessPointRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$deleteMultiRegionAccessPoint$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$deleteMultiRegionAccessPoint$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeletePublicAccessBlockResponse> deletePublicAccessBlock(DeletePublicAccessBlockRequest deletePublicAccessBlockRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, deletePublicAccessBlockRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeletePublicAccessBlock");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeletePublicAccessBlockResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deletePublicAccessBlockRequest.accountId(), (String)"AccountId", (String)"deletePublicAccessBlockRequest");
            String resolvedHostExpression = String.format("%s.", deletePublicAccessBlockRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePublicAccessBlock").withMarshaller((Marshaller)new DeletePublicAccessBlockRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deletePublicAccessBlockRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$deletePublicAccessBlock$53(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$deletePublicAccessBlock$54((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteStorageLensConfigurationResponse> deleteStorageLensConfiguration(DeleteStorageLensConfigurationRequest deleteStorageLensConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteStorageLensConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteStorageLensConfiguration");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteStorageLensConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteStorageLensConfigurationRequest.accountId(), (String)"AccountId", (String)"deleteStorageLensConfigurationRequest");
            String resolvedHostExpression = String.format("%s.", deleteStorageLensConfigurationRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStorageLensConfiguration").withMarshaller((Marshaller)new DeleteStorageLensConfigurationRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteStorageLensConfigurationRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$deleteStorageLensConfiguration$56(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$deleteStorageLensConfiguration$57((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteStorageLensConfigurationTaggingResponse> deleteStorageLensConfigurationTagging(DeleteStorageLensConfigurationTaggingRequest deleteStorageLensConfigurationTaggingRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteStorageLensConfigurationTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteStorageLensConfigurationTagging");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteStorageLensConfigurationTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)deleteStorageLensConfigurationTaggingRequest.accountId(), (String)"AccountId", (String)"deleteStorageLensConfigurationTaggingRequest");
            String resolvedHostExpression = String.format("%s.", deleteStorageLensConfigurationTaggingRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStorageLensConfigurationTagging").withMarshaller((Marshaller)new DeleteStorageLensConfigurationTaggingRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteStorageLensConfigurationTaggingRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$deleteStorageLensConfigurationTagging$59(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$deleteStorageLensConfigurationTagging$60((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeJobResponse> describeJob(DescribeJobRequest describeJobRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeJob");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DescribeJobResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)describeJobRequest.accountId(), (String)"AccountId", (String)"describeJobRequest");
            String resolvedHostExpression = String.format("%s.", describeJobRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeJob").withMarshaller((Marshaller)new DescribeJobRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeJobRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$describeJob$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$describeJob$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeMultiRegionAccessPointOperationResponse> describeMultiRegionAccessPointOperation(DescribeMultiRegionAccessPointOperationRequest describeMultiRegionAccessPointOperationRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeMultiRegionAccessPointOperationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMultiRegionAccessPointOperation");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DescribeMultiRegionAccessPointOperationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)describeMultiRegionAccessPointOperationRequest.accountId(), (String)"AccountId", (String)"describeMultiRegionAccessPointOperationRequest");
            String resolvedHostExpression = String.format("%s.", describeMultiRegionAccessPointOperationRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMultiRegionAccessPointOperation").withMarshaller((Marshaller)new DescribeMultiRegionAccessPointOperationRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withInput((SdkRequest)describeMultiRegionAccessPointOperationRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$describeMultiRegionAccessPointOperation$65(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$describeMultiRegionAccessPointOperation$66((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAccessPointResponse> getAccessPoint(GetAccessPointRequest getAccessPointRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, getAccessPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessPoint");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetAccessPointResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String name = getAccessPointRequest.name();
            Arn arn = null;
            if (name != null && name.startsWith("arn:")) {
                arn = Arn.fromString((String)name);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3AccessPointResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3AccessPointResource resource = (S3AccessPointResource)s3Resource;
                String accountId = getAccessPointRequest.accountId();
                String accountIdInArn = (String)resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                getAccessPointRequest = (GetAccessPointRequest)((Object)getAccessPointRequest.toBuilder().name(resource.accessPointName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getAccessPointRequest.accountId(), (String)"AccountId", (String)"getAccessPointRequest");
            String resolvedHostExpression = String.format("%s.", getAccessPointRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessPoint").withMarshaller((Marshaller)new GetAccessPointRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withInput((SdkRequest)getAccessPointRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$getAccessPoint$69(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$getAccessPoint$70((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAccessPointConfigurationForObjectLambdaResponse> getAccessPointConfigurationForObjectLambda(GetAccessPointConfigurationForObjectLambdaRequest getAccessPointConfigurationForObjectLambdaRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, getAccessPointConfigurationForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessPointConfigurationForObjectLambda");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetAccessPointConfigurationForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getAccessPointConfigurationForObjectLambdaRequest.accountId(), (String)"AccountId", (String)"getAccessPointConfigurationForObjectLambdaRequest");
            String resolvedHostExpression = String.format("%s.", getAccessPointConfigurationForObjectLambdaRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessPointConfigurationForObjectLambda").withMarshaller((Marshaller)new GetAccessPointConfigurationForObjectLambdaRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAccessPointConfigurationForObjectLambdaRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$getAccessPointConfigurationForObjectLambda$72(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$getAccessPointConfigurationForObjectLambda$73((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAccessPointForObjectLambdaResponse> getAccessPointForObjectLambda(GetAccessPointForObjectLambdaRequest getAccessPointForObjectLambdaRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, getAccessPointForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessPointForObjectLambda");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetAccessPointForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getAccessPointForObjectLambdaRequest.accountId(), (String)"AccountId", (String)"getAccessPointForObjectLambdaRequest");
            String resolvedHostExpression = String.format("%s.", getAccessPointForObjectLambdaRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessPointForObjectLambda").withMarshaller((Marshaller)new GetAccessPointForObjectLambdaRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAccessPointForObjectLambdaRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$getAccessPointForObjectLambda$75(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$getAccessPointForObjectLambda$76((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAccessPointPolicyResponse> getAccessPointPolicy(GetAccessPointPolicyRequest getAccessPointPolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, getAccessPointPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessPointPolicy");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetAccessPointPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String name = getAccessPointPolicyRequest.name();
            Arn arn = null;
            if (name != null && name.startsWith("arn:")) {
                arn = Arn.fromString((String)name);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3AccessPointResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3AccessPointResource resource = (S3AccessPointResource)s3Resource;
                String accountId = getAccessPointPolicyRequest.accountId();
                String accountIdInArn = (String)resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                getAccessPointPolicyRequest = (GetAccessPointPolicyRequest)((Object)getAccessPointPolicyRequest.toBuilder().name(resource.accessPointName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getAccessPointPolicyRequest.accountId(), (String)"AccountId", (String)"getAccessPointPolicyRequest");
            String resolvedHostExpression = String.format("%s.", getAccessPointPolicyRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessPointPolicy").withMarshaller((Marshaller)new GetAccessPointPolicyRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withInput((SdkRequest)getAccessPointPolicyRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$getAccessPointPolicy$79(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$getAccessPointPolicy$80((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAccessPointPolicyForObjectLambdaResponse> getAccessPointPolicyForObjectLambda(GetAccessPointPolicyForObjectLambdaRequest getAccessPointPolicyForObjectLambdaRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, getAccessPointPolicyForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessPointPolicyForObjectLambda");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetAccessPointPolicyForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getAccessPointPolicyForObjectLambdaRequest.accountId(), (String)"AccountId", (String)"getAccessPointPolicyForObjectLambdaRequest");
            String resolvedHostExpression = String.format("%s.", getAccessPointPolicyForObjectLambdaRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessPointPolicyForObjectLambda").withMarshaller((Marshaller)new GetAccessPointPolicyForObjectLambdaRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAccessPointPolicyForObjectLambdaRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$getAccessPointPolicyForObjectLambda$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$getAccessPointPolicyForObjectLambda$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAccessPointPolicyStatusResponse> getAccessPointPolicyStatus(GetAccessPointPolicyStatusRequest getAccessPointPolicyStatusRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, getAccessPointPolicyStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessPointPolicyStatus");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetAccessPointPolicyStatusResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getAccessPointPolicyStatusRequest.accountId(), (String)"AccountId", (String)"getAccessPointPolicyStatusRequest");
            String resolvedHostExpression = String.format("%s.", getAccessPointPolicyStatusRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessPointPolicyStatus").withMarshaller((Marshaller)new GetAccessPointPolicyStatusRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAccessPointPolicyStatusRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$getAccessPointPolicyStatus$85(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$getAccessPointPolicyStatus$86((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAccessPointPolicyStatusForObjectLambdaResponse> getAccessPointPolicyStatusForObjectLambda(GetAccessPointPolicyStatusForObjectLambdaRequest getAccessPointPolicyStatusForObjectLambdaRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, getAccessPointPolicyStatusForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccessPointPolicyStatusForObjectLambda");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetAccessPointPolicyStatusForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getAccessPointPolicyStatusForObjectLambdaRequest.accountId(), (String)"AccountId", (String)"getAccessPointPolicyStatusForObjectLambdaRequest");
            String resolvedHostExpression = String.format("%s.", getAccessPointPolicyStatusForObjectLambdaRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccessPointPolicyStatusForObjectLambda").withMarshaller((Marshaller)new GetAccessPointPolicyStatusForObjectLambdaRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAccessPointPolicyStatusForObjectLambdaRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$getAccessPointPolicyStatusForObjectLambda$88(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$getAccessPointPolicyStatusForObjectLambda$89((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketResponse> getBucket(GetBucketRequest getBucketRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, getBucketRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBucket");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String bucket = getBucketRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = getBucketRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                getBucketRequest = (GetBucketRequest)((Object)getBucketRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getBucketRequest.accountId(), (String)"AccountId", (String)"getBucketRequest");
            String resolvedHostExpression = String.format("%s.", getBucketRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucket").withMarshaller((Marshaller)new GetBucketRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withInput((SdkRequest)getBucketRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$getBucket$92(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$getBucket$93((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketLifecycleConfigurationResponse> getBucketLifecycleConfiguration(GetBucketLifecycleConfigurationRequest getBucketLifecycleConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, getBucketLifecycleConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBucketLifecycleConfiguration");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketLifecycleConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String bucket = getBucketLifecycleConfigurationRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = getBucketLifecycleConfigurationRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                getBucketLifecycleConfigurationRequest = (GetBucketLifecycleConfigurationRequest)((Object)getBucketLifecycleConfigurationRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getBucketLifecycleConfigurationRequest.accountId(), (String)"AccountId", (String)"getBucketLifecycleConfigurationRequest");
            String resolvedHostExpression = String.format("%s.", getBucketLifecycleConfigurationRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketLifecycleConfiguration").withMarshaller((Marshaller)new GetBucketLifecycleConfigurationRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withInput((SdkRequest)getBucketLifecycleConfigurationRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$getBucketLifecycleConfiguration$96(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$getBucketLifecycleConfiguration$97((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketPolicyResponse> getBucketPolicy(GetBucketPolicyRequest getBucketPolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, getBucketPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBucketPolicy");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String bucket = getBucketPolicyRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = getBucketPolicyRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                getBucketPolicyRequest = (GetBucketPolicyRequest)((Object)getBucketPolicyRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getBucketPolicyRequest.accountId(), (String)"AccountId", (String)"getBucketPolicyRequest");
            String resolvedHostExpression = String.format("%s.", getBucketPolicyRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketPolicy").withMarshaller((Marshaller)new GetBucketPolicyRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withInput((SdkRequest)getBucketPolicyRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$getBucketPolicy$100(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$getBucketPolicy$101((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketTaggingResponse> getBucketTagging(GetBucketTaggingRequest getBucketTaggingRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, getBucketTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBucketTagging");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String bucket = getBucketTaggingRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = getBucketTaggingRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                getBucketTaggingRequest = (GetBucketTaggingRequest)((Object)getBucketTaggingRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getBucketTaggingRequest.accountId(), (String)"AccountId", (String)"getBucketTaggingRequest");
            String resolvedHostExpression = String.format("%s.", getBucketTaggingRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketTagging").withMarshaller((Marshaller)new GetBucketTaggingRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withInput((SdkRequest)getBucketTaggingRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$getBucketTagging$104(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$getBucketTagging$105((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetJobTaggingResponse> getJobTagging(GetJobTaggingRequest getJobTaggingRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, getJobTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetJobTagging");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetJobTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getJobTaggingRequest.accountId(), (String)"AccountId", (String)"getJobTaggingRequest");
            String resolvedHostExpression = String.format("%s.", getJobTaggingRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetJobTagging").withMarshaller((Marshaller)new GetJobTaggingRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getJobTaggingRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$getJobTagging$107(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$getJobTagging$108((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetMultiRegionAccessPointResponse> getMultiRegionAccessPoint(GetMultiRegionAccessPointRequest getMultiRegionAccessPointRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, getMultiRegionAccessPointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMultiRegionAccessPoint");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetMultiRegionAccessPointResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getMultiRegionAccessPointRequest.accountId(), (String)"AccountId", (String)"getMultiRegionAccessPointRequest");
            String resolvedHostExpression = String.format("%s.", getMultiRegionAccessPointRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMultiRegionAccessPoint").withMarshaller((Marshaller)new GetMultiRegionAccessPointRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withInput((SdkRequest)getMultiRegionAccessPointRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$getMultiRegionAccessPoint$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$getMultiRegionAccessPoint$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetMultiRegionAccessPointPolicyResponse> getMultiRegionAccessPointPolicy(GetMultiRegionAccessPointPolicyRequest getMultiRegionAccessPointPolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, getMultiRegionAccessPointPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMultiRegionAccessPointPolicy");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetMultiRegionAccessPointPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getMultiRegionAccessPointPolicyRequest.accountId(), (String)"AccountId", (String)"getMultiRegionAccessPointPolicyRequest");
            String resolvedHostExpression = String.format("%s.", getMultiRegionAccessPointPolicyRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMultiRegionAccessPointPolicy").withMarshaller((Marshaller)new GetMultiRegionAccessPointPolicyRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withInput((SdkRequest)getMultiRegionAccessPointPolicyRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$getMultiRegionAccessPointPolicy$113(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$getMultiRegionAccessPointPolicy$114((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetMultiRegionAccessPointPolicyStatusResponse> getMultiRegionAccessPointPolicyStatus(GetMultiRegionAccessPointPolicyStatusRequest getMultiRegionAccessPointPolicyStatusRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, getMultiRegionAccessPointPolicyStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMultiRegionAccessPointPolicyStatus");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetMultiRegionAccessPointPolicyStatusResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getMultiRegionAccessPointPolicyStatusRequest.accountId(), (String)"AccountId", (String)"getMultiRegionAccessPointPolicyStatusRequest");
            String resolvedHostExpression = String.format("%s.", getMultiRegionAccessPointPolicyStatusRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMultiRegionAccessPointPolicyStatus").withMarshaller((Marshaller)new GetMultiRegionAccessPointPolicyStatusRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withInput((SdkRequest)getMultiRegionAccessPointPolicyStatusRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$getMultiRegionAccessPointPolicyStatus$116(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$getMultiRegionAccessPointPolicyStatus$117((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetPublicAccessBlockResponse> getPublicAccessBlock(GetPublicAccessBlockRequest getPublicAccessBlockRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, getPublicAccessBlockRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPublicAccessBlock");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetPublicAccessBlockResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getPublicAccessBlockRequest.accountId(), (String)"AccountId", (String)"getPublicAccessBlockRequest");
            String resolvedHostExpression = String.format("%s.", getPublicAccessBlockRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPublicAccessBlock").withMarshaller((Marshaller)new GetPublicAccessBlockRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getPublicAccessBlockRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$getPublicAccessBlock$119(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$getPublicAccessBlock$120((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetStorageLensConfigurationResponse> getStorageLensConfiguration(GetStorageLensConfigurationRequest getStorageLensConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, getStorageLensConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetStorageLensConfiguration");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetStorageLensConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getStorageLensConfigurationRequest.accountId(), (String)"AccountId", (String)"getStorageLensConfigurationRequest");
            String resolvedHostExpression = String.format("%s.", getStorageLensConfigurationRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetStorageLensConfiguration").withMarshaller((Marshaller)new GetStorageLensConfigurationRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getStorageLensConfigurationRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$getStorageLensConfiguration$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$getStorageLensConfiguration$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetStorageLensConfigurationTaggingResponse> getStorageLensConfigurationTagging(GetStorageLensConfigurationTaggingRequest getStorageLensConfigurationTaggingRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, getStorageLensConfigurationTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetStorageLensConfigurationTagging");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetStorageLensConfigurationTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)getStorageLensConfigurationTaggingRequest.accountId(), (String)"AccountId", (String)"getStorageLensConfigurationTaggingRequest");
            String resolvedHostExpression = String.format("%s.", getStorageLensConfigurationTaggingRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetStorageLensConfigurationTagging").withMarshaller((Marshaller)new GetStorageLensConfigurationTaggingRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getStorageLensConfigurationTaggingRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$getStorageLensConfigurationTagging$125(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$getStorageLensConfigurationTagging$126((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAccessPointsResponse> listAccessPoints(ListAccessPointsRequest listAccessPointsRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, listAccessPointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAccessPoints");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListAccessPointsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String bucket = listAccessPointsRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = listAccessPointsRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                listAccessPointsRequest = (ListAccessPointsRequest)((Object)listAccessPointsRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)listAccessPointsRequest.accountId(), (String)"AccountId", (String)"listAccessPointsRequest");
            String resolvedHostExpression = String.format("%s.", listAccessPointsRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccessPoints").withMarshaller((Marshaller)new ListAccessPointsRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withInput((SdkRequest)listAccessPointsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$listAccessPoints$129(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$listAccessPoints$130((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAccessPointsForObjectLambdaResponse> listAccessPointsForObjectLambda(ListAccessPointsForObjectLambdaRequest listAccessPointsForObjectLambdaRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, listAccessPointsForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAccessPointsForObjectLambda");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListAccessPointsForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)listAccessPointsForObjectLambdaRequest.accountId(), (String)"AccountId", (String)"listAccessPointsForObjectLambdaRequest");
            String resolvedHostExpression = String.format("%s.", listAccessPointsForObjectLambdaRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccessPointsForObjectLambda").withMarshaller((Marshaller)new ListAccessPointsForObjectLambdaRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAccessPointsForObjectLambdaRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$listAccessPointsForObjectLambda$132(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$listAccessPointsForObjectLambda$133((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListAccessPointsForObjectLambdaPublisher listAccessPointsForObjectLambdaPaginator(ListAccessPointsForObjectLambdaRequest listAccessPointsForObjectLambdaRequest) {
        return new ListAccessPointsForObjectLambdaPublisher(this, this.applyPaginatorUserAgent(listAccessPointsForObjectLambdaRequest));
    }

    @Override
    public ListAccessPointsPublisher listAccessPointsPaginator(ListAccessPointsRequest listAccessPointsRequest) {
        return new ListAccessPointsPublisher(this, this.applyPaginatorUserAgent(listAccessPointsRequest));
    }

    @Override
    public CompletableFuture<ListJobsResponse> listJobs(ListJobsRequest listJobsRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, listJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListJobs");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListJobsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)listJobsRequest.accountId(), (String)"AccountId", (String)"listJobsRequest");
            String resolvedHostExpression = String.format("%s.", listJobsRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListJobs").withMarshaller((Marshaller)new ListJobsRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listJobsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$listJobs$135(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$listJobs$136((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListJobsPublisher listJobsPaginator(ListJobsRequest listJobsRequest) {
        return new ListJobsPublisher(this, this.applyPaginatorUserAgent(listJobsRequest));
    }

    @Override
    public CompletableFuture<ListMultiRegionAccessPointsResponse> listMultiRegionAccessPoints(ListMultiRegionAccessPointsRequest listMultiRegionAccessPointsRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, listMultiRegionAccessPointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMultiRegionAccessPoints");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListMultiRegionAccessPointsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)listMultiRegionAccessPointsRequest.accountId(), (String)"AccountId", (String)"listMultiRegionAccessPointsRequest");
            String resolvedHostExpression = String.format("%s.", listMultiRegionAccessPointsRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMultiRegionAccessPoints").withMarshaller((Marshaller)new ListMultiRegionAccessPointsRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withInput((SdkRequest)listMultiRegionAccessPointsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$listMultiRegionAccessPoints$138(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$listMultiRegionAccessPoints$139((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListMultiRegionAccessPointsPublisher listMultiRegionAccessPointsPaginator(ListMultiRegionAccessPointsRequest listMultiRegionAccessPointsRequest) {
        return new ListMultiRegionAccessPointsPublisher(this, this.applyPaginatorUserAgent(listMultiRegionAccessPointsRequest));
    }

    @Override
    public CompletableFuture<ListRegionalBucketsResponse> listRegionalBuckets(ListRegionalBucketsRequest listRegionalBucketsRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, listRegionalBucketsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRegionalBuckets");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListRegionalBucketsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)listRegionalBucketsRequest.accountId(), (String)"AccountId", (String)"listRegionalBucketsRequest");
            String resolvedHostExpression = String.format("%s.", listRegionalBucketsRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRegionalBuckets").withMarshaller((Marshaller)new ListRegionalBucketsRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listRegionalBucketsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$listRegionalBuckets$141(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$listRegionalBuckets$142((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListRegionalBucketsPublisher listRegionalBucketsPaginator(ListRegionalBucketsRequest listRegionalBucketsRequest) {
        return new ListRegionalBucketsPublisher(this, this.applyPaginatorUserAgent(listRegionalBucketsRequest));
    }

    @Override
    public CompletableFuture<ListStorageLensConfigurationsResponse> listStorageLensConfigurations(ListStorageLensConfigurationsRequest listStorageLensConfigurationsRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, listStorageLensConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListStorageLensConfigurations");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListStorageLensConfigurationsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)listStorageLensConfigurationsRequest.accountId(), (String)"AccountId", (String)"listStorageLensConfigurationsRequest");
            String resolvedHostExpression = String.format("%s.", listStorageLensConfigurationsRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStorageLensConfigurations").withMarshaller((Marshaller)new ListStorageLensConfigurationsRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listStorageLensConfigurationsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$listStorageLensConfigurations$144(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$listStorageLensConfigurations$145((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListStorageLensConfigurationsPublisher listStorageLensConfigurationsPaginator(ListStorageLensConfigurationsRequest listStorageLensConfigurationsRequest) {
        return new ListStorageLensConfigurationsPublisher(this, this.applyPaginatorUserAgent(listStorageLensConfigurationsRequest));
    }

    @Override
    public CompletableFuture<PutAccessPointConfigurationForObjectLambdaResponse> putAccessPointConfigurationForObjectLambda(PutAccessPointConfigurationForObjectLambdaRequest putAccessPointConfigurationForObjectLambdaRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, putAccessPointConfigurationForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAccessPointConfigurationForObjectLambda");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutAccessPointConfigurationForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)putAccessPointConfigurationForObjectLambdaRequest.accountId(), (String)"AccountId", (String)"putAccessPointConfigurationForObjectLambdaRequest");
            String resolvedHostExpression = String.format("%s.", putAccessPointConfigurationForObjectLambdaRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccessPointConfigurationForObjectLambda").withMarshaller((Marshaller)new PutAccessPointConfigurationForObjectLambdaRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putAccessPointConfigurationForObjectLambdaRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$putAccessPointConfigurationForObjectLambda$147(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$putAccessPointConfigurationForObjectLambda$148((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutAccessPointPolicyResponse> putAccessPointPolicy(PutAccessPointPolicyRequest putAccessPointPolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, putAccessPointPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAccessPointPolicy");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutAccessPointPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String name = putAccessPointPolicyRequest.name();
            Arn arn = null;
            if (name != null && name.startsWith("arn:")) {
                arn = Arn.fromString((String)name);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3AccessPointResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3AccessPointResource resource = (S3AccessPointResource)s3Resource;
                String accountId = putAccessPointPolicyRequest.accountId();
                String accountIdInArn = (String)resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                putAccessPointPolicyRequest = (PutAccessPointPolicyRequest)((Object)putAccessPointPolicyRequest.toBuilder().name(resource.accessPointName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)putAccessPointPolicyRequest.accountId(), (String)"AccountId", (String)"putAccessPointPolicyRequest");
            String resolvedHostExpression = String.format("%s.", putAccessPointPolicyRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccessPointPolicy").withMarshaller((Marshaller)new PutAccessPointPolicyRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withInput((SdkRequest)putAccessPointPolicyRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$putAccessPointPolicy$151(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$putAccessPointPolicy$152((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutAccessPointPolicyForObjectLambdaResponse> putAccessPointPolicyForObjectLambda(PutAccessPointPolicyForObjectLambdaRequest putAccessPointPolicyForObjectLambdaRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, putAccessPointPolicyForObjectLambdaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAccessPointPolicyForObjectLambda");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutAccessPointPolicyForObjectLambdaResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)putAccessPointPolicyForObjectLambdaRequest.accountId(), (String)"AccountId", (String)"putAccessPointPolicyForObjectLambdaRequest");
            String resolvedHostExpression = String.format("%s.", putAccessPointPolicyForObjectLambdaRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAccessPointPolicyForObjectLambda").withMarshaller((Marshaller)new PutAccessPointPolicyForObjectLambdaRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putAccessPointPolicyForObjectLambdaRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$putAccessPointPolicyForObjectLambda$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$putAccessPointPolicyForObjectLambda$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutBucketLifecycleConfigurationResponse> putBucketLifecycleConfiguration(PutBucketLifecycleConfigurationRequest putBucketLifecycleConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, putBucketLifecycleConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutBucketLifecycleConfiguration");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketLifecycleConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String bucket = putBucketLifecycleConfigurationRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = putBucketLifecycleConfigurationRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                putBucketLifecycleConfigurationRequest = (PutBucketLifecycleConfigurationRequest)((Object)putBucketLifecycleConfigurationRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)putBucketLifecycleConfigurationRequest.accountId(), (String)"AccountId", (String)"putBucketLifecycleConfigurationRequest");
            String resolvedHostExpression = String.format("%s.", putBucketLifecycleConfigurationRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketLifecycleConfiguration").withMarshaller((Marshaller)new PutBucketLifecycleConfigurationRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withInput((SdkRequest)putBucketLifecycleConfigurationRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$putBucketLifecycleConfiguration$158(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$putBucketLifecycleConfiguration$159((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutBucketPolicyResponse> putBucketPolicy(PutBucketPolicyRequest putBucketPolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, putBucketPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutBucketPolicy");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String bucket = putBucketPolicyRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = putBucketPolicyRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                putBucketPolicyRequest = (PutBucketPolicyRequest)((Object)putBucketPolicyRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)putBucketPolicyRequest.accountId(), (String)"AccountId", (String)"putBucketPolicyRequest");
            String resolvedHostExpression = String.format("%s.", putBucketPolicyRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketPolicy").withMarshaller((Marshaller)new PutBucketPolicyRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withInput((SdkRequest)putBucketPolicyRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$putBucketPolicy$162(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$putBucketPolicy$163((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutBucketTaggingResponse> putBucketTagging(PutBucketTaggingRequest putBucketTaggingRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, putBucketTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutBucketTagging");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String bucket = putBucketTaggingRequest.bucket();
            Arn arn = null;
            if (bucket != null && bucket.startsWith("arn:")) {
                arn = Arn.fromString((String)bucket);
                S3Resource s3Resource = S3ControlArnConverter.getInstance().convertArn(arn);
                if (!(s3Resource instanceof S3ControlBucketResource)) {
                    throw new IllegalArgumentException(String.format("Unsupported ARN type: %s", s3Resource.type()));
                }
                S3ControlBucketResource resource = (S3ControlBucketResource)s3Resource;
                String accountId = putBucketTaggingRequest.accountId();
                String accountIdInArn = resource.accountId().orElseThrow(() -> new IllegalArgumentException("accountId cannot be null"));
                if (accountId != null && !accountId.equals(accountIdInArn)) {
                    throw new IllegalArgumentException(String.format("%s field provided from the request (%s) is different from the one in the ARN (%s)", "accountId", accountId, accountIdInArn));
                }
                putBucketTaggingRequest = (PutBucketTaggingRequest)((Object)putBucketTaggingRequest.toBuilder().bucket(resource.bucketName()).accountId(accountIdInArn).build());
            }
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)putBucketTaggingRequest.accountId(), (String)"AccountId", (String)"putBucketTaggingRequest");
            String resolvedHostExpression = String.format("%s.", putBucketTaggingRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketTagging").withMarshaller((Marshaller)new PutBucketTaggingRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).putExecutionAttribute(S3ControlInternalExecutionAttribute.S3_ARNABLE_FIELD, (Object)S3ArnableField.builder().arn(arn).build()).withInput((SdkRequest)putBucketTaggingRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$putBucketTagging$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$putBucketTagging$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutJobTaggingResponse> putJobTagging(PutJobTaggingRequest putJobTaggingRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, putJobTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutJobTagging");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutJobTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)putJobTaggingRequest.accountId(), (String)"AccountId", (String)"putJobTaggingRequest");
            String resolvedHostExpression = String.format("%s.", putJobTaggingRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutJobTagging").withMarshaller((Marshaller)new PutJobTaggingRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putJobTaggingRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$putJobTagging$169(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$putJobTagging$170((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutMultiRegionAccessPointPolicyResponse> putMultiRegionAccessPointPolicy(PutMultiRegionAccessPointPolicyRequest putMultiRegionAccessPointPolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, putMultiRegionAccessPointPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutMultiRegionAccessPointPolicy");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutMultiRegionAccessPointPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)putMultiRegionAccessPointPolicyRequest.accountId(), (String)"AccountId", (String)"putMultiRegionAccessPointPolicyRequest");
            String resolvedHostExpression = String.format("%s.", putMultiRegionAccessPointPolicyRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutMultiRegionAccessPointPolicy").withMarshaller((Marshaller)new PutMultiRegionAccessPointPolicyRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).putExecutionAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM_REQUIRED, (Object)HttpChecksumRequired.create()).withInput((SdkRequest)putMultiRegionAccessPointPolicyRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$putMultiRegionAccessPointPolicy$172(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$putMultiRegionAccessPointPolicy$173((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutPublicAccessBlockResponse> putPublicAccessBlock(PutPublicAccessBlockRequest putPublicAccessBlockRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, putPublicAccessBlockRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutPublicAccessBlock");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutPublicAccessBlockResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)putPublicAccessBlockRequest.accountId(), (String)"AccountId", (String)"putPublicAccessBlockRequest");
            String resolvedHostExpression = String.format("%s.", putPublicAccessBlockRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutPublicAccessBlock").withMarshaller((Marshaller)new PutPublicAccessBlockRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putPublicAccessBlockRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$putPublicAccessBlock$175(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$putPublicAccessBlock$176((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutStorageLensConfigurationResponse> putStorageLensConfiguration(PutStorageLensConfigurationRequest putStorageLensConfigurationRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, putStorageLensConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutStorageLensConfiguration");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutStorageLensConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)putStorageLensConfigurationRequest.accountId(), (String)"AccountId", (String)"putStorageLensConfigurationRequest");
            String resolvedHostExpression = String.format("%s.", putStorageLensConfigurationRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutStorageLensConfiguration").withMarshaller((Marshaller)new PutStorageLensConfigurationRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putStorageLensConfigurationRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$putStorageLensConfiguration$178(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$putStorageLensConfiguration$179((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutStorageLensConfigurationTaggingResponse> putStorageLensConfigurationTagging(PutStorageLensConfigurationTaggingRequest putStorageLensConfigurationTaggingRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, putStorageLensConfigurationTaggingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutStorageLensConfigurationTagging");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutStorageLensConfigurationTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)putStorageLensConfigurationTaggingRequest.accountId(), (String)"AccountId", (String)"putStorageLensConfigurationTaggingRequest");
            String resolvedHostExpression = String.format("%s.", putStorageLensConfigurationTaggingRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutStorageLensConfigurationTagging").withMarshaller((Marshaller)new PutStorageLensConfigurationTaggingRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putStorageLensConfigurationTaggingRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$putStorageLensConfigurationTagging$181(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$putStorageLensConfigurationTagging$182((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateJobPriorityResponse> updateJobPriority(UpdateJobPriorityRequest updateJobPriorityRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateJobPriorityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateJobPriority");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateJobPriorityResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)updateJobPriorityRequest.accountId(), (String)"AccountId", (String)"updateJobPriorityRequest");
            String resolvedHostExpression = String.format("%s.", updateJobPriorityRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateJobPriority").withMarshaller((Marshaller)new UpdateJobPriorityRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateJobPriorityRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$updateJobPriority$184(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$updateJobPriority$185((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateJobStatusResponse> updateJobStatus(UpdateJobStatusRequest updateJobStatusRequest) {
        List<MetricPublisher> metricPublishers = DefaultS3ControlAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateJobStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"S3 Control");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateJobStatus");
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateJobStatusResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            String hostPrefix = "{AccountId}.";
            HostnameValidator.validateHostnameCompliant((String)updateJobStatusRequest.accountId(), (String)"AccountId", (String)"updateJobStatusRequest");
            String resolvedHostExpression = String.format("%s.", updateJobStatusRequest.accountId());
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateJobStatus").withMarshaller((Marshaller)new UpdateJobStatusRequestMarshaller(this.protocolFactory)).withCombinedResponseHandler(responseHandler).hostPrefixExpression(resolvedHostExpression).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateJobStatusRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultS3ControlAsyncClient.lambda$updateJobStatus$187(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
            return whenCompleteFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultS3ControlAsyncClient.lambda$updateJobStatus$188((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private AwsXmlProtocolFactory init() {
        return AwsXmlProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("JobStatusException").exceptionBuilderSupplier(JobStatusException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchPublicAccessBlockConfiguration").exceptionBuilderSupplier(NoSuchPublicAccessBlockConfigurationException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BucketAlreadyExists").exceptionBuilderSupplier(BucketAlreadyExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotFoundException").exceptionBuilderSupplier(NotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTagsException").exceptionBuilderSupplier(TooManyTagsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IdempotencyException").exceptionBuilderSupplier(IdempotencyException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BucketAlreadyOwnedByYou").exceptionBuilderSupplier(BucketAlreadyOwnedByYouException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRequestsException").exceptionBuilderSupplier(TooManyRequestsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BadRequestException").exceptionBuilderSupplier(BadRequestException::builder).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(S3ControlException::builder).build();
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends S3ControlRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.211").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((S3ControlRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateJobStatus$188(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateJobStatus$187(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateJobStatusResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateJobPriority$185(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateJobPriority$184(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateJobPriorityResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putStorageLensConfigurationTagging$182(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putStorageLensConfigurationTagging$181(List metricPublishers, MetricCollector apiCallMetricCollector, PutStorageLensConfigurationTaggingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putStorageLensConfiguration$179(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putStorageLensConfiguration$178(List metricPublishers, MetricCollector apiCallMetricCollector, PutStorageLensConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putPublicAccessBlock$176(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putPublicAccessBlock$175(List metricPublishers, MetricCollector apiCallMetricCollector, PutPublicAccessBlockResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putMultiRegionAccessPointPolicy$173(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putMultiRegionAccessPointPolicy$172(List metricPublishers, MetricCollector apiCallMetricCollector, PutMultiRegionAccessPointPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putJobTagging$170(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putJobTagging$169(List metricPublishers, MetricCollector apiCallMetricCollector, PutJobTaggingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putBucketTagging$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putBucketTagging$166(List metricPublishers, MetricCollector apiCallMetricCollector, PutBucketTaggingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putBucketPolicy$163(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putBucketPolicy$162(List metricPublishers, MetricCollector apiCallMetricCollector, PutBucketPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putBucketLifecycleConfiguration$159(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putBucketLifecycleConfiguration$158(List metricPublishers, MetricCollector apiCallMetricCollector, PutBucketLifecycleConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putAccessPointPolicyForObjectLambda$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAccessPointPolicyForObjectLambda$154(List metricPublishers, MetricCollector apiCallMetricCollector, PutAccessPointPolicyForObjectLambdaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putAccessPointPolicy$152(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAccessPointPolicy$151(List metricPublishers, MetricCollector apiCallMetricCollector, PutAccessPointPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putAccessPointConfigurationForObjectLambda$148(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAccessPointConfigurationForObjectLambda$147(List metricPublishers, MetricCollector apiCallMetricCollector, PutAccessPointConfigurationForObjectLambdaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listStorageLensConfigurations$145(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listStorageLensConfigurations$144(List metricPublishers, MetricCollector apiCallMetricCollector, ListStorageLensConfigurationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listRegionalBuckets$142(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRegionalBuckets$141(List metricPublishers, MetricCollector apiCallMetricCollector, ListRegionalBucketsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listMultiRegionAccessPoints$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMultiRegionAccessPoints$138(List metricPublishers, MetricCollector apiCallMetricCollector, ListMultiRegionAccessPointsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listJobs$136(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listJobs$135(List metricPublishers, MetricCollector apiCallMetricCollector, ListJobsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listAccessPointsForObjectLambda$133(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAccessPointsForObjectLambda$132(List metricPublishers, MetricCollector apiCallMetricCollector, ListAccessPointsForObjectLambdaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listAccessPoints$130(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAccessPoints$129(List metricPublishers, MetricCollector apiCallMetricCollector, ListAccessPointsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getStorageLensConfigurationTagging$126(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getStorageLensConfigurationTagging$125(List metricPublishers, MetricCollector apiCallMetricCollector, GetStorageLensConfigurationTaggingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getStorageLensConfiguration$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getStorageLensConfiguration$122(List metricPublishers, MetricCollector apiCallMetricCollector, GetStorageLensConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getPublicAccessBlock$120(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPublicAccessBlock$119(List metricPublishers, MetricCollector apiCallMetricCollector, GetPublicAccessBlockResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getMultiRegionAccessPointPolicyStatus$117(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMultiRegionAccessPointPolicyStatus$116(List metricPublishers, MetricCollector apiCallMetricCollector, GetMultiRegionAccessPointPolicyStatusResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getMultiRegionAccessPointPolicy$114(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMultiRegionAccessPointPolicy$113(List metricPublishers, MetricCollector apiCallMetricCollector, GetMultiRegionAccessPointPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getMultiRegionAccessPoint$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMultiRegionAccessPoint$110(List metricPublishers, MetricCollector apiCallMetricCollector, GetMultiRegionAccessPointResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getJobTagging$108(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getJobTagging$107(List metricPublishers, MetricCollector apiCallMetricCollector, GetJobTaggingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getBucketTagging$105(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBucketTagging$104(List metricPublishers, MetricCollector apiCallMetricCollector, GetBucketTaggingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getBucketPolicy$101(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBucketPolicy$100(List metricPublishers, MetricCollector apiCallMetricCollector, GetBucketPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getBucketLifecycleConfiguration$97(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBucketLifecycleConfiguration$96(List metricPublishers, MetricCollector apiCallMetricCollector, GetBucketLifecycleConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getBucket$93(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBucket$92(List metricPublishers, MetricCollector apiCallMetricCollector, GetBucketResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAccessPointPolicyStatusForObjectLambda$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccessPointPolicyStatusForObjectLambda$88(List metricPublishers, MetricCollector apiCallMetricCollector, GetAccessPointPolicyStatusForObjectLambdaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAccessPointPolicyStatus$86(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccessPointPolicyStatus$85(List metricPublishers, MetricCollector apiCallMetricCollector, GetAccessPointPolicyStatusResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAccessPointPolicyForObjectLambda$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccessPointPolicyForObjectLambda$82(List metricPublishers, MetricCollector apiCallMetricCollector, GetAccessPointPolicyForObjectLambdaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAccessPointPolicy$80(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccessPointPolicy$79(List metricPublishers, MetricCollector apiCallMetricCollector, GetAccessPointPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAccessPointForObjectLambda$76(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccessPointForObjectLambda$75(List metricPublishers, MetricCollector apiCallMetricCollector, GetAccessPointForObjectLambdaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAccessPointConfigurationForObjectLambda$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccessPointConfigurationForObjectLambda$72(List metricPublishers, MetricCollector apiCallMetricCollector, GetAccessPointConfigurationForObjectLambdaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAccessPoint$70(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAccessPoint$69(List metricPublishers, MetricCollector apiCallMetricCollector, GetAccessPointResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeMultiRegionAccessPointOperation$66(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMultiRegionAccessPointOperation$65(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeMultiRegionAccessPointOperationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeJob$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeJob$62(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteStorageLensConfigurationTagging$60(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteStorageLensConfigurationTagging$59(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteStorageLensConfigurationTaggingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteStorageLensConfiguration$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteStorageLensConfiguration$56(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteStorageLensConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deletePublicAccessBlock$54(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deletePublicAccessBlock$53(List metricPublishers, MetricCollector apiCallMetricCollector, DeletePublicAccessBlockResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteMultiRegionAccessPoint$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMultiRegionAccessPoint$50(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteMultiRegionAccessPointResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteJobTagging$48(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteJobTagging$47(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteJobTaggingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteBucketTagging$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBucketTagging$44(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteBucketTaggingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteBucketPolicy$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBucketPolicy$40(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteBucketPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteBucketLifecycleConfiguration$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBucketLifecycleConfiguration$36(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteBucketLifecycleConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteBucket$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBucket$32(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteBucketResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAccessPointPolicyForObjectLambda$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAccessPointPolicyForObjectLambda$28(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAccessPointPolicyForObjectLambdaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAccessPointPolicy$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAccessPointPolicy$25(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAccessPointPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAccessPointForObjectLambda$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAccessPointForObjectLambda$21(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAccessPointForObjectLambdaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAccessPoint$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAccessPoint$18(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAccessPointResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createMultiRegionAccessPoint$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMultiRegionAccessPoint$14(List metricPublishers, MetricCollector apiCallMetricCollector, CreateMultiRegionAccessPointResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createJob$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createJob$11(List metricPublishers, MetricCollector apiCallMetricCollector, CreateJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createBucket$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBucket$8(List metricPublishers, MetricCollector apiCallMetricCollector, CreateBucketResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createAccessPointForObjectLambda$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAccessPointForObjectLambda$5(List metricPublishers, MetricCollector apiCallMetricCollector, CreateAccessPointForObjectLambdaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createAccessPoint$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAccessPoint$2(List metricPublishers, MetricCollector apiCallMetricCollector, CreateAccessPointResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

