/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.internal;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.s3control.S3ControlConfiguration;
import software.amazon.awssdk.utils.StringUtils;

@SdkInternalApi
public final class HandlerUtils {
    public static final String X_AMZ_ACCOUNT_ID = "x-amz-account-id";
    public static final String ENDPOINT_PREFIX = "s3-control";
    public static final String S3_OUTPOSTS = "s3-outposts";

    private HandlerUtils() {
    }

    public static boolean isDualstackEnabled(S3ControlConfiguration configuration) {
        return configuration != null && configuration.dualstackEnabled();
    }

    public static boolean isFipsEnabledInClientConfig(S3ControlConfiguration configuration) {
        return configuration != null && configuration.fipsModeEnabled();
    }

    public static boolean isUseArnRegionEnabledInClientConfig(S3ControlConfiguration configuration) {
        return configuration != null && configuration.useArnRegionEnabled();
    }

    public static boolean isFipsRegion(String clientRegion, String arnRegion, S3ControlConfiguration serviceConfig, boolean useArnRegion) {
        if (useArnRegion) {
            return HandlerUtils.isFipsRegion(arnRegion);
        }
        return HandlerUtils.isFipsRegion(clientRegion);
    }

    public static boolean isFipsRegion(String regionName) {
        if (StringUtils.isEmpty((CharSequence)regionName)) {
            return false;
        }
        return regionName.startsWith("fips-") || regionName.endsWith("-fips");
    }
}

