/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.ObjectLambdaContentTransformation;
import software.amazon.awssdk.services.s3control.model.ObjectLambdaTransformationConfigurationAction;
import software.amazon.awssdk.services.s3control.model.ObjectLambdaTransformationConfigurationActionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ObjectLambdaTransformationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ObjectLambdaTransformationConfiguration> {
    private static final SdkField<List<String>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(ObjectLambdaTransformationConfiguration.getter(ObjectLambdaTransformationConfiguration::actionsAsStrings)).setter(ObjectLambdaTransformationConfiguration.setter(Builder::actionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").unmarshallLocationName("Actions").build(), ListTrait.builder().memberLocationName("Action").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").unmarshallLocationName("Action").build()}).build()).build()}).build();
    private static final SdkField<ObjectLambdaContentTransformation> CONTENT_TRANSFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContentTransformation").getter(ObjectLambdaTransformationConfiguration.getter(ObjectLambdaTransformationConfiguration::contentTransformation)).setter(ObjectLambdaTransformationConfiguration.setter(Builder::contentTransformation)).constructor(ObjectLambdaContentTransformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentTransformation").unmarshallLocationName("ContentTransformation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_FIELD, CONTENT_TRANSFORMATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> actions;
    private final ObjectLambdaContentTransformation contentTransformation;

    private ObjectLambdaTransformationConfiguration(BuilderImpl builder) {
        this.actions = builder.actions;
        this.contentTransformation = builder.contentTransformation;
    }

    public final List<ObjectLambdaTransformationConfigurationAction> actions() {
        return ObjectLambdaTransformationConfigurationActionsListCopier.copyStringToEnum(this.actions);
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<String> actionsAsStrings() {
        return this.actions;
    }

    public final ObjectLambdaContentTransformation contentTransformation() {
        return this.contentTransformation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.contentTransformation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectLambdaTransformationConfiguration)) {
            return false;
        }
        ObjectLambdaTransformationConfiguration other = (ObjectLambdaTransformationConfiguration)obj;
        return this.hasActions() == other.hasActions() && Objects.equals(this.actionsAsStrings(), other.actionsAsStrings()) && Objects.equals(this.contentTransformation(), other.contentTransformation());
    }

    public final String toString() {
        return ToString.builder((String)"ObjectLambdaTransformationConfiguration").add("Actions", this.hasActions() ? this.actionsAsStrings() : null).add("ContentTransformation", (Object)this.contentTransformation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actionsAsStrings()));
            }
            case "ContentTransformation": {
                return Optional.ofNullable(clazz.cast(this.contentTransformation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ObjectLambdaTransformationConfiguration, T> g) {
        return obj -> g.apply((ObjectLambdaTransformationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> actions = DefaultSdkAutoConstructList.getInstance();
        private ObjectLambdaContentTransformation contentTransformation;

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectLambdaTransformationConfiguration model) {
            this.actionsWithStrings(model.actions);
            this.contentTransformation(model.contentTransformation);
        }

        public final Collection<String> getActions() {
            if (this.actions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.actions;
        }

        public final void setActions(Collection<String> actions) {
            this.actions = ObjectLambdaTransformationConfigurationActionsListCopier.copy(actions);
        }

        @Override
        @Transient
        public final Builder actionsWithStrings(Collection<String> actions) {
            this.actions = ObjectLambdaTransformationConfigurationActionsListCopier.copy(actions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder actionsWithStrings(String ... actions) {
            this.actionsWithStrings(Arrays.asList(actions));
            return this;
        }

        @Override
        @Transient
        public final Builder actions(Collection<ObjectLambdaTransformationConfigurationAction> actions) {
            this.actions = ObjectLambdaTransformationConfigurationActionsListCopier.copyEnumToString(actions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder actions(ObjectLambdaTransformationConfigurationAction ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        public final ObjectLambdaContentTransformation.Builder getContentTransformation() {
            return this.contentTransformation != null ? this.contentTransformation.toBuilder() : null;
        }

        public final void setContentTransformation(ObjectLambdaContentTransformation.BuilderImpl contentTransformation) {
            this.contentTransformation = contentTransformation != null ? contentTransformation.build() : null;
        }

        @Override
        @Transient
        public final Builder contentTransformation(ObjectLambdaContentTransformation contentTransformation) {
            this.contentTransformation = contentTransformation;
            return this;
        }

        public ObjectLambdaTransformationConfiguration build() {
            return new ObjectLambdaTransformationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ObjectLambdaTransformationConfiguration> {
        public Builder actionsWithStrings(Collection<String> var1);

        public Builder actionsWithStrings(String ... var1);

        public Builder actions(Collection<ObjectLambdaTransformationConfigurationAction> var1);

        public Builder actions(ObjectLambdaTransformationConfigurationAction ... var1);

        public Builder contentTransformation(ObjectLambdaContentTransformation var1);

        default public Builder contentTransformation(Consumer<ObjectLambdaContentTransformation.Builder> contentTransformation) {
            return this.contentTransformation((ObjectLambdaContentTransformation)((ObjectLambdaContentTransformation.Builder)ObjectLambdaContentTransformation.builder().applyMutation(contentTransformation)).build());
        }
    }
}

