/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.LifecycleRuleAndOperator;
import software.amazon.awssdk.services.s3control.model.S3Tag;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LifecycleRuleFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LifecycleRuleFilter> {
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Prefix").getter(LifecycleRuleFilter.getter(LifecycleRuleFilter::prefix)).setter(LifecycleRuleFilter.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").unmarshallLocationName("Prefix").build()}).build();
    private static final SdkField<S3Tag> TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Tag").getter(LifecycleRuleFilter.getter(LifecycleRuleFilter::tag)).setter(LifecycleRuleFilter.setter(Builder::tag)).constructor(S3Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").unmarshallLocationName("Tag").build()}).build();
    private static final SdkField<LifecycleRuleAndOperator> AND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("And").getter(LifecycleRuleFilter.getter(LifecycleRuleFilter::and)).setter(LifecycleRuleFilter.setter(Builder::and)).constructor(LifecycleRuleAndOperator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("And").unmarshallLocationName("And").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIX_FIELD, TAG_FIELD, AND_FIELD));
    private static final long serialVersionUID = 1L;
    private final String prefix;
    private final S3Tag tag;
    private final LifecycleRuleAndOperator and;

    private LifecycleRuleFilter(BuilderImpl builder) {
        this.prefix = builder.prefix;
        this.tag = builder.tag;
        this.and = builder.and;
    }

    public final String prefix() {
        return this.prefix;
    }

    public final S3Tag tag() {
        return this.tag;
    }

    public final LifecycleRuleAndOperator and() {
        return this.and;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.tag());
        hashCode = 31 * hashCode + Objects.hashCode(this.and());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleRuleFilter)) {
            return false;
        }
        LifecycleRuleFilter other = (LifecycleRuleFilter)obj;
        return Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.tag(), other.tag()) && Objects.equals(this.and(), other.and());
    }

    public final String toString() {
        return ToString.builder((String)"LifecycleRuleFilter").add("Prefix", (Object)this.prefix()).add("Tag", (Object)this.tag()).add("And", (Object)this.and()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "Tag": {
                return Optional.ofNullable(clazz.cast(this.tag()));
            }
            case "And": {
                return Optional.ofNullable(clazz.cast(this.and()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifecycleRuleFilter, T> g) {
        return obj -> g.apply((LifecycleRuleFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String prefix;
        private S3Tag tag;
        private LifecycleRuleAndOperator and;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecycleRuleFilter model) {
            this.prefix(model.prefix);
            this.tag(model.tag);
            this.and(model.and);
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final S3Tag.Builder getTag() {
            return this.tag != null ? this.tag.toBuilder() : null;
        }

        @Override
        public final Builder tag(S3Tag tag) {
            this.tag = tag;
            return this;
        }

        public final void setTag(S3Tag.BuilderImpl tag) {
            this.tag = tag != null ? tag.build() : null;
        }

        public final LifecycleRuleAndOperator.Builder getAnd() {
            return this.and != null ? this.and.toBuilder() : null;
        }

        @Override
        public final Builder and(LifecycleRuleAndOperator and) {
            this.and = and;
            return this;
        }

        public final void setAnd(LifecycleRuleAndOperator.BuilderImpl and) {
            this.and = and != null ? and.build() : null;
        }

        public LifecycleRuleFilter build() {
            return new LifecycleRuleFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LifecycleRuleFilter> {
        public Builder prefix(String var1);

        public Builder tag(S3Tag var1);

        default public Builder tag(Consumer<S3Tag.Builder> tag) {
            return this.tag((S3Tag)((S3Tag.Builder)S3Tag.builder().applyMutation(tag)).build());
        }

        public Builder and(LifecycleRuleAndOperator var1);

        default public Builder and(Consumer<LifecycleRuleAndOperator.Builder> and) {
            return this.and((LifecycleRuleAndOperator)((LifecycleRuleAndOperator.Builder)LifecycleRuleAndOperator.builder().applyMutation(and)).build());
        }
    }
}

