/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.s3control.model.JobListDescriptor;
import software.amazon.awssdk.services.s3control.model.JobListDescriptorListCopier;
import software.amazon.awssdk.services.s3control.model.S3ControlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListJobsResponse
extends S3ControlResponse
implements ToCopyableBuilder<Builder, ListJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListJobsResponse.getter(ListJobsResponse::nextToken)).setter(ListJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final SdkField<List<JobListDescriptor>> JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Jobs").getter(ListJobsResponse.getter(ListJobsResponse::jobs)).setter(ListJobsResponse.setter(Builder::jobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Jobs").unmarshallLocationName("Jobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobListDescriptor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, JOBS_FIELD));
    private final String nextToken;
    private final List<JobListDescriptor> jobs;

    private ListJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.jobs = builder.jobs;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasJobs() {
        return this.jobs != null && !(this.jobs instanceof SdkAutoConstructList);
    }

    public List<JobListDescriptor> jobs() {
        return this.jobs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobs() ? this.jobs() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsResponse)) {
            return false;
        }
        ListJobsResponse other = (ListJobsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasJobs() == other.hasJobs() && Objects.equals(this.jobs(), other.jobs());
    }

    public String toString() {
        return ToString.builder((String)"ListJobsResponse").add("NextToken", (Object)this.nextToken()).add("Jobs", this.hasJobs() ? this.jobs() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Jobs": {
                return Optional.ofNullable(clazz.cast(this.jobs()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJobsResponse, T> g) {
        return obj -> g.apply((ListJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<JobListDescriptor> jobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.jobs(model.jobs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<JobListDescriptor.Builder> getJobs() {
            if (this.jobs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.jobs != null ? (Collection)this.jobs.stream().map(JobListDescriptor::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobs(Collection<JobListDescriptor> jobs) {
            this.jobs = JobListDescriptorListCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(JobListDescriptor ... jobs) {
            this.jobs(Arrays.asList(jobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Consumer<JobListDescriptor.Builder> ... jobs) {
            this.jobs(Stream.of(jobs).map(c -> (JobListDescriptor)((JobListDescriptor.Builder)JobListDescriptor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobs(Collection<JobListDescriptor.BuilderImpl> jobs) {
            this.jobs = JobListDescriptorListCopier.copyFromBuilder(jobs);
        }

        @Override
        public ListJobsResponse build() {
            return new ListJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends S3ControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListJobsResponse> {
        public Builder nextToken(String var1);

        public Builder jobs(Collection<JobListDescriptor> var1);

        public Builder jobs(JobListDescriptor ... var1);

        public Builder jobs(Consumer<JobListDescriptor.Builder> ... var1);
    }
}

