/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.S3GranteeTypeIdentifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Grantee
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3Grantee> {
    private static final SdkField<String> TYPE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Grantee.getter(S3Grantee::typeIdentifierAsString)).setter(S3Grantee.setter(Builder::typeIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeIdentifier").unmarshallLocationName("TypeIdentifier").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Grantee.getter(S3Grantee::identifier)).setter(S3Grantee.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").unmarshallLocationName("Identifier").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Grantee.getter(S3Grantee::displayName)).setter(S3Grantee.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").unmarshallLocationName("DisplayName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_IDENTIFIER_FIELD, IDENTIFIER_FIELD, DISPLAY_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String typeIdentifier;
    private final String identifier;
    private final String displayName;

    private S3Grantee(BuilderImpl builder) {
        this.typeIdentifier = builder.typeIdentifier;
        this.identifier = builder.identifier;
        this.displayName = builder.displayName;
    }

    public S3GranteeTypeIdentifier typeIdentifier() {
        return S3GranteeTypeIdentifier.fromValue(this.typeIdentifier);
    }

    public String typeIdentifierAsString() {
        return this.typeIdentifier;
    }

    public String identifier() {
        return this.identifier;
    }

    public String displayName() {
        return this.displayName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeIdentifierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Grantee)) {
            return false;
        }
        S3Grantee other = (S3Grantee)obj;
        return Objects.equals(this.typeIdentifierAsString(), other.typeIdentifierAsString()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.displayName(), other.displayName());
    }

    public String toString() {
        return ToString.builder((String)"S3Grantee").add("TypeIdentifier", (Object)this.typeIdentifierAsString()).add("Identifier", (Object)this.identifier()).add("DisplayName", (Object)this.displayName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypeIdentifier": {
                return Optional.ofNullable(clazz.cast(this.typeIdentifierAsString()));
            }
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Grantee, T> g) {
        return obj -> g.apply((S3Grantee)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String typeIdentifier;
        private String identifier;
        private String displayName;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Grantee model) {
            this.typeIdentifier(model.typeIdentifier);
            this.identifier(model.identifier);
            this.displayName(model.displayName);
        }

        public final String getTypeIdentifier() {
            return this.typeIdentifier;
        }

        @Override
        public final Builder typeIdentifier(String typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
            return this;
        }

        @Override
        public final Builder typeIdentifier(S3GranteeTypeIdentifier typeIdentifier) {
            this.typeIdentifier(typeIdentifier == null ? null : typeIdentifier.toString());
            return this;
        }

        public final void setTypeIdentifier(String typeIdentifier) {
            this.typeIdentifier = typeIdentifier;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public S3Grantee build() {
            return new S3Grantee(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3Grantee> {
        public Builder typeIdentifier(String var1);

        public Builder typeIdentifier(S3GranteeTypeIdentifier var1);

        public Builder identifier(String var1);

        public Builder displayName(String var1);
    }
}

