/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.internal.interceptors;

import java.net.URI;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.services.s3control.S3ControlConfiguration;

@SdkInternalApi
public class EndpointAddressInterceptor
implements ExecutionInterceptor {
    private static final String ENDPOINT_PREFIX = "s3-control";
    private static final String X_AMZ_ACCOUNT_ID = "x-amz-account-id";

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        SdkHttpRequest request = context.httpRequest();
        if (!request.headers().containsKey(X_AMZ_ACCOUNT_ID)) {
            throw SdkClientException.create((String)"Account ID must be specified for all requests");
        }
        String accountId = (String)((List)request.headers().get(X_AMZ_ACCOUNT_ID)).get(0);
        URI endpoint = request.getUri();
        S3ControlConfiguration config = (S3ControlConfiguration)executionAttributes.getAttribute(AwsSignerExecutionAttribute.SERVICE_CONFIG);
        String host = this.resolveHost(request, accountId, config);
        return (SdkHttpRequest)((SdkHttpRequest.Builder)request.toBuilder()).host(host).build();
    }

    private String resolveHost(SdkHttpRequest request, String accountId, S3ControlConfiguration configuration) {
        if (this.isDualstackEnabled(configuration) && this.isFipsEnabled(configuration)) {
            throw SdkClientException.create((String)"Cannot use both Dual-Stack endpoints and FIPS endpoints");
        }
        String host = request.getUri().getHost();
        if (this.isDualstackEnabled(configuration)) {
            if (!host.contains(ENDPOINT_PREFIX)) {
                throw SdkClientException.create((String)String.format("The Dual-Stack option cannot be used with custom endpoints (%s)", request.getUri()));
            }
            host = host.replace(ENDPOINT_PREFIX, String.format("%s.%s", ENDPOINT_PREFIX, "dualstack"));
        } else if (this.isFipsEnabled(configuration)) {
            if (!host.contains(ENDPOINT_PREFIX)) {
                throw SdkClientException.create((String)String.format("The FIPS option cannot be used with custom endpoints (%s)", request.getUri()));
            }
            host = host.replace(ENDPOINT_PREFIX, String.format("%s-%s", ENDPOINT_PREFIX, "fips"));
        }
        return String.format("%s.%s", accountId, host);
    }

    private boolean isDualstackEnabled(S3ControlConfiguration configuration) {
        return configuration != null && configuration.dualstackEnabled();
    }

    private boolean isFipsEnabled(S3ControlConfiguration configuration) {
        return configuration != null && configuration.fipsModeEnabled();
    }
}

