/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.AsyncStreamingRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.xml.AwsS3ProtocolFactory;
import software.amazon.awssdk.protocols.xml.AwsXmlProtocolFactory;
import software.amazon.awssdk.protocols.xml.XmlOperationMetadata;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3Utilities;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.BucketAlreadyExistsException;
import software.amazon.awssdk.services.s3.model.BucketAlreadyOwnedByYouException;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.CopyObjectResponse;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.CreateBucketResponse;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketAnalyticsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketAnalyticsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketCorsRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketCorsResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketEncryptionRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketEncryptionResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketInventoryConfigurationRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketInventoryConfigurationResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketLifecycleRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketLifecycleResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketMetricsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketMetricsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketPolicyRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketPolicyResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketReplicationRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketReplicationResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketTaggingRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketTaggingResponse;
import software.amazon.awssdk.services.s3.model.DeleteBucketWebsiteRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketWebsiteResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectTaggingResponse;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.DeletePublicAccessBlockRequest;
import software.amazon.awssdk.services.s3.model.DeletePublicAccessBlockResponse;
import software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketAccelerateConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketAclRequest;
import software.amazon.awssdk.services.s3.model.GetBucketAclResponse;
import software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketAnalyticsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketCorsRequest;
import software.amazon.awssdk.services.s3.model.GetBucketCorsResponse;
import software.amazon.awssdk.services.s3.model.GetBucketEncryptionRequest;
import software.amazon.awssdk.services.s3.model.GetBucketEncryptionResponse;
import software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketLifecycleConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketLocationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketLocationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketLoggingRequest;
import software.amazon.awssdk.services.s3.model.GetBucketLoggingResponse;
import software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketMetricsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketNotificationConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketNotificationConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketPolicyRequest;
import software.amazon.awssdk.services.s3.model.GetBucketPolicyResponse;
import software.amazon.awssdk.services.s3.model.GetBucketPolicyStatusRequest;
import software.amazon.awssdk.services.s3.model.GetBucketPolicyStatusResponse;
import software.amazon.awssdk.services.s3.model.GetBucketReplicationRequest;
import software.amazon.awssdk.services.s3.model.GetBucketReplicationResponse;
import software.amazon.awssdk.services.s3.model.GetBucketRequestPaymentRequest;
import software.amazon.awssdk.services.s3.model.GetBucketRequestPaymentResponse;
import software.amazon.awssdk.services.s3.model.GetBucketTaggingRequest;
import software.amazon.awssdk.services.s3.model.GetBucketTaggingResponse;
import software.amazon.awssdk.services.s3.model.GetBucketVersioningRequest;
import software.amazon.awssdk.services.s3.model.GetBucketVersioningResponse;
import software.amazon.awssdk.services.s3.model.GetBucketWebsiteRequest;
import software.amazon.awssdk.services.s3.model.GetBucketWebsiteResponse;
import software.amazon.awssdk.services.s3.model.GetObjectAclRequest;
import software.amazon.awssdk.services.s3.model.GetObjectAclResponse;
import software.amazon.awssdk.services.s3.model.GetObjectLegalHoldRequest;
import software.amazon.awssdk.services.s3.model.GetObjectLegalHoldResponse;
import software.amazon.awssdk.services.s3.model.GetObjectLockConfigurationRequest;
import software.amazon.awssdk.services.s3.model.GetObjectLockConfigurationResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRetentionRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRetentionResponse;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.GetObjectTaggingResponse;
import software.amazon.awssdk.services.s3.model.GetObjectTorrentRequest;
import software.amazon.awssdk.services.s3.model.GetObjectTorrentResponse;
import software.amazon.awssdk.services.s3.model.GetPublicAccessBlockRequest;
import software.amazon.awssdk.services.s3.model.GetPublicAccessBlockResponse;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketAnalyticsConfigurationsResponse;
import software.amazon.awssdk.services.s3.model.ListBucketInventoryConfigurationsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketInventoryConfigurationsResponse;
import software.amazon.awssdk.services.s3.model.ListBucketMetricsConfigurationsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketMetricsConfigurationsResponse;
import software.amazon.awssdk.services.s3.model.ListBucketsRequest;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;
import software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest;
import software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.ListPartsRequest;
import software.amazon.awssdk.services.s3.model.ListPartsResponse;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.NoSuchUploadException;
import software.amazon.awssdk.services.s3.model.ObjectAlreadyInActiveTierErrorException;
import software.amazon.awssdk.services.s3.model.ObjectNotInActiveTierErrorException;
import software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketAclRequest;
import software.amazon.awssdk.services.s3.model.PutBucketAclResponse;
import software.amazon.awssdk.services.s3.model.PutBucketAnalyticsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketAnalyticsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketCorsRequest;
import software.amazon.awssdk.services.s3.model.PutBucketCorsResponse;
import software.amazon.awssdk.services.s3.model.PutBucketEncryptionRequest;
import software.amazon.awssdk.services.s3.model.PutBucketEncryptionResponse;
import software.amazon.awssdk.services.s3.model.PutBucketInventoryConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketInventoryConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketLifecycleConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketLoggingRequest;
import software.amazon.awssdk.services.s3.model.PutBucketLoggingResponse;
import software.amazon.awssdk.services.s3.model.PutBucketMetricsConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketMetricsConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketNotificationConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketNotificationConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest;
import software.amazon.awssdk.services.s3.model.PutBucketPolicyResponse;
import software.amazon.awssdk.services.s3.model.PutBucketReplicationRequest;
import software.amazon.awssdk.services.s3.model.PutBucketReplicationResponse;
import software.amazon.awssdk.services.s3.model.PutBucketRequestPaymentRequest;
import software.amazon.awssdk.services.s3.model.PutBucketRequestPaymentResponse;
import software.amazon.awssdk.services.s3.model.PutBucketTaggingRequest;
import software.amazon.awssdk.services.s3.model.PutBucketTaggingResponse;
import software.amazon.awssdk.services.s3.model.PutBucketVersioningRequest;
import software.amazon.awssdk.services.s3.model.PutBucketVersioningResponse;
import software.amazon.awssdk.services.s3.model.PutBucketWebsiteRequest;
import software.amazon.awssdk.services.s3.model.PutBucketWebsiteResponse;
import software.amazon.awssdk.services.s3.model.PutObjectAclRequest;
import software.amazon.awssdk.services.s3.model.PutObjectAclResponse;
import software.amazon.awssdk.services.s3.model.PutObjectLegalHoldRequest;
import software.amazon.awssdk.services.s3.model.PutObjectLegalHoldResponse;
import software.amazon.awssdk.services.s3.model.PutObjectLockConfigurationRequest;
import software.amazon.awssdk.services.s3.model.PutObjectLockConfigurationResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRetentionRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRetentionResponse;
import software.amazon.awssdk.services.s3.model.PutObjectTaggingRequest;
import software.amazon.awssdk.services.s3.model.PutObjectTaggingResponse;
import software.amazon.awssdk.services.s3.model.PutPublicAccessBlockRequest;
import software.amazon.awssdk.services.s3.model.PutPublicAccessBlockResponse;
import software.amazon.awssdk.services.s3.model.RestoreObjectRequest;
import software.amazon.awssdk.services.s3.model.RestoreObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.awssdk.services.s3.model.UploadPartCopyRequest;
import software.amazon.awssdk.services.s3.model.UploadPartCopyResponse;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;
import software.amazon.awssdk.services.s3.paginators.ListMultipartUploadsPublisher;
import software.amazon.awssdk.services.s3.paginators.ListObjectVersionsPublisher;
import software.amazon.awssdk.services.s3.paginators.ListObjectsV2Publisher;
import software.amazon.awssdk.services.s3.paginators.ListPartsPublisher;
import software.amazon.awssdk.services.s3.transform.AbortMultipartUploadRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.CompleteMultipartUploadRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.CopyObjectRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.CreateBucketRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.CreateMultipartUploadRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketAnalyticsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketCorsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketEncryptionRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketInventoryConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketLifecycleRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketMetricsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketReplicationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteBucketWebsiteRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteObjectRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteObjectTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeleteObjectsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.DeletePublicAccessBlockRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketAccelerateConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketAclRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketAnalyticsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketCorsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketEncryptionRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketInventoryConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketLifecycleConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketLocationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketLoggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketMetricsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketNotificationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketPolicyStatusRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketReplicationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketRequestPaymentRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketVersioningRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetBucketWebsiteRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectAclRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectLegalHoldRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectLockConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectRetentionRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetObjectTorrentRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.GetPublicAccessBlockRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.HeadBucketRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.HeadObjectRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListBucketAnalyticsConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListBucketInventoryConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListBucketMetricsConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListBucketsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListMultipartUploadsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListObjectVersionsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListObjectsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListObjectsV2RequestMarshaller;
import software.amazon.awssdk.services.s3.transform.ListPartsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketAccelerateConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketAclRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketAnalyticsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketCorsRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketEncryptionRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketInventoryConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketLifecycleConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketLoggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketMetricsConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketNotificationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketPolicyRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketReplicationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketRequestPaymentRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketVersioningRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutBucketWebsiteRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutObjectAclRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutObjectLegalHoldRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutObjectLockConfigurationRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutObjectRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutObjectRetentionRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutObjectTaggingRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.PutPublicAccessBlockRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.RestoreObjectRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.UploadPartCopyRequestMarshaller;
import software.amazon.awssdk.services.s3.transform.UploadPartRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.FunctionalUtils;

@SdkInternalApi
final class DefaultS3AsyncClient
implements S3AsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultS3AsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsS3ProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultS3AsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "s3";
    }

    @Override
    public CompletableFuture<AbortMultipartUploadResponse> abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(AbortMultipartUploadResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AbortMultipartUpload").withMarshaller((Marshaller)new AbortMultipartUploadRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)abortMultipartUploadRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CompleteMultipartUploadResponse> completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CompleteMultipartUploadResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CompleteMultipartUpload").withMarshaller((Marshaller)new CompleteMultipartUploadRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)completeMultipartUploadRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CopyObjectResponse> copyObject(CopyObjectRequest copyObjectRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CopyObjectResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyObject").withMarshaller((Marshaller)new CopyObjectRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)copyObjectRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateBucketResponse> createBucket(CreateBucketRequest createBucketRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateBucketResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBucket").withMarshaller((Marshaller)new CreateBucketRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)createBucketRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateMultipartUploadResponse> createMultipartUpload(CreateMultipartUploadRequest createMultipartUploadRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateMultipartUploadResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMultipartUpload").withMarshaller((Marshaller)new CreateMultipartUploadRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)createMultipartUploadRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBucketResponse> deleteBucket(DeleteBucketRequest deleteBucketRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucket").withMarshaller((Marshaller)new DeleteBucketRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteBucketRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBucketAnalyticsConfigurationResponse> deleteBucketAnalyticsConfiguration(DeleteBucketAnalyticsConfigurationRequest deleteBucketAnalyticsConfigurationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketAnalyticsConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketAnalyticsConfiguration").withMarshaller((Marshaller)new DeleteBucketAnalyticsConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteBucketAnalyticsConfigurationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBucketCorsResponse> deleteBucketCors(DeleteBucketCorsRequest deleteBucketCorsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketCorsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketCors").withMarshaller((Marshaller)new DeleteBucketCorsRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteBucketCorsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBucketEncryptionResponse> deleteBucketEncryption(DeleteBucketEncryptionRequest deleteBucketEncryptionRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketEncryptionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketEncryption").withMarshaller((Marshaller)new DeleteBucketEncryptionRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteBucketEncryptionRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBucketInventoryConfigurationResponse> deleteBucketInventoryConfiguration(DeleteBucketInventoryConfigurationRequest deleteBucketInventoryConfigurationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketInventoryConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketInventoryConfiguration").withMarshaller((Marshaller)new DeleteBucketInventoryConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteBucketInventoryConfigurationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBucketLifecycleResponse> deleteBucketLifecycle(DeleteBucketLifecycleRequest deleteBucketLifecycleRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketLifecycleResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketLifecycle").withMarshaller((Marshaller)new DeleteBucketLifecycleRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteBucketLifecycleRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBucketMetricsConfigurationResponse> deleteBucketMetricsConfiguration(DeleteBucketMetricsConfigurationRequest deleteBucketMetricsConfigurationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketMetricsConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketMetricsConfiguration").withMarshaller((Marshaller)new DeleteBucketMetricsConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteBucketMetricsConfigurationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBucketPolicyResponse> deleteBucketPolicy(DeleteBucketPolicyRequest deleteBucketPolicyRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketPolicy").withMarshaller((Marshaller)new DeleteBucketPolicyRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteBucketPolicyRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBucketReplicationResponse> deleteBucketReplication(DeleteBucketReplicationRequest deleteBucketReplicationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketReplicationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketReplication").withMarshaller((Marshaller)new DeleteBucketReplicationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteBucketReplicationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBucketTaggingResponse> deleteBucketTagging(DeleteBucketTaggingRequest deleteBucketTaggingRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketTagging").withMarshaller((Marshaller)new DeleteBucketTaggingRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteBucketTaggingRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBucketWebsiteResponse> deleteBucketWebsite(DeleteBucketWebsiteRequest deleteBucketWebsiteRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteBucketWebsiteResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBucketWebsite").withMarshaller((Marshaller)new DeleteBucketWebsiteRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteBucketWebsiteRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteObjectResponse> deleteObject(DeleteObjectRequest deleteObjectRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteObjectResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteObject").withMarshaller((Marshaller)new DeleteObjectRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteObjectRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteObjectTaggingResponse> deleteObjectTagging(DeleteObjectTaggingRequest deleteObjectTaggingRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteObjectTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteObjectTagging").withMarshaller((Marshaller)new DeleteObjectTaggingRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteObjectTaggingRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteObjectsResponse> deleteObjects(DeleteObjectsRequest deleteObjectsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteObjectsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteObjects").withMarshaller((Marshaller)new DeleteObjectsRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deleteObjectsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeletePublicAccessBlockResponse> deletePublicAccessBlock(DeletePublicAccessBlockRequest deletePublicAccessBlockRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeletePublicAccessBlockResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePublicAccessBlock").withMarshaller((Marshaller)new DeletePublicAccessBlockRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)deletePublicAccessBlockRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketAccelerateConfigurationResponse> getBucketAccelerateConfiguration(GetBucketAccelerateConfigurationRequest getBucketAccelerateConfigurationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketAccelerateConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketAccelerateConfiguration").withMarshaller((Marshaller)new GetBucketAccelerateConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketAccelerateConfigurationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketAclResponse> getBucketAcl(GetBucketAclRequest getBucketAclRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketAclResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketAcl").withMarshaller((Marshaller)new GetBucketAclRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketAclRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketAnalyticsConfigurationResponse> getBucketAnalyticsConfiguration(GetBucketAnalyticsConfigurationRequest getBucketAnalyticsConfigurationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketAnalyticsConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketAnalyticsConfiguration").withMarshaller((Marshaller)new GetBucketAnalyticsConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketAnalyticsConfigurationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketCorsResponse> getBucketCors(GetBucketCorsRequest getBucketCorsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketCorsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketCors").withMarshaller((Marshaller)new GetBucketCorsRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketCorsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketEncryptionResponse> getBucketEncryption(GetBucketEncryptionRequest getBucketEncryptionRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketEncryptionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketEncryption").withMarshaller((Marshaller)new GetBucketEncryptionRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketEncryptionRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketInventoryConfigurationResponse> getBucketInventoryConfiguration(GetBucketInventoryConfigurationRequest getBucketInventoryConfigurationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketInventoryConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketInventoryConfiguration").withMarshaller((Marshaller)new GetBucketInventoryConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketInventoryConfigurationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketLifecycleConfigurationResponse> getBucketLifecycleConfiguration(GetBucketLifecycleConfigurationRequest getBucketLifecycleConfigurationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketLifecycleConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketLifecycleConfiguration").withMarshaller((Marshaller)new GetBucketLifecycleConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketLifecycleConfigurationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketLocationResponse> getBucketLocation(GetBucketLocationRequest getBucketLocationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketLocationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketLocation").withMarshaller((Marshaller)new GetBucketLocationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketLocationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketLoggingResponse> getBucketLogging(GetBucketLoggingRequest getBucketLoggingRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketLoggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketLogging").withMarshaller((Marshaller)new GetBucketLoggingRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketLoggingRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketMetricsConfigurationResponse> getBucketMetricsConfiguration(GetBucketMetricsConfigurationRequest getBucketMetricsConfigurationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketMetricsConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketMetricsConfiguration").withMarshaller((Marshaller)new GetBucketMetricsConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketMetricsConfigurationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketNotificationConfigurationResponse> getBucketNotificationConfiguration(GetBucketNotificationConfigurationRequest getBucketNotificationConfigurationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketNotificationConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketNotificationConfiguration").withMarshaller((Marshaller)new GetBucketNotificationConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketNotificationConfigurationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketPolicyResponse> getBucketPolicy(GetBucketPolicyRequest getBucketPolicyRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketPolicy").withMarshaller((Marshaller)new GetBucketPolicyRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketPolicyRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketPolicyStatusResponse> getBucketPolicyStatus(GetBucketPolicyStatusRequest getBucketPolicyStatusRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketPolicyStatusResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketPolicyStatus").withMarshaller((Marshaller)new GetBucketPolicyStatusRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketPolicyStatusRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketReplicationResponse> getBucketReplication(GetBucketReplicationRequest getBucketReplicationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketReplicationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketReplication").withMarshaller((Marshaller)new GetBucketReplicationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketReplicationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketRequestPaymentResponse> getBucketRequestPayment(GetBucketRequestPaymentRequest getBucketRequestPaymentRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketRequestPaymentResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketRequestPayment").withMarshaller((Marshaller)new GetBucketRequestPaymentRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketRequestPaymentRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketTaggingResponse> getBucketTagging(GetBucketTaggingRequest getBucketTaggingRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketTagging").withMarshaller((Marshaller)new GetBucketTaggingRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketTaggingRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketVersioningResponse> getBucketVersioning(GetBucketVersioningRequest getBucketVersioningRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketVersioningResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketVersioning").withMarshaller((Marshaller)new GetBucketVersioningRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketVersioningRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetBucketWebsiteResponse> getBucketWebsite(GetBucketWebsiteRequest getBucketWebsiteRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetBucketWebsiteResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBucketWebsite").withMarshaller((Marshaller)new GetBucketWebsiteRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getBucketWebsiteRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public <ReturnT> CompletableFuture<ReturnT> getObject(GetObjectRequest getObjectRequest, AsyncResponseTransformer<GetObjectResponse, ReturnT> asyncResponseTransformer) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetObjectResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(true));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetObject").withMarshaller((Marshaller)new GetObjectRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getObjectRequest), asyncResponseTransformer);
            executeFuture.whenComplete((r, e) -> {
                if (e != null) {
                    FunctionalUtils.runAndLogError((Logger)log, (String)"Exception thrown in exceptionOccurred callback, ignoring", () -> asyncResponseTransformer.exceptionOccurred(e));
                }
            });
            return executeFuture;
        }
        catch (Throwable t) {
            FunctionalUtils.runAndLogError((Logger)log, (String)"Exception thrown in exceptionOccurred callback, ignoring", () -> asyncResponseTransformer.exceptionOccurred(t));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetObjectAclResponse> getObjectAcl(GetObjectAclRequest getObjectAclRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetObjectAclResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetObjectAcl").withMarshaller((Marshaller)new GetObjectAclRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getObjectAclRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetObjectLegalHoldResponse> getObjectLegalHold(GetObjectLegalHoldRequest getObjectLegalHoldRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetObjectLegalHoldResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetObjectLegalHold").withMarshaller((Marshaller)new GetObjectLegalHoldRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getObjectLegalHoldRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetObjectLockConfigurationResponse> getObjectLockConfiguration(GetObjectLockConfigurationRequest getObjectLockConfigurationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetObjectLockConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetObjectLockConfiguration").withMarshaller((Marshaller)new GetObjectLockConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getObjectLockConfigurationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetObjectRetentionResponse> getObjectRetention(GetObjectRetentionRequest getObjectRetentionRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetObjectRetentionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetObjectRetention").withMarshaller((Marshaller)new GetObjectRetentionRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getObjectRetentionRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetObjectTaggingResponse> getObjectTagging(GetObjectTaggingRequest getObjectTaggingRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetObjectTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetObjectTagging").withMarshaller((Marshaller)new GetObjectTaggingRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getObjectTaggingRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public <ReturnT> CompletableFuture<ReturnT> getObjectTorrent(GetObjectTorrentRequest getObjectTorrentRequest, AsyncResponseTransformer<GetObjectTorrentResponse, ReturnT> asyncResponseTransformer) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetObjectTorrentResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(true));
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetObjectTorrent").withMarshaller((Marshaller)new GetObjectTorrentRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getObjectTorrentRequest), asyncResponseTransformer);
            executeFuture.whenComplete((r, e) -> {
                if (e != null) {
                    FunctionalUtils.runAndLogError((Logger)log, (String)"Exception thrown in exceptionOccurred callback, ignoring", () -> asyncResponseTransformer.exceptionOccurred(e));
                }
            });
            return executeFuture;
        }
        catch (Throwable t) {
            FunctionalUtils.runAndLogError((Logger)log, (String)"Exception thrown in exceptionOccurred callback, ignoring", () -> asyncResponseTransformer.exceptionOccurred(t));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetPublicAccessBlockResponse> getPublicAccessBlock(GetPublicAccessBlockRequest getPublicAccessBlockRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetPublicAccessBlockResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPublicAccessBlock").withMarshaller((Marshaller)new GetPublicAccessBlockRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)getPublicAccessBlockRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<HeadBucketResponse> headBucket(HeadBucketRequest headBucketRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(HeadBucketResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("HeadBucket").withMarshaller((Marshaller)new HeadBucketRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)headBucketRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<HeadObjectResponse> headObject(HeadObjectRequest headObjectRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(HeadObjectResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("HeadObject").withMarshaller((Marshaller)new HeadObjectRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)headObjectRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListBucketAnalyticsConfigurationsResponse> listBucketAnalyticsConfigurations(ListBucketAnalyticsConfigurationsRequest listBucketAnalyticsConfigurationsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListBucketAnalyticsConfigurationsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBucketAnalyticsConfigurations").withMarshaller((Marshaller)new ListBucketAnalyticsConfigurationsRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listBucketAnalyticsConfigurationsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListBucketInventoryConfigurationsResponse> listBucketInventoryConfigurations(ListBucketInventoryConfigurationsRequest listBucketInventoryConfigurationsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListBucketInventoryConfigurationsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBucketInventoryConfigurations").withMarshaller((Marshaller)new ListBucketInventoryConfigurationsRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listBucketInventoryConfigurationsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListBucketMetricsConfigurationsResponse> listBucketMetricsConfigurations(ListBucketMetricsConfigurationsRequest listBucketMetricsConfigurationsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListBucketMetricsConfigurationsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBucketMetricsConfigurations").withMarshaller((Marshaller)new ListBucketMetricsConfigurationsRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listBucketMetricsConfigurationsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListBucketsResponse> listBuckets(ListBucketsRequest listBucketsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListBucketsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBuckets").withMarshaller((Marshaller)new ListBucketsRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listBucketsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListMultipartUploadsResponse> listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListMultipartUploadsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMultipartUploads").withMarshaller((Marshaller)new ListMultipartUploadsRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listMultipartUploadsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListMultipartUploadsPublisher listMultipartUploadsPaginator(ListMultipartUploadsRequest listMultipartUploadsRequest) {
        return new ListMultipartUploadsPublisher(this, this.applyPaginatorUserAgent(listMultipartUploadsRequest));
    }

    @Override
    public CompletableFuture<ListObjectVersionsResponse> listObjectVersions(ListObjectVersionsRequest listObjectVersionsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListObjectVersionsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListObjectVersions").withMarshaller((Marshaller)new ListObjectVersionsRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listObjectVersionsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListObjectVersionsPublisher listObjectVersionsPaginator(ListObjectVersionsRequest listObjectVersionsRequest) {
        return new ListObjectVersionsPublisher(this, this.applyPaginatorUserAgent(listObjectVersionsRequest));
    }

    @Override
    public CompletableFuture<ListObjectsResponse> listObjects(ListObjectsRequest listObjectsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListObjectsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListObjects").withMarshaller((Marshaller)new ListObjectsRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listObjectsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListObjectsV2Response> listObjectsV2(ListObjectsV2Request listObjectsV2Request) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListObjectsV2Response::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListObjectsV2").withMarshaller((Marshaller)new ListObjectsV2RequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listObjectsV2Request));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListObjectsV2Publisher listObjectsV2Paginator(ListObjectsV2Request listObjectsV2Request) {
        return new ListObjectsV2Publisher(this, this.applyPaginatorUserAgent(listObjectsV2Request));
    }

    @Override
    public CompletableFuture<ListPartsResponse> listParts(ListPartsRequest listPartsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListPartsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListParts").withMarshaller((Marshaller)new ListPartsRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)listPartsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListPartsPublisher listPartsPaginator(ListPartsRequest listPartsRequest) {
        return new ListPartsPublisher(this, this.applyPaginatorUserAgent(listPartsRequest));
    }

    @Override
    public CompletableFuture<PutBucketAccelerateConfigurationResponse> putBucketAccelerateConfiguration(PutBucketAccelerateConfigurationRequest putBucketAccelerateConfigurationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketAccelerateConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketAccelerateConfiguration").withMarshaller((Marshaller)new PutBucketAccelerateConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketAccelerateConfigurationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutBucketAclResponse> putBucketAcl(PutBucketAclRequest putBucketAclRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketAclResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketAcl").withMarshaller((Marshaller)new PutBucketAclRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketAclRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutBucketAnalyticsConfigurationResponse> putBucketAnalyticsConfiguration(PutBucketAnalyticsConfigurationRequest putBucketAnalyticsConfigurationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketAnalyticsConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketAnalyticsConfiguration").withMarshaller((Marshaller)new PutBucketAnalyticsConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketAnalyticsConfigurationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutBucketCorsResponse> putBucketCors(PutBucketCorsRequest putBucketCorsRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketCorsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketCors").withMarshaller((Marshaller)new PutBucketCorsRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketCorsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutBucketEncryptionResponse> putBucketEncryption(PutBucketEncryptionRequest putBucketEncryptionRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketEncryptionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketEncryption").withMarshaller((Marshaller)new PutBucketEncryptionRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketEncryptionRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutBucketInventoryConfigurationResponse> putBucketInventoryConfiguration(PutBucketInventoryConfigurationRequest putBucketInventoryConfigurationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketInventoryConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketInventoryConfiguration").withMarshaller((Marshaller)new PutBucketInventoryConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketInventoryConfigurationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutBucketLifecycleConfigurationResponse> putBucketLifecycleConfiguration(PutBucketLifecycleConfigurationRequest putBucketLifecycleConfigurationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketLifecycleConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketLifecycleConfiguration").withMarshaller((Marshaller)new PutBucketLifecycleConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketLifecycleConfigurationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutBucketLoggingResponse> putBucketLogging(PutBucketLoggingRequest putBucketLoggingRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketLoggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketLogging").withMarshaller((Marshaller)new PutBucketLoggingRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketLoggingRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutBucketMetricsConfigurationResponse> putBucketMetricsConfiguration(PutBucketMetricsConfigurationRequest putBucketMetricsConfigurationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketMetricsConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketMetricsConfiguration").withMarshaller((Marshaller)new PutBucketMetricsConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketMetricsConfigurationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutBucketNotificationConfigurationResponse> putBucketNotificationConfiguration(PutBucketNotificationConfigurationRequest putBucketNotificationConfigurationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketNotificationConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketNotificationConfiguration").withMarshaller((Marshaller)new PutBucketNotificationConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketNotificationConfigurationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutBucketPolicyResponse> putBucketPolicy(PutBucketPolicyRequest putBucketPolicyRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketPolicy").withMarshaller((Marshaller)new PutBucketPolicyRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketPolicyRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutBucketReplicationResponse> putBucketReplication(PutBucketReplicationRequest putBucketReplicationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketReplicationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketReplication").withMarshaller((Marshaller)new PutBucketReplicationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketReplicationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutBucketRequestPaymentResponse> putBucketRequestPayment(PutBucketRequestPaymentRequest putBucketRequestPaymentRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketRequestPaymentResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketRequestPayment").withMarshaller((Marshaller)new PutBucketRequestPaymentRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketRequestPaymentRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutBucketTaggingResponse> putBucketTagging(PutBucketTaggingRequest putBucketTaggingRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketTagging").withMarshaller((Marshaller)new PutBucketTaggingRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketTaggingRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutBucketVersioningResponse> putBucketVersioning(PutBucketVersioningRequest putBucketVersioningRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketVersioningResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketVersioning").withMarshaller((Marshaller)new PutBucketVersioningRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketVersioningRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutBucketWebsiteResponse> putBucketWebsite(PutBucketWebsiteRequest putBucketWebsiteRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutBucketWebsiteResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBucketWebsite").withMarshaller((Marshaller)new PutBucketWebsiteRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putBucketWebsiteRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutObjectResponse> putObject(PutObjectRequest putObjectRequest, AsyncRequestBody requestBody) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutObjectResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutObject").withMarshaller((Marshaller)((AsyncStreamingRequestMarshaller.Builder)AsyncStreamingRequestMarshaller.builder().delegateMarshaller((Marshaller)new PutObjectRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory))).asyncRequestBody(requestBody).build()).withCombinedResponseHandler(responseHandler).withAsyncRequestBody(requestBody).withInput((SdkRequest)putObjectRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutObjectAclResponse> putObjectAcl(PutObjectAclRequest putObjectAclRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutObjectAclResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutObjectAcl").withMarshaller((Marshaller)new PutObjectAclRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putObjectAclRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutObjectLegalHoldResponse> putObjectLegalHold(PutObjectLegalHoldRequest putObjectLegalHoldRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutObjectLegalHoldResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutObjectLegalHold").withMarshaller((Marshaller)new PutObjectLegalHoldRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putObjectLegalHoldRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutObjectLockConfigurationResponse> putObjectLockConfiguration(PutObjectLockConfigurationRequest putObjectLockConfigurationRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutObjectLockConfigurationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutObjectLockConfiguration").withMarshaller((Marshaller)new PutObjectLockConfigurationRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putObjectLockConfigurationRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutObjectRetentionResponse> putObjectRetention(PutObjectRetentionRequest putObjectRetentionRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutObjectRetentionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutObjectRetention").withMarshaller((Marshaller)new PutObjectRetentionRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putObjectRetentionRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutObjectTaggingResponse> putObjectTagging(PutObjectTaggingRequest putObjectTaggingRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutObjectTaggingResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutObjectTagging").withMarshaller((Marshaller)new PutObjectTaggingRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putObjectTaggingRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutPublicAccessBlockResponse> putPublicAccessBlock(PutPublicAccessBlockRequest putPublicAccessBlockRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(PutPublicAccessBlockResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutPublicAccessBlock").withMarshaller((Marshaller)new PutPublicAccessBlockRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)putPublicAccessBlockRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RestoreObjectResponse> restoreObject(RestoreObjectRequest restoreObjectRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(RestoreObjectResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreObject").withMarshaller((Marshaller)new RestoreObjectRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)restoreObjectRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UploadPartResponse> uploadPart(UploadPartRequest uploadPartRequest, AsyncRequestBody requestBody) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UploadPartResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UploadPart").withMarshaller((Marshaller)((AsyncStreamingRequestMarshaller.Builder)AsyncStreamingRequestMarshaller.builder().delegateMarshaller((Marshaller)new UploadPartRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory))).asyncRequestBody(requestBody).build()).withCombinedResponseHandler(responseHandler).withAsyncRequestBody(requestBody).withInput((SdkRequest)uploadPartRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UploadPartCopyResponse> uploadPartCopy(UploadPartCopyRequest uploadPartCopyRequest) {
        try {
            HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UploadPartCopyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UploadPartCopy").withMarshaller((Marshaller)new UploadPartCopyRequestMarshaller((AwsXmlProtocolFactory)this.protocolFactory)).withCombinedResponseHandler(responseHandler).withInput((SdkRequest)uploadPartCopyRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private AwsS3ProtocolFactory init() {
        return ((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)((AwsS3ProtocolFactory.Builder)AwsS3ProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchUpload").exceptionBuilderSupplier(NoSuchUploadException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("ObjectAlreadyInActiveTierError").exceptionBuilderSupplier(ObjectAlreadyInActiveTierErrorException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("BucketAlreadyExists").exceptionBuilderSupplier(BucketAlreadyExistsException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchBucket").exceptionBuilderSupplier(NoSuchBucketException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("ObjectNotInActiveTierError").exceptionBuilderSupplier(ObjectNotInActiveTierErrorException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("BucketAlreadyOwnedByYou").exceptionBuilderSupplier(BucketAlreadyOwnedByYouException::builder).build())).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchKey").exceptionBuilderSupplier(NoSuchKeyException::builder).build())).clientConfiguration(this.clientConfiguration)).defaultServiceExceptionSupplier(S3Exception::builder)).build();
    }

    private <T extends S3Request> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.21").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((S3Request)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    @Override
    public S3Utilities utilities() {
        return S3Utilities.create(this.clientConfiguration);
    }
}

