/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rum.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rum.RumAsyncClient;
import software.amazon.awssdk.services.rum.internal.UserAgentUtils;
import software.amazon.awssdk.services.rum.model.AppMonitorSummary;
import software.amazon.awssdk.services.rum.model.ListAppMonitorsRequest;
import software.amazon.awssdk.services.rum.model.ListAppMonitorsResponse;

public class ListAppMonitorsPublisher
implements SdkPublisher<ListAppMonitorsResponse> {
    private final RumAsyncClient client;
    private final ListAppMonitorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAppMonitorsPublisher(RumAsyncClient client, ListAppMonitorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAppMonitorsPublisher(RumAsyncClient client, ListAppMonitorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAppMonitorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAppMonitorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AppMonitorSummary> appMonitorSummaries() {
        Function<ListAppMonitorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.appMonitorSummaries() != null) {
                return response.appMonitorSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAppMonitorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAppMonitorsResponseFetcher
    implements AsyncPageFetcher<ListAppMonitorsResponse> {
        private ListAppMonitorsResponseFetcher() {
        }

        public boolean hasNextPage(ListAppMonitorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAppMonitorsResponse> nextPage(ListAppMonitorsResponse previousPage) {
            if (previousPage == null) {
                return ListAppMonitorsPublisher.this.client.listAppMonitors(ListAppMonitorsPublisher.this.firstRequest);
            }
            return ListAppMonitorsPublisher.this.client.listAppMonitors((ListAppMonitorsRequest)((Object)ListAppMonitorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

