/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rtbfabric.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rtbfabric.RtbFabricAsyncClient;
import software.amazon.awssdk.services.rtbfabric.internal.UserAgentUtils;
import software.amazon.awssdk.services.rtbfabric.model.ListRequesterGatewaysRequest;
import software.amazon.awssdk.services.rtbfabric.model.ListRequesterGatewaysResponse;

public class ListRequesterGatewaysPublisher
implements SdkPublisher<ListRequesterGatewaysResponse> {
    private final RtbFabricAsyncClient client;
    private final ListRequesterGatewaysRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRequesterGatewaysPublisher(RtbFabricAsyncClient client, ListRequesterGatewaysRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRequesterGatewaysPublisher(RtbFabricAsyncClient client, ListRequesterGatewaysRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRequesterGatewaysResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRequesterGatewaysResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> gatewayIds() {
        Function<ListRequesterGatewaysResponse, Iterator> getIterator = response -> {
            if (response != null && response.gatewayIds() != null) {
                return response.gatewayIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRequesterGatewaysResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRequesterGatewaysResponseFetcher
    implements AsyncPageFetcher<ListRequesterGatewaysResponse> {
        private ListRequesterGatewaysResponseFetcher() {
        }

        public boolean hasNextPage(ListRequesterGatewaysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRequesterGatewaysResponse> nextPage(ListRequesterGatewaysResponse previousPage) {
            if (previousPage == null) {
                return ListRequesterGatewaysPublisher.this.client.listRequesterGateways(ListRequesterGatewaysPublisher.this.firstRequest);
            }
            return ListRequesterGatewaysPublisher.this.client.listRequesterGateways((ListRequesterGatewaysRequest)((Object)ListRequesterGatewaysPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

