/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rtbfabric.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rtbfabric.model.ManagedEndpointConfiguration;
import software.amazon.awssdk.services.rtbfabric.model.Protocol;
import software.amazon.awssdk.services.rtbfabric.model.RtbFabricRequest;
import software.amazon.awssdk.services.rtbfabric.model.TrustStoreConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateResponderGatewayRequest
extends RtbFabricRequest
implements ToCopyableBuilder<Builder, UpdateResponderGatewayRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainName").getter(UpdateResponderGatewayRequest.getter(UpdateResponderGatewayRequest::domainName)).setter(UpdateResponderGatewayRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("port").getter(UpdateResponderGatewayRequest.getter(UpdateResponderGatewayRequest::port)).setter(UpdateResponderGatewayRequest.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocol").getter(UpdateResponderGatewayRequest.getter(UpdateResponderGatewayRequest::protocolAsString)).setter(UpdateResponderGatewayRequest.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<TrustStoreConfiguration> TRUST_STORE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trustStoreConfiguration").getter(UpdateResponderGatewayRequest.getter(UpdateResponderGatewayRequest::trustStoreConfiguration)).setter(UpdateResponderGatewayRequest.setter(Builder::trustStoreConfiguration)).constructor(TrustStoreConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustStoreConfiguration").build()}).build();
    private static final SdkField<ManagedEndpointConfiguration> MANAGED_ENDPOINT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("managedEndpointConfiguration").getter(UpdateResponderGatewayRequest.getter(UpdateResponderGatewayRequest::managedEndpointConfiguration)).setter(UpdateResponderGatewayRequest.setter(Builder::managedEndpointConfiguration)).constructor(ManagedEndpointConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedEndpointConfiguration").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateResponderGatewayRequest.getter(UpdateResponderGatewayRequest::clientToken)).setter(UpdateResponderGatewayRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("gatewayId").getter(UpdateResponderGatewayRequest.getter(UpdateResponderGatewayRequest::gatewayId)).setter(UpdateResponderGatewayRequest.setter(Builder::gatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("gatewayId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateResponderGatewayRequest.getter(UpdateResponderGatewayRequest::description)).setter(UpdateResponderGatewayRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, PORT_FIELD, PROTOCOL_FIELD, TRUST_STORE_CONFIGURATION_FIELD, MANAGED_ENDPOINT_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD, GATEWAY_ID_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateResponderGatewayRequest.memberNameToFieldInitializer();
    private final String domainName;
    private final Integer port;
    private final String protocol;
    private final TrustStoreConfiguration trustStoreConfiguration;
    private final ManagedEndpointConfiguration managedEndpointConfiguration;
    private final String clientToken;
    private final String gatewayId;
    private final String description;

    private UpdateResponderGatewayRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.trustStoreConfiguration = builder.trustStoreConfiguration;
        this.managedEndpointConfiguration = builder.managedEndpointConfiguration;
        this.clientToken = builder.clientToken;
        this.gatewayId = builder.gatewayId;
        this.description = builder.description;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final Integer port() {
        return this.port;
    }

    public final Protocol protocol() {
        return Protocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final TrustStoreConfiguration trustStoreConfiguration() {
        return this.trustStoreConfiguration;
    }

    public final ManagedEndpointConfiguration managedEndpointConfiguration() {
        return this.managedEndpointConfiguration;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String gatewayId() {
        return this.gatewayId;
    }

    public final String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustStoreConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedEndpointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResponderGatewayRequest)) {
            return false;
        }
        UpdateResponderGatewayRequest other = (UpdateResponderGatewayRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.trustStoreConfiguration(), other.trustStoreConfiguration()) && Objects.equals(this.managedEndpointConfiguration(), other.managedEndpointConfiguration()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.gatewayId(), other.gatewayId()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateResponderGatewayRequest").add("DomainName", (Object)this.domainName()).add("Port", (Object)this.port()).add("Protocol", (Object)this.protocolAsString()).add("TrustStoreConfiguration", (Object)this.trustStoreConfiguration()).add("ManagedEndpointConfiguration", (Object)this.managedEndpointConfiguration()).add("ClientToken", (Object)this.clientToken()).add("GatewayId", (Object)this.gatewayId()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "trustStoreConfiguration": {
                return Optional.ofNullable(clazz.cast(this.trustStoreConfiguration()));
            }
            case "managedEndpointConfiguration": {
                return Optional.ofNullable(clazz.cast(this.managedEndpointConfiguration()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "gatewayId": {
                return Optional.ofNullable(clazz.cast(this.gatewayId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("port", PORT_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("trustStoreConfiguration", TRUST_STORE_CONFIGURATION_FIELD);
        map.put("managedEndpointConfiguration", MANAGED_ENDPOINT_CONFIGURATION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("gatewayId", GATEWAY_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateResponderGatewayRequest, T> g) {
        return obj -> g.apply((UpdateResponderGatewayRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RtbFabricRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private Integer port;
        private String protocol;
        private TrustStoreConfiguration trustStoreConfiguration;
        private ManagedEndpointConfiguration managedEndpointConfiguration;
        private String clientToken;
        private String gatewayId;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResponderGatewayRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.port(model.port);
            this.protocol(model.protocol);
            this.trustStoreConfiguration(model.trustStoreConfiguration);
            this.managedEndpointConfiguration(model.managedEndpointConfiguration);
            this.clientToken(model.clientToken);
            this.gatewayId(model.gatewayId);
            this.description(model.description);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final TrustStoreConfiguration.Builder getTrustStoreConfiguration() {
            return this.trustStoreConfiguration != null ? this.trustStoreConfiguration.toBuilder() : null;
        }

        public final void setTrustStoreConfiguration(TrustStoreConfiguration.BuilderImpl trustStoreConfiguration) {
            this.trustStoreConfiguration = trustStoreConfiguration != null ? trustStoreConfiguration.build() : null;
        }

        @Override
        public final Builder trustStoreConfiguration(TrustStoreConfiguration trustStoreConfiguration) {
            this.trustStoreConfiguration = trustStoreConfiguration;
            return this;
        }

        public final ManagedEndpointConfiguration.Builder getManagedEndpointConfiguration() {
            return this.managedEndpointConfiguration != null ? this.managedEndpointConfiguration.toBuilder() : null;
        }

        public final void setManagedEndpointConfiguration(ManagedEndpointConfiguration.BuilderImpl managedEndpointConfiguration) {
            this.managedEndpointConfiguration = managedEndpointConfiguration != null ? managedEndpointConfiguration.build() : null;
        }

        @Override
        public final Builder managedEndpointConfiguration(ManagedEndpointConfiguration managedEndpointConfiguration) {
            this.managedEndpointConfiguration = managedEndpointConfiguration;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getGatewayId() {
            return this.gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResponderGatewayRequest build() {
            return new UpdateResponderGatewayRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RtbFabricRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateResponderGatewayRequest> {
        public Builder domainName(String var1);

        public Builder port(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(Protocol var1);

        public Builder trustStoreConfiguration(TrustStoreConfiguration var1);

        default public Builder trustStoreConfiguration(Consumer<TrustStoreConfiguration.Builder> trustStoreConfiguration) {
            return this.trustStoreConfiguration((TrustStoreConfiguration)((TrustStoreConfiguration.Builder)TrustStoreConfiguration.builder().applyMutation(trustStoreConfiguration)).build());
        }

        public Builder managedEndpointConfiguration(ManagedEndpointConfiguration var1);

        default public Builder managedEndpointConfiguration(Consumer<ManagedEndpointConfiguration.Builder> managedEndpointConfiguration) {
            return this.managedEndpointConfiguration((ManagedEndpointConfiguration)((ManagedEndpointConfiguration.Builder)ManagedEndpointConfiguration.builder().applyMutation(managedEndpointConfiguration)).build());
        }

        public Builder clientToken(String var1);

        public Builder gatewayId(String var1);

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

