/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rtbfabric.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.rtbfabric.model.NoBidModuleParameters;
import software.amazon.awssdk.services.rtbfabric.model.OpenRtbAttributeModuleParameters;
import software.amazon.awssdk.services.rtbfabric.model.RateLimiterModuleParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModuleParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModuleParameters> {
    private static final SdkField<NoBidModuleParameters> NO_BID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("noBid").getter(ModuleParameters.getter(ModuleParameters::noBid)).setter(ModuleParameters.setter(Builder::noBid)).constructor(NoBidModuleParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noBid").build()}).build();
    private static final SdkField<OpenRtbAttributeModuleParameters> OPEN_RTB_ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("openRtbAttribute").getter(ModuleParameters.getter(ModuleParameters::openRtbAttribute)).setter(ModuleParameters.setter(Builder::openRtbAttribute)).constructor(OpenRtbAttributeModuleParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openRtbAttribute").build()}).build();
    private static final SdkField<RateLimiterModuleParameters> RATE_LIMITER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rateLimiter").getter(ModuleParameters.getter(ModuleParameters::rateLimiter)).setter(ModuleParameters.setter(Builder::rateLimiter)).constructor(RateLimiterModuleParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateLimiter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NO_BID_FIELD, OPEN_RTB_ATTRIBUTE_FIELD, RATE_LIMITER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModuleParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final NoBidModuleParameters noBid;
    private final OpenRtbAttributeModuleParameters openRtbAttribute;
    private final RateLimiterModuleParameters rateLimiter;
    private final Type type;

    private ModuleParameters(BuilderImpl builder) {
        this.noBid = builder.noBid;
        this.openRtbAttribute = builder.openRtbAttribute;
        this.rateLimiter = builder.rateLimiter;
        this.type = builder.type;
    }

    public final NoBidModuleParameters noBid() {
        return this.noBid;
    }

    public final OpenRtbAttributeModuleParameters openRtbAttribute() {
        return this.openRtbAttribute;
    }

    public final RateLimiterModuleParameters rateLimiter() {
        return this.rateLimiter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.noBid());
        hashCode = 31 * hashCode + Objects.hashCode(this.openRtbAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateLimiter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModuleParameters)) {
            return false;
        }
        ModuleParameters other = (ModuleParameters)obj;
        return Objects.equals(this.noBid(), other.noBid()) && Objects.equals(this.openRtbAttribute(), other.openRtbAttribute()) && Objects.equals(this.rateLimiter(), other.rateLimiter());
    }

    public final String toString() {
        return ToString.builder((String)"ModuleParameters").add("NoBid", (Object)this.noBid()).add("OpenRtbAttribute", (Object)this.openRtbAttribute()).add("RateLimiter", (Object)this.rateLimiter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "noBid": {
                return Optional.ofNullable(clazz.cast(this.noBid()));
            }
            case "openRtbAttribute": {
                return Optional.ofNullable(clazz.cast(this.openRtbAttribute()));
            }
            case "rateLimiter": {
                return Optional.ofNullable(clazz.cast(this.rateLimiter()));
            }
        }
        return Optional.empty();
    }

    public static ModuleParameters fromNoBid(NoBidModuleParameters noBid) {
        return (ModuleParameters)ModuleParameters.builder().noBid(noBid).build();
    }

    public static ModuleParameters fromNoBid(Consumer<NoBidModuleParameters.Builder> noBid) {
        NoBidModuleParameters.Builder builder = NoBidModuleParameters.builder();
        noBid.accept(builder);
        return ModuleParameters.fromNoBid((NoBidModuleParameters)builder.build());
    }

    public static ModuleParameters fromOpenRtbAttribute(OpenRtbAttributeModuleParameters openRtbAttribute) {
        return (ModuleParameters)ModuleParameters.builder().openRtbAttribute(openRtbAttribute).build();
    }

    public static ModuleParameters fromOpenRtbAttribute(Consumer<OpenRtbAttributeModuleParameters.Builder> openRtbAttribute) {
        OpenRtbAttributeModuleParameters.Builder builder = OpenRtbAttributeModuleParameters.builder();
        openRtbAttribute.accept(builder);
        return ModuleParameters.fromOpenRtbAttribute((OpenRtbAttributeModuleParameters)builder.build());
    }

    public static ModuleParameters fromRateLimiter(RateLimiterModuleParameters rateLimiter) {
        return (ModuleParameters)ModuleParameters.builder().rateLimiter(rateLimiter).build();
    }

    public static ModuleParameters fromRateLimiter(Consumer<RateLimiterModuleParameters.Builder> rateLimiter) {
        RateLimiterModuleParameters.Builder builder = RateLimiterModuleParameters.builder();
        rateLimiter.accept(builder);
        return ModuleParameters.fromRateLimiter((RateLimiterModuleParameters)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("noBid", NO_BID_FIELD);
        map.put("openRtbAttribute", OPEN_RTB_ATTRIBUTE_FIELD);
        map.put("rateLimiter", RATE_LIMITER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModuleParameters, T> g) {
        return obj -> g.apply((ModuleParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        NO_BID,
        OPEN_RTB_ATTRIBUTE,
        RATE_LIMITER,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private NoBidModuleParameters noBid;
        private OpenRtbAttributeModuleParameters openRtbAttribute;
        private RateLimiterModuleParameters rateLimiter;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ModuleParameters model) {
            this.noBid(model.noBid);
            this.openRtbAttribute(model.openRtbAttribute);
            this.rateLimiter(model.rateLimiter);
        }

        public final NoBidModuleParameters.Builder getNoBid() {
            return this.noBid != null ? this.noBid.toBuilder() : null;
        }

        public final void setNoBid(NoBidModuleParameters.BuilderImpl noBid) {
            NoBidModuleParameters oldValue = this.noBid;
            this.noBid = noBid != null ? noBid.build() : null;
            this.handleUnionValueChange(Type.NO_BID, oldValue, this.noBid);
        }

        @Override
        public final Builder noBid(NoBidModuleParameters noBid) {
            NoBidModuleParameters oldValue = this.noBid;
            this.noBid = noBid;
            this.handleUnionValueChange(Type.NO_BID, oldValue, this.noBid);
            return this;
        }

        public final OpenRtbAttributeModuleParameters.Builder getOpenRtbAttribute() {
            return this.openRtbAttribute != null ? this.openRtbAttribute.toBuilder() : null;
        }

        public final void setOpenRtbAttribute(OpenRtbAttributeModuleParameters.BuilderImpl openRtbAttribute) {
            OpenRtbAttributeModuleParameters oldValue = this.openRtbAttribute;
            this.openRtbAttribute = openRtbAttribute != null ? openRtbAttribute.build() : null;
            this.handleUnionValueChange(Type.OPEN_RTB_ATTRIBUTE, oldValue, this.openRtbAttribute);
        }

        @Override
        public final Builder openRtbAttribute(OpenRtbAttributeModuleParameters openRtbAttribute) {
            OpenRtbAttributeModuleParameters oldValue = this.openRtbAttribute;
            this.openRtbAttribute = openRtbAttribute;
            this.handleUnionValueChange(Type.OPEN_RTB_ATTRIBUTE, oldValue, this.openRtbAttribute);
            return this;
        }

        public final RateLimiterModuleParameters.Builder getRateLimiter() {
            return this.rateLimiter != null ? this.rateLimiter.toBuilder() : null;
        }

        public final void setRateLimiter(RateLimiterModuleParameters.BuilderImpl rateLimiter) {
            RateLimiterModuleParameters oldValue = this.rateLimiter;
            this.rateLimiter = rateLimiter != null ? rateLimiter.build() : null;
            this.handleUnionValueChange(Type.RATE_LIMITER, oldValue, this.rateLimiter);
        }

        @Override
        public final Builder rateLimiter(RateLimiterModuleParameters rateLimiter) {
            RateLimiterModuleParameters oldValue = this.rateLimiter;
            this.rateLimiter = rateLimiter;
            this.handleUnionValueChange(Type.RATE_LIMITER, oldValue, this.rateLimiter);
            return this;
        }

        public ModuleParameters build() {
            return new ModuleParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModuleParameters> {
        public Builder noBid(NoBidModuleParameters var1);

        default public Builder noBid(Consumer<NoBidModuleParameters.Builder> noBid) {
            return this.noBid((NoBidModuleParameters)((NoBidModuleParameters.Builder)NoBidModuleParameters.builder().applyMutation(noBid)).build());
        }

        public Builder openRtbAttribute(OpenRtbAttributeModuleParameters var1);

        default public Builder openRtbAttribute(Consumer<OpenRtbAttributeModuleParameters.Builder> openRtbAttribute) {
            return this.openRtbAttribute((OpenRtbAttributeModuleParameters)((OpenRtbAttributeModuleParameters.Builder)OpenRtbAttributeModuleParameters.builder().applyMutation(openRtbAttribute)).build());
        }

        public Builder rateLimiter(RateLimiterModuleParameters var1);

        default public Builder rateLimiter(Consumer<RateLimiterModuleParameters.Builder> rateLimiter) {
            return this.rateLimiter((RateLimiterModuleParameters)((RateLimiterModuleParameters.Builder)RateLimiterModuleParameters.builder().applyMutation(rateLimiter)).build());
        }
    }
}

