/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rtbfabric.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rtbfabric.model.GatewayIdListCopier;
import software.amazon.awssdk.services.rtbfabric.model.RtbFabricResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRequesterGatewaysResponse
extends RtbFabricResponse
implements ToCopyableBuilder<Builder, ListRequesterGatewaysResponse> {
    private static final SdkField<List<String>> GATEWAY_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("gatewayIds").getter(ListRequesterGatewaysResponse.getter(ListRequesterGatewaysResponse::gatewayIds)).setter(ListRequesterGatewaysResponse.setter(Builder::gatewayIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListRequesterGatewaysResponse.getter(ListRequesterGatewaysResponse::nextToken)).setter(ListRequesterGatewaysResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_IDS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRequesterGatewaysResponse.memberNameToFieldInitializer();
    private final List<String> gatewayIds;
    private final String nextToken;

    private ListRequesterGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayIds = builder.gatewayIds;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasGatewayIds() {
        return this.gatewayIds != null && !(this.gatewayIds instanceof SdkAutoConstructList);
    }

    public final List<String> gatewayIds() {
        return this.gatewayIds;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGatewayIds() ? this.gatewayIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRequesterGatewaysResponse)) {
            return false;
        }
        ListRequesterGatewaysResponse other = (ListRequesterGatewaysResponse)((Object)obj);
        return this.hasGatewayIds() == other.hasGatewayIds() && Objects.equals(this.gatewayIds(), other.gatewayIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRequesterGatewaysResponse").add("GatewayIds", this.hasGatewayIds() ? this.gatewayIds() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "gatewayIds": {
                return Optional.ofNullable(clazz.cast(this.gatewayIds()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("gatewayIds", GATEWAY_IDS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRequesterGatewaysResponse, T> g) {
        return obj -> g.apply((ListRequesterGatewaysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RtbFabricResponse.BuilderImpl
    implements Builder {
        private List<String> gatewayIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRequesterGatewaysResponse model) {
            super(model);
            this.gatewayIds(model.gatewayIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getGatewayIds() {
            if (this.gatewayIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.gatewayIds;
        }

        public final void setGatewayIds(Collection<String> gatewayIds) {
            this.gatewayIds = GatewayIdListCopier.copy(gatewayIds);
        }

        @Override
        public final Builder gatewayIds(Collection<String> gatewayIds) {
            this.gatewayIds = GatewayIdListCopier.copy(gatewayIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayIds(String ... gatewayIds) {
            this.gatewayIds(Arrays.asList(gatewayIds));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRequesterGatewaysResponse build() {
            return new ListRequesterGatewaysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RtbFabricResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRequesterGatewaysResponse> {
        public Builder gatewayIds(Collection<String> var1);

        public Builder gatewayIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

