/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rtbfabric.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.rtbfabric.RtbFabricClient;
import software.amazon.awssdk.services.rtbfabric.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.rtbfabric.model.GetInboundExternalLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetInboundExternalLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.GetLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.GetOutboundExternalLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetOutboundExternalLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.GetRequesterGatewayRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetRequesterGatewayResponse;
import software.amazon.awssdk.services.rtbfabric.model.GetResponderGatewayRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetResponderGatewayResponse;
import software.amazon.awssdk.services.rtbfabric.model.RtbFabricRequest;
import software.amazon.awssdk.services.rtbfabric.waiters.RtbFabricWaiter;
import software.amazon.awssdk.services.rtbfabric.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultRtbFabricWaiter
implements RtbFabricWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final RtbFabricClient client;
    private final AttributeMap managedResources;
    private final Waiter<GetInboundExternalLinkResponse> inboundExternalLinkActiveWaiter;
    private final Waiter<GetLinkResponse> linkAcceptedWaiter;
    private final Waiter<GetLinkResponse> linkActiveWaiter;
    private final Waiter<GetOutboundExternalLinkResponse> outboundExternalLinkActiveWaiter;
    private final Waiter<GetRequesterGatewayResponse> requesterGatewayActiveWaiter;
    private final Waiter<GetRequesterGatewayResponse> requesterGatewayDeletedWaiter;
    private final Waiter<GetResponderGatewayResponse> responderGatewayActiveWaiter;
    private final Waiter<GetResponderGatewayResponse> responderGatewayDeletedWaiter;

    private DefaultRtbFabricWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (RtbFabricClient)RtbFabricClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.inboundExternalLinkActiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetInboundExternalLinkResponse.class).acceptors(DefaultRtbFabricWaiter.inboundExternalLinkActiveWaiterAcceptors())).overrideConfiguration(DefaultRtbFabricWaiter.inboundExternalLinkActiveWaiterConfig(builder.overrideConfiguration))).build();
        this.linkAcceptedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetLinkResponse.class).acceptors(DefaultRtbFabricWaiter.linkAcceptedWaiterAcceptors())).overrideConfiguration(DefaultRtbFabricWaiter.linkAcceptedWaiterConfig(builder.overrideConfiguration))).build();
        this.linkActiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetLinkResponse.class).acceptors(DefaultRtbFabricWaiter.linkActiveWaiterAcceptors())).overrideConfiguration(DefaultRtbFabricWaiter.linkActiveWaiterConfig(builder.overrideConfiguration))).build();
        this.outboundExternalLinkActiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetOutboundExternalLinkResponse.class).acceptors(DefaultRtbFabricWaiter.outboundExternalLinkActiveWaiterAcceptors())).overrideConfiguration(DefaultRtbFabricWaiter.outboundExternalLinkActiveWaiterConfig(builder.overrideConfiguration))).build();
        this.requesterGatewayActiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetRequesterGatewayResponse.class).acceptors(DefaultRtbFabricWaiter.requesterGatewayActiveWaiterAcceptors())).overrideConfiguration(DefaultRtbFabricWaiter.requesterGatewayActiveWaiterConfig(builder.overrideConfiguration))).build();
        this.requesterGatewayDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetRequesterGatewayResponse.class).acceptors(DefaultRtbFabricWaiter.requesterGatewayDeletedWaiterAcceptors())).overrideConfiguration(DefaultRtbFabricWaiter.requesterGatewayDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.responderGatewayActiveWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetResponderGatewayResponse.class).acceptors(DefaultRtbFabricWaiter.responderGatewayActiveWaiterAcceptors())).overrideConfiguration(DefaultRtbFabricWaiter.responderGatewayActiveWaiterConfig(builder.overrideConfiguration))).build();
        this.responderGatewayDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetResponderGatewayResponse.class).acceptors(DefaultRtbFabricWaiter.responderGatewayDeletedWaiterAcceptors())).overrideConfiguration(DefaultRtbFabricWaiter.responderGatewayDeletedWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<GetInboundExternalLinkResponse> waitUntilInboundExternalLinkActive(GetInboundExternalLinkRequest getInboundExternalLinkRequest) {
        return this.inboundExternalLinkActiveWaiter.run(() -> this.client.getInboundExternalLink(this.applyWaitersUserAgent(getInboundExternalLinkRequest)));
    }

    @Override
    public WaiterResponse<GetInboundExternalLinkResponse> waitUntilInboundExternalLinkActive(GetInboundExternalLinkRequest getInboundExternalLinkRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.inboundExternalLinkActiveWaiter.run(() -> this.client.getInboundExternalLink(this.applyWaitersUserAgent(getInboundExternalLinkRequest)), DefaultRtbFabricWaiter.inboundExternalLinkActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetLinkResponse> waitUntilLinkAccepted(GetLinkRequest getLinkRequest) {
        return this.linkAcceptedWaiter.run(() -> this.client.getLink(this.applyWaitersUserAgent(getLinkRequest)));
    }

    @Override
    public WaiterResponse<GetLinkResponse> waitUntilLinkAccepted(GetLinkRequest getLinkRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.linkAcceptedWaiter.run(() -> this.client.getLink(this.applyWaitersUserAgent(getLinkRequest)), DefaultRtbFabricWaiter.linkAcceptedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetLinkResponse> waitUntilLinkActive(GetLinkRequest getLinkRequest) {
        return this.linkActiveWaiter.run(() -> this.client.getLink(this.applyWaitersUserAgent(getLinkRequest)));
    }

    @Override
    public WaiterResponse<GetLinkResponse> waitUntilLinkActive(GetLinkRequest getLinkRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.linkActiveWaiter.run(() -> this.client.getLink(this.applyWaitersUserAgent(getLinkRequest)), DefaultRtbFabricWaiter.linkActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetOutboundExternalLinkResponse> waitUntilOutboundExternalLinkActive(GetOutboundExternalLinkRequest getOutboundExternalLinkRequest) {
        return this.outboundExternalLinkActiveWaiter.run(() -> this.client.getOutboundExternalLink(this.applyWaitersUserAgent(getOutboundExternalLinkRequest)));
    }

    @Override
    public WaiterResponse<GetOutboundExternalLinkResponse> waitUntilOutboundExternalLinkActive(GetOutboundExternalLinkRequest getOutboundExternalLinkRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.outboundExternalLinkActiveWaiter.run(() -> this.client.getOutboundExternalLink(this.applyWaitersUserAgent(getOutboundExternalLinkRequest)), DefaultRtbFabricWaiter.outboundExternalLinkActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetRequesterGatewayResponse> waitUntilRequesterGatewayActive(GetRequesterGatewayRequest getRequesterGatewayRequest) {
        return this.requesterGatewayActiveWaiter.run(() -> this.client.getRequesterGateway(this.applyWaitersUserAgent(getRequesterGatewayRequest)));
    }

    @Override
    public WaiterResponse<GetRequesterGatewayResponse> waitUntilRequesterGatewayActive(GetRequesterGatewayRequest getRequesterGatewayRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.requesterGatewayActiveWaiter.run(() -> this.client.getRequesterGateway(this.applyWaitersUserAgent(getRequesterGatewayRequest)), DefaultRtbFabricWaiter.requesterGatewayActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetRequesterGatewayResponse> waitUntilRequesterGatewayDeleted(GetRequesterGatewayRequest getRequesterGatewayRequest) {
        return this.requesterGatewayDeletedWaiter.run(() -> this.client.getRequesterGateway(this.applyWaitersUserAgent(getRequesterGatewayRequest)));
    }

    @Override
    public WaiterResponse<GetRequesterGatewayResponse> waitUntilRequesterGatewayDeleted(GetRequesterGatewayRequest getRequesterGatewayRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.requesterGatewayDeletedWaiter.run(() -> this.client.getRequesterGateway(this.applyWaitersUserAgent(getRequesterGatewayRequest)), DefaultRtbFabricWaiter.requesterGatewayDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetResponderGatewayResponse> waitUntilResponderGatewayActive(GetResponderGatewayRequest getResponderGatewayRequest) {
        return this.responderGatewayActiveWaiter.run(() -> this.client.getResponderGateway(this.applyWaitersUserAgent(getResponderGatewayRequest)));
    }

    @Override
    public WaiterResponse<GetResponderGatewayResponse> waitUntilResponderGatewayActive(GetResponderGatewayRequest getResponderGatewayRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.responderGatewayActiveWaiter.run(() -> this.client.getResponderGateway(this.applyWaitersUserAgent(getResponderGatewayRequest)), DefaultRtbFabricWaiter.responderGatewayActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetResponderGatewayResponse> waitUntilResponderGatewayDeleted(GetResponderGatewayRequest getResponderGatewayRequest) {
        return this.responderGatewayDeletedWaiter.run(() -> this.client.getResponderGateway(this.applyWaitersUserAgent(getResponderGatewayRequest)));
    }

    @Override
    public WaiterResponse<GetResponderGatewayResponse> waitUntilResponderGatewayDeleted(GetResponderGatewayRequest getResponderGatewayRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.responderGatewayDeletedWaiter.run(() -> this.client.getResponderGateway(this.applyWaitersUserAgent(getResponderGatewayRequest)), DefaultRtbFabricWaiter.responderGatewayDeletedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetInboundExternalLinkResponse>> inboundExternalLinkActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetInboundExternalLinkResponse>> result = new ArrayList<WaiterAcceptor<? super GetInboundExternalLinkResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "REJECTED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=REJECTED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=DELETED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ISOLATED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=ISOLATED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetLinkResponse>> linkAcceptedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetLinkResponse>> result = new ArrayList<WaiterAcceptor<? super GetLinkResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACCEPTED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "REJECTED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=REJECTED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=DELETED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetLinkResponse>> linkActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetLinkResponse>> result = new ArrayList<WaiterAcceptor<? super GetLinkResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "REJECTED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=REJECTED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=DELETED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetOutboundExternalLinkResponse>> outboundExternalLinkActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetOutboundExternalLinkResponse>> result = new ArrayList<WaiterAcceptor<? super GetOutboundExternalLinkResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "REJECTED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=REJECTED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=DELETED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ISOLATED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=ISOLATED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRequesterGatewayResponse>> requesterGatewayActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetRequesterGatewayResponse>> result = new ArrayList<WaiterAcceptor<? super GetRequesterGatewayResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=DELETED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRequesterGatewayResponse>> requesterGatewayDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetRequesterGatewayResponse>> result = new ArrayList<WaiterAcceptor<? super GetRequesterGatewayResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetResponderGatewayResponse>> responderGatewayActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetResponderGatewayResponse>> result = new ArrayList<WaiterAcceptor<? super GetResponderGatewayResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=DELETED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetResponderGatewayResponse>> responderGatewayDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetResponderGatewayResponse>> result = new ArrayList<WaiterAcceptor<? super GetResponderGatewayResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration inboundExternalLinkActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration linkAcceptedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration linkActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration outboundExternalLinkActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration requesterGatewayActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration requesterGatewayDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration responderGatewayActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration responderGatewayDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static RtbFabricWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends RtbFabricRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((RtbFabricRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements RtbFabricWaiter.Builder {
        private RtbFabricClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public RtbFabricWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public RtbFabricWaiter.Builder client(RtbFabricClient client) {
            this.client = client;
            return this;
        }

        @Override
        public RtbFabricWaiter build() {
            return new DefaultRtbFabricWaiter(this);
        }
    }
}

