/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rtbfabric.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.rtbfabric.RtbFabricAsyncClient;
import software.amazon.awssdk.services.rtbfabric.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.rtbfabric.model.GetInboundExternalLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetInboundExternalLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.GetLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.GetOutboundExternalLinkRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetOutboundExternalLinkResponse;
import software.amazon.awssdk.services.rtbfabric.model.GetRequesterGatewayRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetRequesterGatewayResponse;
import software.amazon.awssdk.services.rtbfabric.model.GetResponderGatewayRequest;
import software.amazon.awssdk.services.rtbfabric.model.GetResponderGatewayResponse;
import software.amazon.awssdk.services.rtbfabric.model.RtbFabricRequest;
import software.amazon.awssdk.services.rtbfabric.waiters.RtbFabricAsyncWaiter;
import software.amazon.awssdk.services.rtbfabric.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultRtbFabricAsyncWaiter
implements RtbFabricAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final RtbFabricAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<GetInboundExternalLinkResponse> inboundExternalLinkActiveWaiter;
    private final AsyncWaiter<GetLinkResponse> linkAcceptedWaiter;
    private final AsyncWaiter<GetLinkResponse> linkActiveWaiter;
    private final AsyncWaiter<GetOutboundExternalLinkResponse> outboundExternalLinkActiveWaiter;
    private final AsyncWaiter<GetRequesterGatewayResponse> requesterGatewayActiveWaiter;
    private final AsyncWaiter<GetRequesterGatewayResponse> requesterGatewayDeletedWaiter;
    private final AsyncWaiter<GetResponderGatewayResponse> responderGatewayActiveWaiter;
    private final AsyncWaiter<GetResponderGatewayResponse> responderGatewayDeletedWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultRtbFabricAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (RtbFabricAsyncClient)RtbFabricAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.inboundExternalLinkActiveWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetInboundExternalLinkResponse.class).acceptors(DefaultRtbFabricAsyncWaiter.inboundExternalLinkActiveWaiterAcceptors())).overrideConfiguration(DefaultRtbFabricAsyncWaiter.inboundExternalLinkActiveWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.linkAcceptedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetLinkResponse.class).acceptors(DefaultRtbFabricAsyncWaiter.linkAcceptedWaiterAcceptors())).overrideConfiguration(DefaultRtbFabricAsyncWaiter.linkAcceptedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.linkActiveWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetLinkResponse.class).acceptors(DefaultRtbFabricAsyncWaiter.linkActiveWaiterAcceptors())).overrideConfiguration(DefaultRtbFabricAsyncWaiter.linkActiveWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.outboundExternalLinkActiveWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetOutboundExternalLinkResponse.class).acceptors(DefaultRtbFabricAsyncWaiter.outboundExternalLinkActiveWaiterAcceptors())).overrideConfiguration(DefaultRtbFabricAsyncWaiter.outboundExternalLinkActiveWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.requesterGatewayActiveWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetRequesterGatewayResponse.class).acceptors(DefaultRtbFabricAsyncWaiter.requesterGatewayActiveWaiterAcceptors())).overrideConfiguration(DefaultRtbFabricAsyncWaiter.requesterGatewayActiveWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.requesterGatewayDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetRequesterGatewayResponse.class).acceptors(DefaultRtbFabricAsyncWaiter.requesterGatewayDeletedWaiterAcceptors())).overrideConfiguration(DefaultRtbFabricAsyncWaiter.requesterGatewayDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.responderGatewayActiveWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetResponderGatewayResponse.class).acceptors(DefaultRtbFabricAsyncWaiter.responderGatewayActiveWaiterAcceptors())).overrideConfiguration(DefaultRtbFabricAsyncWaiter.responderGatewayActiveWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.responderGatewayDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetResponderGatewayResponse.class).acceptors(DefaultRtbFabricAsyncWaiter.responderGatewayDeletedWaiterAcceptors())).overrideConfiguration(DefaultRtbFabricAsyncWaiter.responderGatewayDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<GetInboundExternalLinkResponse>> waitUntilInboundExternalLinkActive(GetInboundExternalLinkRequest getInboundExternalLinkRequest) {
        return this.inboundExternalLinkActiveWaiter.runAsync(() -> this.client.getInboundExternalLink(this.applyWaitersUserAgent(getInboundExternalLinkRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetInboundExternalLinkResponse>> waitUntilInboundExternalLinkActive(GetInboundExternalLinkRequest getInboundExternalLinkRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.inboundExternalLinkActiveWaiter.runAsync(() -> this.client.getInboundExternalLink(this.applyWaitersUserAgent(getInboundExternalLinkRequest)), DefaultRtbFabricAsyncWaiter.inboundExternalLinkActiveWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetLinkResponse>> waitUntilLinkAccepted(GetLinkRequest getLinkRequest) {
        return this.linkAcceptedWaiter.runAsync(() -> this.client.getLink(this.applyWaitersUserAgent(getLinkRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetLinkResponse>> waitUntilLinkAccepted(GetLinkRequest getLinkRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.linkAcceptedWaiter.runAsync(() -> this.client.getLink(this.applyWaitersUserAgent(getLinkRequest)), DefaultRtbFabricAsyncWaiter.linkAcceptedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetLinkResponse>> waitUntilLinkActive(GetLinkRequest getLinkRequest) {
        return this.linkActiveWaiter.runAsync(() -> this.client.getLink(this.applyWaitersUserAgent(getLinkRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetLinkResponse>> waitUntilLinkActive(GetLinkRequest getLinkRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.linkActiveWaiter.runAsync(() -> this.client.getLink(this.applyWaitersUserAgent(getLinkRequest)), DefaultRtbFabricAsyncWaiter.linkActiveWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetOutboundExternalLinkResponse>> waitUntilOutboundExternalLinkActive(GetOutboundExternalLinkRequest getOutboundExternalLinkRequest) {
        return this.outboundExternalLinkActiveWaiter.runAsync(() -> this.client.getOutboundExternalLink(this.applyWaitersUserAgent(getOutboundExternalLinkRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetOutboundExternalLinkResponse>> waitUntilOutboundExternalLinkActive(GetOutboundExternalLinkRequest getOutboundExternalLinkRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.outboundExternalLinkActiveWaiter.runAsync(() -> this.client.getOutboundExternalLink(this.applyWaitersUserAgent(getOutboundExternalLinkRequest)), DefaultRtbFabricAsyncWaiter.outboundExternalLinkActiveWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRequesterGatewayResponse>> waitUntilRequesterGatewayActive(GetRequesterGatewayRequest getRequesterGatewayRequest) {
        return this.requesterGatewayActiveWaiter.runAsync(() -> this.client.getRequesterGateway(this.applyWaitersUserAgent(getRequesterGatewayRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRequesterGatewayResponse>> waitUntilRequesterGatewayActive(GetRequesterGatewayRequest getRequesterGatewayRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.requesterGatewayActiveWaiter.runAsync(() -> this.client.getRequesterGateway(this.applyWaitersUserAgent(getRequesterGatewayRequest)), DefaultRtbFabricAsyncWaiter.requesterGatewayActiveWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRequesterGatewayResponse>> waitUntilRequesterGatewayDeleted(GetRequesterGatewayRequest getRequesterGatewayRequest) {
        return this.requesterGatewayDeletedWaiter.runAsync(() -> this.client.getRequesterGateway(this.applyWaitersUserAgent(getRequesterGatewayRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRequesterGatewayResponse>> waitUntilRequesterGatewayDeleted(GetRequesterGatewayRequest getRequesterGatewayRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.requesterGatewayDeletedWaiter.runAsync(() -> this.client.getRequesterGateway(this.applyWaitersUserAgent(getRequesterGatewayRequest)), DefaultRtbFabricAsyncWaiter.requesterGatewayDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetResponderGatewayResponse>> waitUntilResponderGatewayActive(GetResponderGatewayRequest getResponderGatewayRequest) {
        return this.responderGatewayActiveWaiter.runAsync(() -> this.client.getResponderGateway(this.applyWaitersUserAgent(getResponderGatewayRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetResponderGatewayResponse>> waitUntilResponderGatewayActive(GetResponderGatewayRequest getResponderGatewayRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.responderGatewayActiveWaiter.runAsync(() -> this.client.getResponderGateway(this.applyWaitersUserAgent(getResponderGatewayRequest)), DefaultRtbFabricAsyncWaiter.responderGatewayActiveWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetResponderGatewayResponse>> waitUntilResponderGatewayDeleted(GetResponderGatewayRequest getResponderGatewayRequest) {
        return this.responderGatewayDeletedWaiter.runAsync(() -> this.client.getResponderGateway(this.applyWaitersUserAgent(getResponderGatewayRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetResponderGatewayResponse>> waitUntilResponderGatewayDeleted(GetResponderGatewayRequest getResponderGatewayRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.responderGatewayDeletedWaiter.runAsync(() -> this.client.getResponderGateway(this.applyWaitersUserAgent(getResponderGatewayRequest)), DefaultRtbFabricAsyncWaiter.responderGatewayDeletedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetInboundExternalLinkResponse>> inboundExternalLinkActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetInboundExternalLinkResponse>> result = new ArrayList<WaiterAcceptor<? super GetInboundExternalLinkResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "REJECTED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=REJECTED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=DELETED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ISOLATED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=ISOLATED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetLinkResponse>> linkAcceptedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetLinkResponse>> result = new ArrayList<WaiterAcceptor<? super GetLinkResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACCEPTED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "REJECTED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=REJECTED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=DELETED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetLinkResponse>> linkActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetLinkResponse>> result = new ArrayList<WaiterAcceptor<? super GetLinkResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "REJECTED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=REJECTED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=DELETED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetOutboundExternalLinkResponse>> outboundExternalLinkActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetOutboundExternalLinkResponse>> result = new ArrayList<WaiterAcceptor<? super GetOutboundExternalLinkResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "REJECTED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=REJECTED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=DELETED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ISOLATED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=ISOLATED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRequesterGatewayResponse>> requesterGatewayActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetRequesterGatewayResponse>> result = new ArrayList<WaiterAcceptor<? super GetRequesterGatewayResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=DELETED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRequesterGatewayResponse>> requesterGatewayDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetRequesterGatewayResponse>> result = new ArrayList<WaiterAcceptor<? super GetRequesterGatewayResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetResponderGatewayResponse>> responderGatewayActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetResponderGatewayResponse>> result = new ArrayList<WaiterAcceptor<? super GetResponderGatewayResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=DELETED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetResponderGatewayResponse>> responderGatewayDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetResponderGatewayResponse>> result = new ArrayList<WaiterAcceptor<? super GetResponderGatewayResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration inboundExternalLinkActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration linkAcceptedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration linkActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration outboundExternalLinkActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration requesterGatewayActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration requesterGatewayDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration responderGatewayActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration responderGatewayDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static RtbFabricAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends RtbFabricRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((RtbFabricRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements RtbFabricAsyncWaiter.Builder {
        private RtbFabricAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public RtbFabricAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public RtbFabricAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public RtbFabricAsyncWaiter.Builder client(RtbFabricAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public RtbFabricAsyncWaiter build() {
            return new DefaultRtbFabricAsyncWaiter(this);
        }
    }
}

