/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rtbfabric.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.rtbfabric.model.RtbFabricRequest;
import software.amazon.awssdk.services.rtbfabric.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateOutboundExternalLinkRequest
extends RtbFabricRequest
implements ToCopyableBuilder<Builder, CreateOutboundExternalLinkRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateOutboundExternalLinkRequest.getter(CreateOutboundExternalLinkRequest::clientToken)).setter(CreateOutboundExternalLinkRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("gatewayId").getter(CreateOutboundExternalLinkRequest.getter(CreateOutboundExternalLinkRequest::gatewayId)).setter(CreateOutboundExternalLinkRequest.setter(Builder::gatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("gatewayId").build()}).build();
    private static final SdkField<String> PUBLIC_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("publicEndpoint").getter(CreateOutboundExternalLinkRequest.getter(CreateOutboundExternalLinkRequest::publicEndpoint)).setter(CreateOutboundExternalLinkRequest.setter(Builder::publicEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicEndpoint").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateOutboundExternalLinkRequest.getter(CreateOutboundExternalLinkRequest::tags)).setter(CreateOutboundExternalLinkRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, GATEWAY_ID_FIELD, PUBLIC_ENDPOINT_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateOutboundExternalLinkRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String gatewayId;
    private final String publicEndpoint;
    private final Map<String, String> tags;

    private CreateOutboundExternalLinkRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.gatewayId = builder.gatewayId;
        this.publicEndpoint = builder.publicEndpoint;
        this.tags = builder.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String gatewayId() {
        return this.gatewayId;
    }

    public final String publicEndpoint() {
        return this.publicEndpoint;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOutboundExternalLinkRequest)) {
            return false;
        }
        CreateOutboundExternalLinkRequest other = (CreateOutboundExternalLinkRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.gatewayId(), other.gatewayId()) && Objects.equals(this.publicEndpoint(), other.publicEndpoint()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateOutboundExternalLinkRequest").add("ClientToken", (Object)this.clientToken()).add("GatewayId", (Object)this.gatewayId()).add("PublicEndpoint", (Object)this.publicEndpoint()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "gatewayId": {
                return Optional.ofNullable(clazz.cast(this.gatewayId()));
            }
            case "publicEndpoint": {
                return Optional.ofNullable(clazz.cast(this.publicEndpoint()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("gatewayId", GATEWAY_ID_FIELD);
        map.put("publicEndpoint", PUBLIC_ENDPOINT_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateOutboundExternalLinkRequest, T> g) {
        return obj -> g.apply((CreateOutboundExternalLinkRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RtbFabricRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String gatewayId;
        private String publicEndpoint;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOutboundExternalLinkRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.gatewayId(model.gatewayId);
            this.publicEndpoint(model.publicEndpoint);
            this.tags(model.tags);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getGatewayId() {
            return this.gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getPublicEndpoint() {
            return this.publicEndpoint;
        }

        public final void setPublicEndpoint(String publicEndpoint) {
            this.publicEndpoint = publicEndpoint;
        }

        @Override
        public final Builder publicEndpoint(String publicEndpoint) {
            this.publicEndpoint = publicEndpoint;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOutboundExternalLinkRequest build() {
            return new CreateOutboundExternalLinkRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RtbFabricRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateOutboundExternalLinkRequest> {
        public Builder clientToken(String var1);

        public Builder gatewayId(String var1);

        public Builder publicEndpoint(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

