/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.route53resolver.model.ResolverRuleStatus;
import software.amazon.awssdk.services.route53resolver.model.RuleTypeOption;
import software.amazon.awssdk.services.route53resolver.model.ShareStatus;
import software.amazon.awssdk.services.route53resolver.model.TargetAddress;
import software.amazon.awssdk.services.route53resolver.model.TargetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResolverRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResolverRule> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResolverRule.getter(ResolverRule::id)).setter(ResolverRule.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResolverRule.getter(ResolverRule::creatorRequestId)).setter(ResolverRule.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResolverRule.getter(ResolverRule::arn)).setter(ResolverRule.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResolverRule.getter(ResolverRule::domainName)).setter(ResolverRule.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResolverRule.getter(ResolverRule::statusAsString)).setter(ResolverRule.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResolverRule.getter(ResolverRule::statusMessage)).setter(ResolverRule.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> RULE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResolverRule.getter(ResolverRule::ruleTypeAsString)).setter(ResolverRule.setter(Builder::ruleType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleType").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResolverRule.getter(ResolverRule::name)).setter(ResolverRule.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<TargetAddress>> TARGET_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ResolverRule.getter(ResolverRule::targetIps)).setter(ResolverRule.setter(Builder::targetIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetIps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOLVER_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResolverRule.getter(ResolverRule::resolverEndpointId)).setter(ResolverRule.setter(Builder::resolverEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverEndpointId").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResolverRule.getter(ResolverRule::ownerId)).setter(ResolverRule.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()}).build();
    private static final SdkField<String> SHARE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResolverRule.getter(ResolverRule::shareStatusAsString)).setter(ResolverRule.setter(Builder::shareStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, CREATOR_REQUEST_ID_FIELD, ARN_FIELD, DOMAIN_NAME_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, RULE_TYPE_FIELD, NAME_FIELD, TARGET_IPS_FIELD, RESOLVER_ENDPOINT_ID_FIELD, OWNER_ID_FIELD, SHARE_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String creatorRequestId;
    private final String arn;
    private final String domainName;
    private final String status;
    private final String statusMessage;
    private final String ruleType;
    private final String name;
    private final List<TargetAddress> targetIps;
    private final String resolverEndpointId;
    private final String ownerId;
    private final String shareStatus;

    private ResolverRule(BuilderImpl builder) {
        this.id = builder.id;
        this.creatorRequestId = builder.creatorRequestId;
        this.arn = builder.arn;
        this.domainName = builder.domainName;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.ruleType = builder.ruleType;
        this.name = builder.name;
        this.targetIps = builder.targetIps;
        this.resolverEndpointId = builder.resolverEndpointId;
        this.ownerId = builder.ownerId;
        this.shareStatus = builder.shareStatus;
    }

    public String id() {
        return this.id;
    }

    public String creatorRequestId() {
        return this.creatorRequestId;
    }

    public String arn() {
        return this.arn;
    }

    public String domainName() {
        return this.domainName;
    }

    public ResolverRuleStatus status() {
        return ResolverRuleStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public RuleTypeOption ruleType() {
        return RuleTypeOption.fromValue(this.ruleType);
    }

    public String ruleTypeAsString() {
        return this.ruleType;
    }

    public String name() {
        return this.name;
    }

    public List<TargetAddress> targetIps() {
        return this.targetIps;
    }

    public String resolverEndpointId() {
        return this.resolverEndpointId;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public ShareStatus shareStatus() {
        return ShareStatus.fromValue(this.shareStatus);
    }

    public String shareStatusAsString() {
        return this.shareStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetIps());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolverEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolverRule)) {
            return false;
        }
        ResolverRule other = (ResolverRule)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.ruleTypeAsString(), other.ruleTypeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.targetIps(), other.targetIps()) && Objects.equals(this.resolverEndpointId(), other.resolverEndpointId()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.shareStatusAsString(), other.shareStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"ResolverRule").add("Id", (Object)this.id()).add("CreatorRequestId", (Object)this.creatorRequestId()).add("Arn", (Object)this.arn()).add("DomainName", (Object)this.domainName()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("RuleType", (Object)this.ruleTypeAsString()).add("Name", (Object)this.name()).add("TargetIps", this.targetIps()).add("ResolverEndpointId", (Object)this.resolverEndpointId()).add("OwnerId", (Object)this.ownerId()).add("ShareStatus", (Object)this.shareStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "RuleType": {
                return Optional.ofNullable(clazz.cast(this.ruleTypeAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "TargetIps": {
                return Optional.ofNullable(clazz.cast(this.targetIps()));
            }
            case "ResolverEndpointId": {
                return Optional.ofNullable(clazz.cast(this.resolverEndpointId()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "ShareStatus": {
                return Optional.ofNullable(clazz.cast(this.shareStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResolverRule, T> g) {
        return obj -> g.apply((ResolverRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String creatorRequestId;
        private String arn;
        private String domainName;
        private String status;
        private String statusMessage;
        private String ruleType;
        private String name;
        private List<TargetAddress> targetIps = DefaultSdkAutoConstructList.getInstance();
        private String resolverEndpointId;
        private String ownerId;
        private String shareStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolverRule model) {
            this.id(model.id);
            this.creatorRequestId(model.creatorRequestId);
            this.arn(model.arn);
            this.domainName(model.domainName);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.ruleType(model.ruleType);
            this.name(model.name);
            this.targetIps(model.targetIps);
            this.resolverEndpointId(model.resolverEndpointId);
            this.ownerId(model.ownerId);
            this.shareStatus(model.shareStatus);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResolverRuleStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getRuleTypeAsString() {
            return this.ruleType;
        }

        @Override
        public final Builder ruleType(String ruleType) {
            this.ruleType = ruleType;
            return this;
        }

        @Override
        public final Builder ruleType(RuleTypeOption ruleType) {
            this.ruleType(ruleType.toString());
            return this;
        }

        public final void setRuleType(String ruleType) {
            this.ruleType = ruleType;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<TargetAddress.Builder> getTargetIps() {
            return this.targetIps != null ? (Collection)this.targetIps.stream().map(TargetAddress::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetIps(Collection<TargetAddress> targetIps) {
            this.targetIps = TargetListCopier.copy(targetIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetIps(TargetAddress ... targetIps) {
            this.targetIps(Arrays.asList(targetIps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetIps(Consumer<TargetAddress.Builder> ... targetIps) {
            this.targetIps(Stream.of(targetIps).map(c -> (TargetAddress)((TargetAddress.Builder)TargetAddress.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargetIps(Collection<TargetAddress.BuilderImpl> targetIps) {
            this.targetIps = TargetListCopier.copyFromBuilder(targetIps);
        }

        public final String getResolverEndpointId() {
            return this.resolverEndpointId;
        }

        @Override
        public final Builder resolverEndpointId(String resolverEndpointId) {
            this.resolverEndpointId = resolverEndpointId;
            return this;
        }

        public final void setResolverEndpointId(String resolverEndpointId) {
            this.resolverEndpointId = resolverEndpointId;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getShareStatusAsString() {
            return this.shareStatus;
        }

        @Override
        public final Builder shareStatus(String shareStatus) {
            this.shareStatus = shareStatus;
            return this;
        }

        @Override
        public final Builder shareStatus(ShareStatus shareStatus) {
            this.shareStatus(shareStatus.toString());
            return this;
        }

        public final void setShareStatus(String shareStatus) {
            this.shareStatus = shareStatus;
        }

        public ResolverRule build() {
            return new ResolverRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResolverRule> {
        public Builder id(String var1);

        public Builder creatorRequestId(String var1);

        public Builder arn(String var1);

        public Builder domainName(String var1);

        public Builder status(String var1);

        public Builder status(ResolverRuleStatus var1);

        public Builder statusMessage(String var1);

        public Builder ruleType(String var1);

        public Builder ruleType(RuleTypeOption var1);

        public Builder name(String var1);

        public Builder targetIps(Collection<TargetAddress> var1);

        public Builder targetIps(TargetAddress ... var1);

        public Builder targetIps(Consumer<TargetAddress.Builder> ... var1);

        public Builder resolverEndpointId(String var1);

        public Builder ownerId(String var1);

        public Builder shareStatus(String var1);

        public Builder shareStatus(ShareStatus var1);
    }
}

