/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53resolver.Route53ResolverAsyncClient;
import software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsResponse;
import software.amazon.awssdk.services.route53resolver.model.ResolverQueryLogConfig;

public class ListResolverQueryLogConfigsPublisher
implements SdkPublisher<ListResolverQueryLogConfigsResponse> {
    private final Route53ResolverAsyncClient client;
    private final ListResolverQueryLogConfigsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResolverQueryLogConfigsPublisher(Route53ResolverAsyncClient client, ListResolverQueryLogConfigsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResolverQueryLogConfigsPublisher(Route53ResolverAsyncClient client, ListResolverQueryLogConfigsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResolverQueryLogConfigsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResolverQueryLogConfigsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResolverQueryLogConfig> resolverQueryLogConfigs() {
        Function<ListResolverQueryLogConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resolverQueryLogConfigs() != null) {
                return response.resolverQueryLogConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResolverQueryLogConfigsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResolverQueryLogConfigsResponseFetcher
    implements AsyncPageFetcher<ListResolverQueryLogConfigsResponse> {
        private ListResolverQueryLogConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListResolverQueryLogConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResolverQueryLogConfigsResponse> nextPage(ListResolverQueryLogConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListResolverQueryLogConfigsPublisher.this.client.listResolverQueryLogConfigs(ListResolverQueryLogConfigsPublisher.this.firstRequest);
            }
            return ListResolverQueryLogConfigsPublisher.this.client.listResolverQueryLogConfigs((ListResolverQueryLogConfigsRequest)((Object)ListResolverQueryLogConfigsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

