/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53resolver.model.ResolverRule;
import software.amazon.awssdk.services.route53resolver.model.ResolverRulesCopier;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResolverRulesResponse
extends Route53ResolverResponse
implements ToCopyableBuilder<Builder, ListResolverRulesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResolverRulesResponse.getter(ListResolverRulesResponse::nextToken)).setter(ListResolverRulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListResolverRulesResponse.getter(ListResolverRulesResponse::maxResults)).setter(ListResolverRulesResponse.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<List<ResolverRule>> RESOLVER_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResolverRules").getter(ListResolverRulesResponse.getter(ListResolverRulesResponse::resolverRules)).setter(ListResolverRulesResponse.setter(Builder::resolverRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResolverRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, RESOLVER_RULES_FIELD));
    private final String nextToken;
    private final Integer maxResults;
    private final List<ResolverRule> resolverRules;

    private ListResolverRulesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.resolverRules = builder.resolverRules;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final boolean hasResolverRules() {
        return this.resolverRules != null && !(this.resolverRules instanceof SdkAutoConstructList);
    }

    public final List<ResolverRule> resolverRules() {
        return this.resolverRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResolverRules() ? this.resolverRules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResolverRulesResponse)) {
            return false;
        }
        ListResolverRulesResponse other = (ListResolverRulesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasResolverRules() == other.hasResolverRules() && Objects.equals(this.resolverRules(), other.resolverRules());
    }

    public final String toString() {
        return ToString.builder((String)"ListResolverRulesResponse").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ResolverRules", this.hasResolverRules() ? this.resolverRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "ResolverRules": {
                return Optional.ofNullable(clazz.cast(this.resolverRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResolverRulesResponse, T> g) {
        return obj -> g.apply((ListResolverRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ResolverResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private List<ResolverRule> resolverRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListResolverRulesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.resolverRules(model.resolverRules);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final List<ResolverRule.Builder> getResolverRules() {
            List<ResolverRule.Builder> result = ResolverRulesCopier.copyToBuilder(this.resolverRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder resolverRules(Collection<ResolverRule> resolverRules) {
            this.resolverRules = ResolverRulesCopier.copy(resolverRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolverRules(ResolverRule ... resolverRules) {
            this.resolverRules(Arrays.asList(resolverRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolverRules(Consumer<ResolverRule.Builder> ... resolverRules) {
            this.resolverRules(Stream.of(resolverRules).map(c -> (ResolverRule)((ResolverRule.Builder)ResolverRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResolverRules(Collection<ResolverRule.BuilderImpl> resolverRules) {
            this.resolverRules = ResolverRulesCopier.copyFromBuilder(resolverRules);
        }

        @Override
        public ListResolverRulesResponse build() {
            return new ListResolverRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53ResolverResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResolverRulesResponse> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder resolverRules(Collection<ResolverRule> var1);

        public Builder resolverRules(ResolverRule ... var1);

        public Builder resolverRules(Consumer<ResolverRule.Builder> ... var1);
    }
}

