/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.robomaker.RoboMakerAsyncClient;
import software.amazon.awssdk.services.robomaker.model.ListRobotsRequest;
import software.amazon.awssdk.services.robomaker.model.ListRobotsResponse;

public class ListRobotsPublisher
implements SdkPublisher<ListRobotsResponse> {
    private final RoboMakerAsyncClient client;
    private final ListRobotsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRobotsPublisher(RoboMakerAsyncClient client, ListRobotsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRobotsPublisher(RoboMakerAsyncClient client, ListRobotsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRobotsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRobotsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListRobotsResponseFetcher
    implements AsyncPageFetcher<ListRobotsResponse> {
        private ListRobotsResponseFetcher() {
        }

        public boolean hasNextPage(ListRobotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRobotsResponse> nextPage(ListRobotsResponse previousPage) {
            if (previousPage == null) {
                return ListRobotsPublisher.this.client.listRobots(ListRobotsPublisher.this.firstRequest);
            }
            return ListRobotsPublisher.this.client.listRobots((ListRobotsRequest)((Object)ListRobotsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

