/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentConfig> {
    private static final SdkField<Integer> CONCURRENT_DEPLOYMENT_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DeploymentConfig.getter(DeploymentConfig::concurrentDeploymentPercentage)).setter(DeploymentConfig.setter(Builder::concurrentDeploymentPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("concurrentDeploymentPercentage").build()}).build();
    private static final SdkField<Integer> FAILURE_THRESHOLD_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DeploymentConfig.getter(DeploymentConfig::failureThresholdPercentage)).setter(DeploymentConfig.setter(Builder::failureThresholdPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureThresholdPercentage").build()}).build();
    private static final SdkField<Long> ROBOT_DEPLOYMENT_TIMEOUT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(DeploymentConfig.getter(DeploymentConfig::robotDeploymentTimeoutInSeconds)).setter(DeploymentConfig.setter(Builder::robotDeploymentTimeoutInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robotDeploymentTimeoutInSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONCURRENT_DEPLOYMENT_PERCENTAGE_FIELD, FAILURE_THRESHOLD_PERCENTAGE_FIELD, ROBOT_DEPLOYMENT_TIMEOUT_IN_SECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer concurrentDeploymentPercentage;
    private final Integer failureThresholdPercentage;
    private final Long robotDeploymentTimeoutInSeconds;

    private DeploymentConfig(BuilderImpl builder) {
        this.concurrentDeploymentPercentage = builder.concurrentDeploymentPercentage;
        this.failureThresholdPercentage = builder.failureThresholdPercentage;
        this.robotDeploymentTimeoutInSeconds = builder.robotDeploymentTimeoutInSeconds;
    }

    public Integer concurrentDeploymentPercentage() {
        return this.concurrentDeploymentPercentage;
    }

    public Integer failureThresholdPercentage() {
        return this.failureThresholdPercentage;
    }

    public Long robotDeploymentTimeoutInSeconds() {
        return this.robotDeploymentTimeoutInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.concurrentDeploymentPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureThresholdPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.robotDeploymentTimeoutInSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentConfig)) {
            return false;
        }
        DeploymentConfig other = (DeploymentConfig)obj;
        return Objects.equals(this.concurrentDeploymentPercentage(), other.concurrentDeploymentPercentage()) && Objects.equals(this.failureThresholdPercentage(), other.failureThresholdPercentage()) && Objects.equals(this.robotDeploymentTimeoutInSeconds(), other.robotDeploymentTimeoutInSeconds());
    }

    public String toString() {
        return ToString.builder((String)"DeploymentConfig").add("ConcurrentDeploymentPercentage", (Object)this.concurrentDeploymentPercentage()).add("FailureThresholdPercentage", (Object)this.failureThresholdPercentage()).add("RobotDeploymentTimeoutInSeconds", (Object)this.robotDeploymentTimeoutInSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "concurrentDeploymentPercentage": {
                return Optional.ofNullable(clazz.cast(this.concurrentDeploymentPercentage()));
            }
            case "failureThresholdPercentage": {
                return Optional.ofNullable(clazz.cast(this.failureThresholdPercentage()));
            }
            case "robotDeploymentTimeoutInSeconds": {
                return Optional.ofNullable(clazz.cast(this.robotDeploymentTimeoutInSeconds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentConfig, T> g) {
        return obj -> g.apply((DeploymentConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer concurrentDeploymentPercentage;
        private Integer failureThresholdPercentage;
        private Long robotDeploymentTimeoutInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentConfig model) {
            this.concurrentDeploymentPercentage(model.concurrentDeploymentPercentage);
            this.failureThresholdPercentage(model.failureThresholdPercentage);
            this.robotDeploymentTimeoutInSeconds(model.robotDeploymentTimeoutInSeconds);
        }

        public final Integer getConcurrentDeploymentPercentage() {
            return this.concurrentDeploymentPercentage;
        }

        @Override
        public final Builder concurrentDeploymentPercentage(Integer concurrentDeploymentPercentage) {
            this.concurrentDeploymentPercentage = concurrentDeploymentPercentage;
            return this;
        }

        public final void setConcurrentDeploymentPercentage(Integer concurrentDeploymentPercentage) {
            this.concurrentDeploymentPercentage = concurrentDeploymentPercentage;
        }

        public final Integer getFailureThresholdPercentage() {
            return this.failureThresholdPercentage;
        }

        @Override
        public final Builder failureThresholdPercentage(Integer failureThresholdPercentage) {
            this.failureThresholdPercentage = failureThresholdPercentage;
            return this;
        }

        public final void setFailureThresholdPercentage(Integer failureThresholdPercentage) {
            this.failureThresholdPercentage = failureThresholdPercentage;
        }

        public final Long getRobotDeploymentTimeoutInSeconds() {
            return this.robotDeploymentTimeoutInSeconds;
        }

        @Override
        public final Builder robotDeploymentTimeoutInSeconds(Long robotDeploymentTimeoutInSeconds) {
            this.robotDeploymentTimeoutInSeconds = robotDeploymentTimeoutInSeconds;
            return this;
        }

        public final void setRobotDeploymentTimeoutInSeconds(Long robotDeploymentTimeoutInSeconds) {
            this.robotDeploymentTimeoutInSeconds = robotDeploymentTimeoutInSeconds;
        }

        public DeploymentConfig build() {
            return new DeploymentConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentConfig> {
        public Builder concurrentDeploymentPercentage(Integer var1);

        public Builder failureThresholdPercentage(Integer var1);

        public Builder robotDeploymentTimeoutInSeconds(Long var1);
    }
}

