/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode;
import software.amazon.awssdk.services.robomaker.model.ProgressDetail;
import software.amazon.awssdk.services.robomaker.model.RobotStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RobotDeployment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RobotDeployment> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RobotDeployment.getter(RobotDeployment::arn)).setter(RobotDeployment.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> DEPLOYMENT_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(RobotDeployment.getter(RobotDeployment::deploymentStartTime)).setter(RobotDeployment.setter(Builder::deploymentStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStartTime").build()}).build();
    private static final SdkField<Instant> DEPLOYMENT_FINISH_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(RobotDeployment.getter(RobotDeployment::deploymentFinishTime)).setter(RobotDeployment.setter(Builder::deploymentFinishTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentFinishTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RobotDeployment.getter(RobotDeployment::statusAsString)).setter(RobotDeployment.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<ProgressDetail> PROGRESS_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RobotDeployment.getter(RobotDeployment::progressDetail)).setter(RobotDeployment.setter(Builder::progressDetail)).constructor(ProgressDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressDetail").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RobotDeployment.getter(RobotDeployment::failureReason)).setter(RobotDeployment.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RobotDeployment.getter(RobotDeployment::failureCodeAsString)).setter(RobotDeployment.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DEPLOYMENT_START_TIME_FIELD, DEPLOYMENT_FINISH_TIME_FIELD, STATUS_FIELD, PROGRESS_DETAIL_FIELD, FAILURE_REASON_FIELD, FAILURE_CODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Instant deploymentStartTime;
    private final Instant deploymentFinishTime;
    private final String status;
    private final ProgressDetail progressDetail;
    private final String failureReason;
    private final String failureCode;

    private RobotDeployment(BuilderImpl builder) {
        this.arn = builder.arn;
        this.deploymentStartTime = builder.deploymentStartTime;
        this.deploymentFinishTime = builder.deploymentFinishTime;
        this.status = builder.status;
        this.progressDetail = builder.progressDetail;
        this.failureReason = builder.failureReason;
        this.failureCode = builder.failureCode;
    }

    public String arn() {
        return this.arn;
    }

    public Instant deploymentStartTime() {
        return this.deploymentStartTime;
    }

    public Instant deploymentFinishTime() {
        return this.deploymentFinishTime;
    }

    public RobotStatus status() {
        return RobotStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public ProgressDetail progressDetail() {
        return this.progressDetail;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public DeploymentJobErrorCode failureCode() {
        return DeploymentJobErrorCode.fromValue(this.failureCode);
    }

    public String failureCodeAsString() {
        return this.failureCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentFinishTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCodeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RobotDeployment)) {
            return false;
        }
        RobotDeployment other = (RobotDeployment)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.deploymentStartTime(), other.deploymentStartTime()) && Objects.equals(this.deploymentFinishTime(), other.deploymentFinishTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.progressDetail(), other.progressDetail()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.failureCodeAsString(), other.failureCodeAsString());
    }

    public String toString() {
        return ToString.builder((String)"RobotDeployment").add("Arn", (Object)this.arn()).add("DeploymentStartTime", (Object)this.deploymentStartTime()).add("DeploymentFinishTime", (Object)this.deploymentFinishTime()).add("Status", (Object)this.statusAsString()).add("ProgressDetail", (Object)this.progressDetail()).add("FailureReason", (Object)this.failureReason()).add("FailureCode", (Object)this.failureCodeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "deploymentStartTime": {
                return Optional.ofNullable(clazz.cast(this.deploymentStartTime()));
            }
            case "deploymentFinishTime": {
                return Optional.ofNullable(clazz.cast(this.deploymentFinishTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "progressDetail": {
                return Optional.ofNullable(clazz.cast(this.progressDetail()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "failureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCodeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RobotDeployment, T> g) {
        return obj -> g.apply((RobotDeployment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant deploymentStartTime;
        private Instant deploymentFinishTime;
        private String status;
        private ProgressDetail progressDetail;
        private String failureReason;
        private String failureCode;

        private BuilderImpl() {
        }

        private BuilderImpl(RobotDeployment model) {
            this.arn(model.arn);
            this.deploymentStartTime(model.deploymentStartTime);
            this.deploymentFinishTime(model.deploymentFinishTime);
            this.status(model.status);
            this.progressDetail(model.progressDetail);
            this.failureReason(model.failureReason);
            this.failureCode(model.failureCode);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getDeploymentStartTime() {
            return this.deploymentStartTime;
        }

        @Override
        public final Builder deploymentStartTime(Instant deploymentStartTime) {
            this.deploymentStartTime = deploymentStartTime;
            return this;
        }

        public final void setDeploymentStartTime(Instant deploymentStartTime) {
            this.deploymentStartTime = deploymentStartTime;
        }

        public final Instant getDeploymentFinishTime() {
            return this.deploymentFinishTime;
        }

        @Override
        public final Builder deploymentFinishTime(Instant deploymentFinishTime) {
            this.deploymentFinishTime = deploymentFinishTime;
            return this;
        }

        public final void setDeploymentFinishTime(Instant deploymentFinishTime) {
            this.deploymentFinishTime = deploymentFinishTime;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RobotStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final ProgressDetail.Builder getProgressDetail() {
            return this.progressDetail != null ? this.progressDetail.toBuilder() : null;
        }

        @Override
        public final Builder progressDetail(ProgressDetail progressDetail) {
            this.progressDetail = progressDetail;
            return this;
        }

        public final void setProgressDetail(ProgressDetail.BuilderImpl progressDetail) {
            this.progressDetail = progressDetail != null ? progressDetail.build() : null;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getFailureCodeAsString() {
            return this.failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(DeploymentJobErrorCode failureCode) {
            this.failureCode(failureCode.toString());
            return this;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        public RobotDeployment build() {
            return new RobotDeployment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RobotDeployment> {
        public Builder arn(String var1);

        public Builder deploymentStartTime(Instant var1);

        public Builder deploymentFinishTime(Instant var1);

        public Builder status(String var1);

        public Builder status(RobotStatus var1);

        public Builder progressDetail(ProgressDetail var1);

        default public Builder progressDetail(Consumer<ProgressDetail.Builder> progressDetail) {
            return this.progressDetail((ProgressDetail)((ProgressDetail.Builder)ProgressDetail.builder().applyMutation(progressDetail)).build());
        }

        public Builder failureReason(String var1);

        public Builder failureCode(String var1);

        public Builder failureCode(DeploymentJobErrorCode var1);
    }
}

