/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.robomaker.RoboMakerAsyncClient;
import software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest;
import software.amazon.awssdk.services.robomaker.model.ListSimulationJobsResponse;

public class ListSimulationJobsPublisher
implements SdkPublisher<ListSimulationJobsResponse> {
    private final RoboMakerAsyncClient client;
    private final ListSimulationJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSimulationJobsPublisher(RoboMakerAsyncClient client, ListSimulationJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSimulationJobsPublisher(RoboMakerAsyncClient client, ListSimulationJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSimulationJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSimulationJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSimulationJobsResponseFetcher
    implements AsyncPageFetcher<ListSimulationJobsResponse> {
        private ListSimulationJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListSimulationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSimulationJobsResponse> nextPage(ListSimulationJobsResponse previousPage) {
            if (previousPage == null) {
                return ListSimulationJobsPublisher.this.client.listSimulationJobs(ListSimulationJobsPublisher.this.firstRequest);
            }
            return ListSimulationJobsPublisher.this.client.listSimulationJobs((ListSimulationJobsRequest)((Object)ListSimulationJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

