/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.robomaker.model.RoboMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteRobotApplicationRequest
extends RoboMakerRequest
implements ToCopyableBuilder<Builder, DeleteRobotApplicationRequest> {
    private static final SdkField<String> APPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteRobotApplicationRequest.getter(DeleteRobotApplicationRequest::application)).setter(DeleteRobotApplicationRequest.setter(Builder::application)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("application").build()}).build();
    private static final SdkField<String> APPLICATION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteRobotApplicationRequest.getter(DeleteRobotApplicationRequest::applicationVersion)).setter(DeleteRobotApplicationRequest.setter(Builder::applicationVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_FIELD, APPLICATION_VERSION_FIELD));
    private final String application;
    private final String applicationVersion;

    private DeleteRobotApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.application = builder.application;
        this.applicationVersion = builder.applicationVersion;
    }

    public String application() {
        return this.application;
    }

    public String applicationVersion() {
        return this.applicationVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.application());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRobotApplicationRequest)) {
            return false;
        }
        DeleteRobotApplicationRequest other = (DeleteRobotApplicationRequest)((Object)obj);
        return Objects.equals(this.application(), other.application()) && Objects.equals(this.applicationVersion(), other.applicationVersion());
    }

    public String toString() {
        return ToString.builder((String)"DeleteRobotApplicationRequest").add("Application", (Object)this.application()).add("ApplicationVersion", (Object)this.applicationVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "application": {
                return Optional.ofNullable(clazz.cast(this.application()));
            }
            case "applicationVersion": {
                return Optional.ofNullable(clazz.cast(this.applicationVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRobotApplicationRequest, T> g) {
        return obj -> g.apply((DeleteRobotApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerRequest.BuilderImpl
    implements Builder {
        private String application;
        private String applicationVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRobotApplicationRequest model) {
            super(model);
            this.application(model.application);
            this.applicationVersion(model.applicationVersion);
        }

        public final String getApplication() {
            return this.application;
        }

        @Override
        public final Builder application(String application) {
            this.application = application;
            return this;
        }

        public final void setApplication(String application) {
            this.application = application;
        }

        public final String getApplicationVersion() {
            return this.applicationVersion;
        }

        @Override
        public final Builder applicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
            return this;
        }

        public final void setApplicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRobotApplicationRequest build() {
            return new DeleteRobotApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RoboMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteRobotApplicationRequest> {
        public Builder application(String var1);

        public Builder applicationVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

