/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.robomaker.model.ArnsCopier;
import software.amazon.awssdk.services.robomaker.model.RoboMakerResponse;
import software.amazon.awssdk.services.robomaker.model.SimulationJob;
import software.amazon.awssdk.services.robomaker.model.SimulationJobsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDescribeSimulationJobResponse
extends RoboMakerResponse
implements ToCopyableBuilder<Builder, BatchDescribeSimulationJobResponse> {
    private static final SdkField<List<SimulationJob>> JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchDescribeSimulationJobResponse.getter(BatchDescribeSimulationJobResponse::jobs)).setter(BatchDescribeSimulationJobResponse.setter(Builder::jobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SimulationJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> UNPROCESSED_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchDescribeSimulationJobResponse.getter(BatchDescribeSimulationJobResponse::unprocessedJobs)).setter(BatchDescribeSimulationJobResponse.setter(Builder::unprocessedJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unprocessedJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOBS_FIELD, UNPROCESSED_JOBS_FIELD));
    private final List<SimulationJob> jobs;
    private final List<String> unprocessedJobs;

    private BatchDescribeSimulationJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobs = builder.jobs;
        this.unprocessedJobs = builder.unprocessedJobs;
    }

    public List<SimulationJob> jobs() {
        return this.jobs;
    }

    public List<String> unprocessedJobs() {
        return this.unprocessedJobs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobs());
        hashCode = 31 * hashCode + Objects.hashCode(this.unprocessedJobs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDescribeSimulationJobResponse)) {
            return false;
        }
        BatchDescribeSimulationJobResponse other = (BatchDescribeSimulationJobResponse)((Object)obj);
        return Objects.equals(this.jobs(), other.jobs()) && Objects.equals(this.unprocessedJobs(), other.unprocessedJobs());
    }

    public String toString() {
        return ToString.builder((String)"BatchDescribeSimulationJobResponse").add("Jobs", this.jobs()).add("UnprocessedJobs", this.unprocessedJobs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobs": {
                return Optional.ofNullable(clazz.cast(this.jobs()));
            }
            case "unprocessedJobs": {
                return Optional.ofNullable(clazz.cast(this.unprocessedJobs()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDescribeSimulationJobResponse, T> g) {
        return obj -> g.apply((BatchDescribeSimulationJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerResponse.BuilderImpl
    implements Builder {
        private List<SimulationJob> jobs = DefaultSdkAutoConstructList.getInstance();
        private List<String> unprocessedJobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDescribeSimulationJobResponse model) {
            super(model);
            this.jobs(model.jobs);
            this.unprocessedJobs(model.unprocessedJobs);
        }

        public final Collection<SimulationJob.Builder> getJobs() {
            return this.jobs != null ? (Collection)this.jobs.stream().map(SimulationJob::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobs(Collection<SimulationJob> jobs) {
            this.jobs = SimulationJobsCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(SimulationJob ... jobs) {
            this.jobs(Arrays.asList(jobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Consumer<SimulationJob.Builder> ... jobs) {
            this.jobs(Stream.of(jobs).map(c -> (SimulationJob)((SimulationJob.Builder)SimulationJob.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobs(Collection<SimulationJob.BuilderImpl> jobs) {
            this.jobs = SimulationJobsCopier.copyFromBuilder(jobs);
        }

        public final Collection<String> getUnprocessedJobs() {
            return this.unprocessedJobs;
        }

        @Override
        public final Builder unprocessedJobs(Collection<String> unprocessedJobs) {
            this.unprocessedJobs = ArnsCopier.copy(unprocessedJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedJobs(String ... unprocessedJobs) {
            this.unprocessedJobs(Arrays.asList(unprocessedJobs));
            return this;
        }

        public final void setUnprocessedJobs(Collection<String> unprocessedJobs) {
            this.unprocessedJobs = ArnsCopier.copy(unprocessedJobs);
        }

        @Override
        public BatchDescribeSimulationJobResponse build() {
            return new BatchDescribeSimulationJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RoboMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDescribeSimulationJobResponse> {
        public Builder jobs(Collection<SimulationJob> var1);

        public Builder jobs(SimulationJob ... var1);

        public Builder jobs(Consumer<SimulationJob.Builder> ... var1);

        public Builder unprocessedJobs(Collection<String> var1);

        public Builder unprocessedJobs(String ... var1);
    }
}

