/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.robomaker.model.DeploymentApplicationConfig;
import software.amazon.awssdk.services.robomaker.model.DeploymentApplicationConfigsCopier;
import software.amazon.awssdk.services.robomaker.model.DeploymentConfig;
import software.amazon.awssdk.services.robomaker.model.RoboMakerRequest;
import software.amazon.awssdk.services.robomaker.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDeploymentJobRequest
extends RoboMakerRequest
implements ToCopyableBuilder<Builder, CreateDeploymentJobRequest> {
    private static final SdkField<DeploymentConfig> DEPLOYMENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deploymentConfig").getter(CreateDeploymentJobRequest.getter(CreateDeploymentJobRequest::deploymentConfig)).setter(CreateDeploymentJobRequest.setter(Builder::deploymentConfig)).constructor(DeploymentConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfig").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(CreateDeploymentJobRequest.getter(CreateDeploymentJobRequest::clientRequestToken)).setter(CreateDeploymentJobRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> FLEET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fleet").getter(CreateDeploymentJobRequest.getter(CreateDeploymentJobRequest::fleet)).setter(CreateDeploymentJobRequest.setter(Builder::fleet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleet").build()}).build();
    private static final SdkField<List<DeploymentApplicationConfig>> DEPLOYMENT_APPLICATION_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("deploymentApplicationConfigs").getter(CreateDeploymentJobRequest.getter(CreateDeploymentJobRequest::deploymentApplicationConfigs)).setter(CreateDeploymentJobRequest.setter(Builder::deploymentApplicationConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentApplicationConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeploymentApplicationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateDeploymentJobRequest.getter(CreateDeploymentJobRequest::tags)).setter(CreateDeploymentJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_CONFIG_FIELD, CLIENT_REQUEST_TOKEN_FIELD, FLEET_FIELD, DEPLOYMENT_APPLICATION_CONFIGS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDeploymentJobRequest.memberNameToFieldInitializer();
    private final DeploymentConfig deploymentConfig;
    private final String clientRequestToken;
    private final String fleet;
    private final List<DeploymentApplicationConfig> deploymentApplicationConfigs;
    private final Map<String, String> tags;

    private CreateDeploymentJobRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentConfig = builder.deploymentConfig;
        this.clientRequestToken = builder.clientRequestToken;
        this.fleet = builder.fleet;
        this.deploymentApplicationConfigs = builder.deploymentApplicationConfigs;
        this.tags = builder.tags;
    }

    public final DeploymentConfig deploymentConfig() {
        return this.deploymentConfig;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String fleet() {
        return this.fleet;
    }

    public final boolean hasDeploymentApplicationConfigs() {
        return this.deploymentApplicationConfigs != null && !(this.deploymentApplicationConfigs instanceof SdkAutoConstructList);
    }

    public final List<DeploymentApplicationConfig> deploymentApplicationConfigs() {
        return this.deploymentApplicationConfigs;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleet());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeploymentApplicationConfigs() ? this.deploymentApplicationConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentJobRequest)) {
            return false;
        }
        CreateDeploymentJobRequest other = (CreateDeploymentJobRequest)((Object)obj);
        return Objects.equals(this.deploymentConfig(), other.deploymentConfig()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.fleet(), other.fleet()) && this.hasDeploymentApplicationConfigs() == other.hasDeploymentApplicationConfigs() && Objects.equals(this.deploymentApplicationConfigs(), other.deploymentApplicationConfigs()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDeploymentJobRequest").add("DeploymentConfig", (Object)this.deploymentConfig()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Fleet", (Object)this.fleet()).add("DeploymentApplicationConfigs", this.hasDeploymentApplicationConfigs() ? this.deploymentApplicationConfigs() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentConfig": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfig()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "fleet": {
                return Optional.ofNullable(clazz.cast(this.fleet()));
            }
            case "deploymentApplicationConfigs": {
                return Optional.ofNullable(clazz.cast(this.deploymentApplicationConfigs()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("deploymentConfig", DEPLOYMENT_CONFIG_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("fleet", FLEET_FIELD);
        map.put("deploymentApplicationConfigs", DEPLOYMENT_APPLICATION_CONFIGS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDeploymentJobRequest, T> g) {
        return obj -> g.apply((CreateDeploymentJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerRequest.BuilderImpl
    implements Builder {
        private DeploymentConfig deploymentConfig;
        private String clientRequestToken;
        private String fleet;
        private List<DeploymentApplicationConfig> deploymentApplicationConfigs = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentJobRequest model) {
            super(model);
            this.deploymentConfig(model.deploymentConfig);
            this.clientRequestToken(model.clientRequestToken);
            this.fleet(model.fleet);
            this.deploymentApplicationConfigs(model.deploymentApplicationConfigs);
            this.tags(model.tags);
        }

        public final DeploymentConfig.Builder getDeploymentConfig() {
            return this.deploymentConfig != null ? this.deploymentConfig.toBuilder() : null;
        }

        public final void setDeploymentConfig(DeploymentConfig.BuilderImpl deploymentConfig) {
            this.deploymentConfig = deploymentConfig != null ? deploymentConfig.build() : null;
        }

        @Override
        public final Builder deploymentConfig(DeploymentConfig deploymentConfig) {
            this.deploymentConfig = deploymentConfig;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getFleet() {
            return this.fleet;
        }

        public final void setFleet(String fleet) {
            this.fleet = fleet;
        }

        @Override
        public final Builder fleet(String fleet) {
            this.fleet = fleet;
            return this;
        }

        public final List<DeploymentApplicationConfig.Builder> getDeploymentApplicationConfigs() {
            List<DeploymentApplicationConfig.Builder> result = DeploymentApplicationConfigsCopier.copyToBuilder(this.deploymentApplicationConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeploymentApplicationConfigs(Collection<DeploymentApplicationConfig.BuilderImpl> deploymentApplicationConfigs) {
            this.deploymentApplicationConfigs = DeploymentApplicationConfigsCopier.copyFromBuilder(deploymentApplicationConfigs);
        }

        @Override
        public final Builder deploymentApplicationConfigs(Collection<DeploymentApplicationConfig> deploymentApplicationConfigs) {
            this.deploymentApplicationConfigs = DeploymentApplicationConfigsCopier.copy(deploymentApplicationConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentApplicationConfigs(DeploymentApplicationConfig ... deploymentApplicationConfigs) {
            this.deploymentApplicationConfigs(Arrays.asList(deploymentApplicationConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentApplicationConfigs(Consumer<DeploymentApplicationConfig.Builder> ... deploymentApplicationConfigs) {
            this.deploymentApplicationConfigs(Stream.of(deploymentApplicationConfigs).map(c -> (DeploymentApplicationConfig)((DeploymentApplicationConfig.Builder)DeploymentApplicationConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeploymentJobRequest build() {
            return new CreateDeploymentJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RoboMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDeploymentJobRequest> {
        public Builder deploymentConfig(DeploymentConfig var1);

        default public Builder deploymentConfig(Consumer<DeploymentConfig.Builder> deploymentConfig) {
            return this.deploymentConfig((DeploymentConfig)((DeploymentConfig.Builder)DeploymentConfig.builder().applyMutation(deploymentConfig)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder fleet(String var1);

        public Builder deploymentApplicationConfigs(Collection<DeploymentApplicationConfig> var1);

        public Builder deploymentApplicationConfigs(DeploymentApplicationConfig ... var1);

        public Builder deploymentApplicationConfigs(Consumer<DeploymentApplicationConfig.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

