/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.robomaker.RoboMakerAsyncClient;
import software.amazon.awssdk.services.robomaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsRequest;
import software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsResponse;
import software.amazon.awssdk.services.robomaker.model.WorldGenerationJobSummary;

public class ListWorldGenerationJobsPublisher
implements SdkPublisher<ListWorldGenerationJobsResponse> {
    private final RoboMakerAsyncClient client;
    private final ListWorldGenerationJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorldGenerationJobsPublisher(RoboMakerAsyncClient client, ListWorldGenerationJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorldGenerationJobsPublisher(RoboMakerAsyncClient client, ListWorldGenerationJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorldGenerationJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorldGenerationJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorldGenerationJobSummary> worldGenerationJobSummaries() {
        Function<ListWorldGenerationJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.worldGenerationJobSummaries() != null) {
                return response.worldGenerationJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWorldGenerationJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWorldGenerationJobsResponseFetcher
    implements AsyncPageFetcher<ListWorldGenerationJobsResponse> {
        private ListWorldGenerationJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorldGenerationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorldGenerationJobsResponse> nextPage(ListWorldGenerationJobsResponse previousPage) {
            if (previousPage == null) {
                return ListWorldGenerationJobsPublisher.this.client.listWorldGenerationJobs(ListWorldGenerationJobsPublisher.this.firstRequest);
            }
            return ListWorldGenerationJobsPublisher.this.client.listWorldGenerationJobs((ListWorldGenerationJobsRequest)((Object)ListWorldGenerationJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

