/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.robomaker.model.DeploymentApplicationConfig;
import software.amazon.awssdk.services.robomaker.model.DeploymentApplicationConfigsCopier;
import software.amazon.awssdk.services.robomaker.model.DeploymentConfig;
import software.amazon.awssdk.services.robomaker.model.DeploymentJobErrorCode;
import software.amazon.awssdk.services.robomaker.model.DeploymentStatus;
import software.amazon.awssdk.services.robomaker.model.RoboMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SyncDeploymentJobResponse
extends RoboMakerResponse
implements ToCopyableBuilder<Builder, SyncDeploymentJobResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(SyncDeploymentJobResponse.getter(SyncDeploymentJobResponse::arn)).setter(SyncDeploymentJobResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> FLEET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fleet").getter(SyncDeploymentJobResponse.getter(SyncDeploymentJobResponse::fleet)).setter(SyncDeploymentJobResponse.setter(Builder::fleet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleet").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(SyncDeploymentJobResponse.getter(SyncDeploymentJobResponse::statusAsString)).setter(SyncDeploymentJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<DeploymentConfig> DEPLOYMENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deploymentConfig").getter(SyncDeploymentJobResponse.getter(SyncDeploymentJobResponse::deploymentConfig)).setter(SyncDeploymentJobResponse.setter(Builder::deploymentConfig)).constructor(DeploymentConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfig").build()}).build();
    private static final SdkField<List<DeploymentApplicationConfig>> DEPLOYMENT_APPLICATION_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("deploymentApplicationConfigs").getter(SyncDeploymentJobResponse.getter(SyncDeploymentJobResponse::deploymentApplicationConfigs)).setter(SyncDeploymentJobResponse.setter(Builder::deploymentApplicationConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentApplicationConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeploymentApplicationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(SyncDeploymentJobResponse.getter(SyncDeploymentJobResponse::failureReason)).setter(SyncDeploymentJobResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureCode").getter(SyncDeploymentJobResponse.getter(SyncDeploymentJobResponse::failureCodeAsString)).setter(SyncDeploymentJobResponse.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(SyncDeploymentJobResponse.getter(SyncDeploymentJobResponse::createdAt)).setter(SyncDeploymentJobResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, FLEET_FIELD, STATUS_FIELD, DEPLOYMENT_CONFIG_FIELD, DEPLOYMENT_APPLICATION_CONFIGS_FIELD, FAILURE_REASON_FIELD, FAILURE_CODE_FIELD, CREATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SyncDeploymentJobResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String fleet;
    private final String status;
    private final DeploymentConfig deploymentConfig;
    private final List<DeploymentApplicationConfig> deploymentApplicationConfigs;
    private final String failureReason;
    private final String failureCode;
    private final Instant createdAt;

    private SyncDeploymentJobResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.fleet = builder.fleet;
        this.status = builder.status;
        this.deploymentConfig = builder.deploymentConfig;
        this.deploymentApplicationConfigs = builder.deploymentApplicationConfigs;
        this.failureReason = builder.failureReason;
        this.failureCode = builder.failureCode;
        this.createdAt = builder.createdAt;
    }

    public final String arn() {
        return this.arn;
    }

    public final String fleet() {
        return this.fleet;
    }

    public final DeploymentStatus status() {
        return DeploymentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final DeploymentConfig deploymentConfig() {
        return this.deploymentConfig;
    }

    public final boolean hasDeploymentApplicationConfigs() {
        return this.deploymentApplicationConfigs != null && !(this.deploymentApplicationConfigs instanceof SdkAutoConstructList);
    }

    public final List<DeploymentApplicationConfig> deploymentApplicationConfigs() {
        return this.deploymentApplicationConfigs;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final DeploymentJobErrorCode failureCode() {
        return DeploymentJobErrorCode.fromValue(this.failureCode);
    }

    public final String failureCodeAsString() {
        return this.failureCode;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleet());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeploymentApplicationConfigs() ? this.deploymentApplicationConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SyncDeploymentJobResponse)) {
            return false;
        }
        SyncDeploymentJobResponse other = (SyncDeploymentJobResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.fleet(), other.fleet()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.deploymentConfig(), other.deploymentConfig()) && this.hasDeploymentApplicationConfigs() == other.hasDeploymentApplicationConfigs() && Objects.equals(this.deploymentApplicationConfigs(), other.deploymentApplicationConfigs()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.failureCodeAsString(), other.failureCodeAsString()) && Objects.equals(this.createdAt(), other.createdAt());
    }

    public final String toString() {
        return ToString.builder((String)"SyncDeploymentJobResponse").add("Arn", (Object)this.arn()).add("Fleet", (Object)this.fleet()).add("Status", (Object)this.statusAsString()).add("DeploymentConfig", (Object)this.deploymentConfig()).add("DeploymentApplicationConfigs", this.hasDeploymentApplicationConfigs() ? this.deploymentApplicationConfigs() : null).add("FailureReason", (Object)this.failureReason()).add("FailureCode", (Object)this.failureCodeAsString()).add("CreatedAt", (Object)this.createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "fleet": {
                return Optional.ofNullable(clazz.cast(this.fleet()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "deploymentConfig": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfig()));
            }
            case "deploymentApplicationConfigs": {
                return Optional.ofNullable(clazz.cast(this.deploymentApplicationConfigs()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "failureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCodeAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("fleet", FLEET_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("deploymentConfig", DEPLOYMENT_CONFIG_FIELD);
        map.put("deploymentApplicationConfigs", DEPLOYMENT_APPLICATION_CONFIGS_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        map.put("failureCode", FAILURE_CODE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SyncDeploymentJobResponse, T> g) {
        return obj -> g.apply((SyncDeploymentJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String fleet;
        private String status;
        private DeploymentConfig deploymentConfig;
        private List<DeploymentApplicationConfig> deploymentApplicationConfigs = DefaultSdkAutoConstructList.getInstance();
        private String failureReason;
        private String failureCode;
        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(SyncDeploymentJobResponse model) {
            super(model);
            this.arn(model.arn);
            this.fleet(model.fleet);
            this.status(model.status);
            this.deploymentConfig(model.deploymentConfig);
            this.deploymentApplicationConfigs(model.deploymentApplicationConfigs);
            this.failureReason(model.failureReason);
            this.failureCode(model.failureCode);
            this.createdAt(model.createdAt);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getFleet() {
            return this.fleet;
        }

        public final void setFleet(String fleet) {
            this.fleet = fleet;
        }

        @Override
        public final Builder fleet(String fleet) {
            this.fleet = fleet;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeploymentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final DeploymentConfig.Builder getDeploymentConfig() {
            return this.deploymentConfig != null ? this.deploymentConfig.toBuilder() : null;
        }

        public final void setDeploymentConfig(DeploymentConfig.BuilderImpl deploymentConfig) {
            this.deploymentConfig = deploymentConfig != null ? deploymentConfig.build() : null;
        }

        @Override
        public final Builder deploymentConfig(DeploymentConfig deploymentConfig) {
            this.deploymentConfig = deploymentConfig;
            return this;
        }

        public final List<DeploymentApplicationConfig.Builder> getDeploymentApplicationConfigs() {
            List<DeploymentApplicationConfig.Builder> result = DeploymentApplicationConfigsCopier.copyToBuilder(this.deploymentApplicationConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeploymentApplicationConfigs(Collection<DeploymentApplicationConfig.BuilderImpl> deploymentApplicationConfigs) {
            this.deploymentApplicationConfigs = DeploymentApplicationConfigsCopier.copyFromBuilder(deploymentApplicationConfigs);
        }

        @Override
        public final Builder deploymentApplicationConfigs(Collection<DeploymentApplicationConfig> deploymentApplicationConfigs) {
            this.deploymentApplicationConfigs = DeploymentApplicationConfigsCopier.copy(deploymentApplicationConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentApplicationConfigs(DeploymentApplicationConfig ... deploymentApplicationConfigs) {
            this.deploymentApplicationConfigs(Arrays.asList(deploymentApplicationConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentApplicationConfigs(Consumer<DeploymentApplicationConfig.Builder> ... deploymentApplicationConfigs) {
            this.deploymentApplicationConfigs(Stream.of(deploymentApplicationConfigs).map(c -> (DeploymentApplicationConfig)((DeploymentApplicationConfig.Builder)DeploymentApplicationConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(DeploymentJobErrorCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public SyncDeploymentJobResponse build() {
            return new SyncDeploymentJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RoboMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SyncDeploymentJobResponse> {
        public Builder arn(String var1);

        public Builder fleet(String var1);

        public Builder status(String var1);

        public Builder status(DeploymentStatus var1);

        public Builder deploymentConfig(DeploymentConfig var1);

        default public Builder deploymentConfig(Consumer<DeploymentConfig.Builder> deploymentConfig) {
            return this.deploymentConfig((DeploymentConfig)((DeploymentConfig.Builder)DeploymentConfig.builder().applyMutation(deploymentConfig)).build());
        }

        public Builder deploymentApplicationConfigs(Collection<DeploymentApplicationConfig> var1);

        public Builder deploymentApplicationConfigs(DeploymentApplicationConfig ... var1);

        public Builder deploymentApplicationConfigs(Consumer<DeploymentApplicationConfig.Builder> ... var1);

        public Builder failureReason(String var1);

        public Builder failureCode(String var1);

        public Builder failureCode(DeploymentJobErrorCode var1);

        public Builder createdAt(Instant var1);
    }
}

