/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.robomaker.RoboMakerClient;
import software.amazon.awssdk.services.robomaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesRequest;
import software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesResponse;
import software.amazon.awssdk.services.robomaker.model.TemplateSummary;

public class ListWorldTemplatesIterable
implements SdkIterable<ListWorldTemplatesResponse> {
    private final RoboMakerClient client;
    private final ListWorldTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorldTemplatesIterable(RoboMakerClient client, ListWorldTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWorldTemplatesResponseFetcher();
    }

    public Iterator<ListWorldTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TemplateSummary> templateSummaries() {
        Function<ListWorldTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.templateSummaries() != null) {
                return response.templateSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorldTemplatesResponseFetcher
    implements SyncPageFetcher<ListWorldTemplatesResponse> {
        private ListWorldTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListWorldTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorldTemplatesResponse nextPage(ListWorldTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListWorldTemplatesIterable.this.client.listWorldTemplates(ListWorldTemplatesIterable.this.firstRequest);
            }
            return ListWorldTemplatesIterable.this.client.listWorldTemplates((ListWorldTemplatesRequest)((Object)ListWorldTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

