/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.robomaker.model.S3Object;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentConfig> {
    private static final SdkField<Integer> CONCURRENT_DEPLOYMENT_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("concurrentDeploymentPercentage").getter(DeploymentConfig.getter(DeploymentConfig::concurrentDeploymentPercentage)).setter(DeploymentConfig.setter(Builder::concurrentDeploymentPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("concurrentDeploymentPercentage").build()}).build();
    private static final SdkField<Integer> FAILURE_THRESHOLD_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("failureThresholdPercentage").getter(DeploymentConfig.getter(DeploymentConfig::failureThresholdPercentage)).setter(DeploymentConfig.setter(Builder::failureThresholdPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureThresholdPercentage").build()}).build();
    private static final SdkField<Long> ROBOT_DEPLOYMENT_TIMEOUT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("robotDeploymentTimeoutInSeconds").getter(DeploymentConfig.getter(DeploymentConfig::robotDeploymentTimeoutInSeconds)).setter(DeploymentConfig.setter(Builder::robotDeploymentTimeoutInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robotDeploymentTimeoutInSeconds").build()}).build();
    private static final SdkField<S3Object> DOWNLOAD_CONDITION_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("downloadConditionFile").getter(DeploymentConfig.getter(DeploymentConfig::downloadConditionFile)).setter(DeploymentConfig.setter(Builder::downloadConditionFile)).constructor(S3Object::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("downloadConditionFile").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONCURRENT_DEPLOYMENT_PERCENTAGE_FIELD, FAILURE_THRESHOLD_PERCENTAGE_FIELD, ROBOT_DEPLOYMENT_TIMEOUT_IN_SECONDS_FIELD, DOWNLOAD_CONDITION_FILE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer concurrentDeploymentPercentage;
    private final Integer failureThresholdPercentage;
    private final Long robotDeploymentTimeoutInSeconds;
    private final S3Object downloadConditionFile;

    private DeploymentConfig(BuilderImpl builder) {
        this.concurrentDeploymentPercentage = builder.concurrentDeploymentPercentage;
        this.failureThresholdPercentage = builder.failureThresholdPercentage;
        this.robotDeploymentTimeoutInSeconds = builder.robotDeploymentTimeoutInSeconds;
        this.downloadConditionFile = builder.downloadConditionFile;
    }

    public final Integer concurrentDeploymentPercentage() {
        return this.concurrentDeploymentPercentage;
    }

    public final Integer failureThresholdPercentage() {
        return this.failureThresholdPercentage;
    }

    public final Long robotDeploymentTimeoutInSeconds() {
        return this.robotDeploymentTimeoutInSeconds;
    }

    public final S3Object downloadConditionFile() {
        return this.downloadConditionFile;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.concurrentDeploymentPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureThresholdPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.robotDeploymentTimeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.downloadConditionFile());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentConfig)) {
            return false;
        }
        DeploymentConfig other = (DeploymentConfig)obj;
        return Objects.equals(this.concurrentDeploymentPercentage(), other.concurrentDeploymentPercentage()) && Objects.equals(this.failureThresholdPercentage(), other.failureThresholdPercentage()) && Objects.equals(this.robotDeploymentTimeoutInSeconds(), other.robotDeploymentTimeoutInSeconds()) && Objects.equals(this.downloadConditionFile(), other.downloadConditionFile());
    }

    public final String toString() {
        return ToString.builder((String)"DeploymentConfig").add("ConcurrentDeploymentPercentage", (Object)this.concurrentDeploymentPercentage()).add("FailureThresholdPercentage", (Object)this.failureThresholdPercentage()).add("RobotDeploymentTimeoutInSeconds", (Object)this.robotDeploymentTimeoutInSeconds()).add("DownloadConditionFile", (Object)this.downloadConditionFile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "concurrentDeploymentPercentage": {
                return Optional.ofNullable(clazz.cast(this.concurrentDeploymentPercentage()));
            }
            case "failureThresholdPercentage": {
                return Optional.ofNullable(clazz.cast(this.failureThresholdPercentage()));
            }
            case "robotDeploymentTimeoutInSeconds": {
                return Optional.ofNullable(clazz.cast(this.robotDeploymentTimeoutInSeconds()));
            }
            case "downloadConditionFile": {
                return Optional.ofNullable(clazz.cast(this.downloadConditionFile()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentConfig, T> g) {
        return obj -> g.apply((DeploymentConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer concurrentDeploymentPercentage;
        private Integer failureThresholdPercentage;
        private Long robotDeploymentTimeoutInSeconds;
        private S3Object downloadConditionFile;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentConfig model) {
            this.concurrentDeploymentPercentage(model.concurrentDeploymentPercentage);
            this.failureThresholdPercentage(model.failureThresholdPercentage);
            this.robotDeploymentTimeoutInSeconds(model.robotDeploymentTimeoutInSeconds);
            this.downloadConditionFile(model.downloadConditionFile);
        }

        public final Integer getConcurrentDeploymentPercentage() {
            return this.concurrentDeploymentPercentage;
        }

        public final void setConcurrentDeploymentPercentage(Integer concurrentDeploymentPercentage) {
            this.concurrentDeploymentPercentage = concurrentDeploymentPercentage;
        }

        @Override
        public final Builder concurrentDeploymentPercentage(Integer concurrentDeploymentPercentage) {
            this.concurrentDeploymentPercentage = concurrentDeploymentPercentage;
            return this;
        }

        public final Integer getFailureThresholdPercentage() {
            return this.failureThresholdPercentage;
        }

        public final void setFailureThresholdPercentage(Integer failureThresholdPercentage) {
            this.failureThresholdPercentage = failureThresholdPercentage;
        }

        @Override
        public final Builder failureThresholdPercentage(Integer failureThresholdPercentage) {
            this.failureThresholdPercentage = failureThresholdPercentage;
            return this;
        }

        public final Long getRobotDeploymentTimeoutInSeconds() {
            return this.robotDeploymentTimeoutInSeconds;
        }

        public final void setRobotDeploymentTimeoutInSeconds(Long robotDeploymentTimeoutInSeconds) {
            this.robotDeploymentTimeoutInSeconds = robotDeploymentTimeoutInSeconds;
        }

        @Override
        public final Builder robotDeploymentTimeoutInSeconds(Long robotDeploymentTimeoutInSeconds) {
            this.robotDeploymentTimeoutInSeconds = robotDeploymentTimeoutInSeconds;
            return this;
        }

        public final S3Object.Builder getDownloadConditionFile() {
            return this.downloadConditionFile != null ? this.downloadConditionFile.toBuilder() : null;
        }

        public final void setDownloadConditionFile(S3Object.BuilderImpl downloadConditionFile) {
            this.downloadConditionFile = downloadConditionFile != null ? downloadConditionFile.build() : null;
        }

        @Override
        public final Builder downloadConditionFile(S3Object downloadConditionFile) {
            this.downloadConditionFile = downloadConditionFile;
            return this;
        }

        public DeploymentConfig build() {
            return new DeploymentConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentConfig> {
        public Builder concurrentDeploymentPercentage(Integer var1);

        public Builder failureThresholdPercentage(Integer var1);

        public Builder robotDeploymentTimeoutInSeconds(Long var1);

        public Builder downloadConditionFile(S3Object var1);

        default public Builder downloadConditionFile(Consumer<S3Object.Builder> downloadConditionFile) {
            return this.downloadConditionFile((S3Object)((S3Object.Builder)S3Object.builder().applyMutation(downloadConditionFile)).build());
        }
    }
}

