/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * If your simulation job accesses resources in a VPC, you provide this parameter identifying the list of security group
 * IDs and subnet IDs. These must belong to the same VPC. You must provide at least one security group and two subnet
 * IDs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VPCConfig implements SdkPojo, Serializable, ToCopyableBuilder<VPCConfig.Builder, VPCConfig> {
    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subnets")
            .getter(getter(VPCConfig::subnets))
            .setter(setter(Builder::subnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("securityGroups")
            .getter(getter(VPCConfig::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ASSIGN_PUBLIC_IP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("assignPublicIp").getter(getter(VPCConfig::assignPublicIp)).setter(setter(Builder::assignPublicIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assignPublicIp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNETS_FIELD,
            SECURITY_GROUPS_FIELD, ASSIGN_PUBLIC_IP_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> subnets;

    private final List<String> securityGroups;

    private final Boolean assignPublicIp;

    private VPCConfig(BuilderImpl builder) {
        this.subnets = builder.subnets;
        this.securityGroups = builder.securityGroups;
        this.assignPublicIp = builder.assignPublicIp;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subnets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnets() {
        return subnets != null && !(subnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of one or more subnet IDs in your VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnets} method.
     * </p>
     * 
     * @return A list of one or more subnet IDs in your VPC.
     */
    public final List<String> subnets() {
        return subnets;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of one or more security groups IDs in your VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroups} method.
     * </p>
     * 
     * @return A list of one or more security groups IDs in your VPC.
     */
    public final List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * A boolean indicating whether to assign a public IP address.
     * </p>
     * 
     * @return A boolean indicating whether to assign a public IP address.
     */
    public final Boolean assignPublicIp() {
        return assignPublicIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnets() ? subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(assignPublicIp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VPCConfig)) {
            return false;
        }
        VPCConfig other = (VPCConfig) obj;
        return hasSubnets() == other.hasSubnets() && Objects.equals(subnets(), other.subnets())
                && hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(securityGroups(), other.securityGroups())
                && Objects.equals(assignPublicIp(), other.assignPublicIp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VPCConfig").add("Subnets", hasSubnets() ? subnets() : null)
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null).add("AssignPublicIp", assignPublicIp())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "subnets":
            return Optional.ofNullable(clazz.cast(subnets()));
        case "securityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "assignPublicIp":
            return Optional.ofNullable(clazz.cast(assignPublicIp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VPCConfig, T> g) {
        return obj -> g.apply((VPCConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VPCConfig> {
        /**
         * <p>
         * A list of one or more subnet IDs in your VPC.
         * </p>
         * 
         * @param subnets
         *        A list of one or more subnet IDs in your VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Collection<String> subnets);

        /**
         * <p>
         * A list of one or more subnet IDs in your VPC.
         * </p>
         * 
         * @param subnets
         *        A list of one or more subnet IDs in your VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(String... subnets);

        /**
         * <p>
         * A list of one or more security groups IDs in your VPC.
         * </p>
         * 
         * @param securityGroups
         *        A list of one or more security groups IDs in your VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * A list of one or more security groups IDs in your VPC.
         * </p>
         * 
         * @param securityGroups
         *        A list of one or more security groups IDs in your VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * A boolean indicating whether to assign a public IP address.
         * </p>
         * 
         * @param assignPublicIp
         *        A boolean indicating whether to assign a public IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignPublicIp(Boolean assignPublicIp);
    }

    static final class BuilderImpl implements Builder {
        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private Boolean assignPublicIp;

        private BuilderImpl() {
        }

        private BuilderImpl(VPCConfig model) {
            subnets(model.subnets);
            securityGroups(model.securityGroups);
            assignPublicIp(model.assignPublicIp);
        }

        public final Collection<String> getSubnets() {
            if (subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return subnets;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String... subnets) {
            subnets(Arrays.asList(subnets));
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final Boolean getAssignPublicIp() {
            return assignPublicIp;
        }

        public final void setAssignPublicIp(Boolean assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
        }

        @Override
        public final Builder assignPublicIp(Boolean assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
            return this;
        }

        @Override
        public VPCConfig build() {
            return new VPCConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
