/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorldGenerationJobResponse extends RoboMakerResponse implements
        ToCopyableBuilder<CreateWorldGenerationJobResponse.Builder, CreateWorldGenerationJobResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CreateWorldGenerationJobResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateWorldGenerationJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(CreateWorldGenerationJobResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureCode").getter(getter(CreateWorldGenerationJobResponse::failureCodeAsString))
            .setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken").getter(getter(CreateWorldGenerationJobResponse::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build())
            .build();

    private static final SdkField<String> TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("template").getter(getter(CreateWorldGenerationJobResponse::template)).setter(setter(Builder::template))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("template").build()).build();

    private static final SdkField<WorldCount> WORLD_COUNT_FIELD = SdkField.<WorldCount> builder(MarshallingType.SDK_POJO)
            .memberName("worldCount").getter(getter(CreateWorldGenerationJobResponse::worldCount))
            .setter(setter(Builder::worldCount)).constructor(WorldCount::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("worldCount").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateWorldGenerationJobResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> WORLD_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("worldTags")
            .getter(getter(CreateWorldGenerationJobResponse::worldTags))
            .setter(setter(Builder::worldTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("worldTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, STATUS_FIELD,
            CREATED_AT_FIELD, FAILURE_CODE_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TEMPLATE_FIELD, WORLD_COUNT_FIELD, TAGS_FIELD,
            WORLD_TAGS_FIELD));

    private final String arn;

    private final String status;

    private final Instant createdAt;

    private final String failureCode;

    private final String clientRequestToken;

    private final String template;

    private final WorldCount worldCount;

    private final Map<String, String> tags;

    private final Map<String, String> worldTags;

    private CreateWorldGenerationJobResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.failureCode = builder.failureCode;
        this.clientRequestToken = builder.clientRequestToken;
        this.template = builder.template;
        this.worldCount = builder.worldCount;
        this.tags = builder.tags;
        this.worldTags = builder.worldTags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the world generator job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the world generator job.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The status of the world generator job.
     * </p>
     * <dl>
     * <dt>Pending</dt>
     * <dd>
     * <p>
     * The world generator job request is pending.
     * </p>
     * </dd>
     * <dt>Running</dt>
     * <dd>
     * <p>
     * The world generator job is running.
     * </p>
     * </dd>
     * <dt>Completed</dt>
     * <dd>
     * <p>
     * The world generator job completed.
     * </p>
     * </dd>
     * <dt>Failed</dt>
     * <dd>
     * <p>
     * The world generator job failed. See <code>failureCode</code> for more information.
     * </p>
     * </dd>
     * <dt>PartialFailed</dt>
     * <dd>
     * <p>
     * Some worlds did not generate.
     * </p>
     * </dd>
     * <dt>Canceled</dt>
     * <dd>
     * <p>
     * The world generator job was cancelled.
     * </p>
     * </dd>
     * <dt>Canceling</dt>
     * <dd>
     * <p>
     * The world generator job is being cancelled.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorldGenerationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the world generator job.</p>
     *         <dl>
     *         <dt>Pending</dt>
     *         <dd>
     *         <p>
     *         The world generator job request is pending.
     *         </p>
     *         </dd>
     *         <dt>Running</dt>
     *         <dd>
     *         <p>
     *         The world generator job is running.
     *         </p>
     *         </dd>
     *         <dt>Completed</dt>
     *         <dd>
     *         <p>
     *         The world generator job completed.
     *         </p>
     *         </dd>
     *         <dt>Failed</dt>
     *         <dd>
     *         <p>
     *         The world generator job failed. See <code>failureCode</code> for more information.
     *         </p>
     *         </dd>
     *         <dt>PartialFailed</dt>
     *         <dd>
     *         <p>
     *         Some worlds did not generate.
     *         </p>
     *         </dd>
     *         <dt>Canceled</dt>
     *         <dd>
     *         <p>
     *         The world generator job was cancelled.
     *         </p>
     *         </dd>
     *         <dt>Canceling</dt>
     *         <dd>
     *         <p>
     *         The world generator job is being cancelled.
     *         </p>
     *         </dd>
     * @see WorldGenerationJobStatus
     */
    public final WorldGenerationJobStatus status() {
        return WorldGenerationJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the world generator job.
     * </p>
     * <dl>
     * <dt>Pending</dt>
     * <dd>
     * <p>
     * The world generator job request is pending.
     * </p>
     * </dd>
     * <dt>Running</dt>
     * <dd>
     * <p>
     * The world generator job is running.
     * </p>
     * </dd>
     * <dt>Completed</dt>
     * <dd>
     * <p>
     * The world generator job completed.
     * </p>
     * </dd>
     * <dt>Failed</dt>
     * <dd>
     * <p>
     * The world generator job failed. See <code>failureCode</code> for more information.
     * </p>
     * </dd>
     * <dt>PartialFailed</dt>
     * <dd>
     * <p>
     * Some worlds did not generate.
     * </p>
     * </dd>
     * <dt>Canceled</dt>
     * <dd>
     * <p>
     * The world generator job was cancelled.
     * </p>
     * </dd>
     * <dt>Canceling</dt>
     * <dd>
     * <p>
     * The world generator job is being cancelled.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorldGenerationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the world generator job.</p>
     *         <dl>
     *         <dt>Pending</dt>
     *         <dd>
     *         <p>
     *         The world generator job request is pending.
     *         </p>
     *         </dd>
     *         <dt>Running</dt>
     *         <dd>
     *         <p>
     *         The world generator job is running.
     *         </p>
     *         </dd>
     *         <dt>Completed</dt>
     *         <dd>
     *         <p>
     *         The world generator job completed.
     *         </p>
     *         </dd>
     *         <dt>Failed</dt>
     *         <dd>
     *         <p>
     *         The world generator job failed. See <code>failureCode</code> for more information.
     *         </p>
     *         </dd>
     *         <dt>PartialFailed</dt>
     *         <dd>
     *         <p>
     *         Some worlds did not generate.
     *         </p>
     *         </dd>
     *         <dt>Canceled</dt>
     *         <dd>
     *         <p>
     *         The world generator job was cancelled.
     *         </p>
     *         </dd>
     *         <dt>Canceling</dt>
     *         <dd>
     *         <p>
     *         The world generator job is being cancelled.
     *         </p>
     *         </dd>
     * @see WorldGenerationJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the world generator job was created.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the world generator job was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The failure code of the world generator job if it failed:
     * </p>
     * <dl>
     * <dt>InternalServiceError</dt>
     * <dd>
     * <p>
     * Internal service error.
     * </p>
     * </dd>
     * <dt>LimitExceeded</dt>
     * <dd>
     * <p>
     * The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests exceeds
     * the maximum number allowed.
     * </p>
     * </dd>
     * <dt>ResourceNotFound</dt>
     * <dd>
     * <p>
     * The specified resource could not be found.
     * </p>
     * </dd>
     * <dt>RequestThrottled</dt>
     * <dd>
     * <p>
     * The request was throttled.
     * </p>
     * </dd>
     * <dt>InvalidInput</dt>
     * <dd>
     * <p>
     * An input parameter in the request is not valid.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link WorldGenerationJobErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The failure code of the world generator job if it failed:</p>
     *         <dl>
     *         <dt>InternalServiceError</dt>
     *         <dd>
     *         <p>
     *         Internal service error.
     *         </p>
     *         </dd>
     *         <dt>LimitExceeded</dt>
     *         <dd>
     *         <p>
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     *         </p>
     *         </dd>
     *         <dt>ResourceNotFound</dt>
     *         <dd>
     *         <p>
     *         The specified resource could not be found.
     *         </p>
     *         </dd>
     *         <dt>RequestThrottled</dt>
     *         <dd>
     *         <p>
     *         The request was throttled.
     *         </p>
     *         </dd>
     *         <dt>InvalidInput</dt>
     *         <dd>
     *         <p>
     *         An input parameter in the request is not valid.
     *         </p>
     *         </dd>
     * @see WorldGenerationJobErrorCode
     */
    public final WorldGenerationJobErrorCode failureCode() {
        return WorldGenerationJobErrorCode.fromValue(failureCode);
    }

    /**
     * <p>
     * The failure code of the world generator job if it failed:
     * </p>
     * <dl>
     * <dt>InternalServiceError</dt>
     * <dd>
     * <p>
     * Internal service error.
     * </p>
     * </dd>
     * <dt>LimitExceeded</dt>
     * <dd>
     * <p>
     * The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests exceeds
     * the maximum number allowed.
     * </p>
     * </dd>
     * <dt>ResourceNotFound</dt>
     * <dd>
     * <p>
     * The specified resource could not be found.
     * </p>
     * </dd>
     * <dt>RequestThrottled</dt>
     * <dd>
     * <p>
     * The request was throttled.
     * </p>
     * </dd>
     * <dt>InvalidInput</dt>
     * <dd>
     * <p>
     * An input parameter in the request is not valid.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link WorldGenerationJobErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The failure code of the world generator job if it failed:</p>
     *         <dl>
     *         <dt>InternalServiceError</dt>
     *         <dd>
     *         <p>
     *         Internal service error.
     *         </p>
     *         </dd>
     *         <dt>LimitExceeded</dt>
     *         <dd>
     *         <p>
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     *         </p>
     *         </dd>
     *         <dt>ResourceNotFound</dt>
     *         <dd>
     *         <p>
     *         The specified resource could not be found.
     *         </p>
     *         </dd>
     *         <dt>RequestThrottled</dt>
     *         <dd>
     *         <p>
     *         The request was throttled.
     *         </p>
     *         </dd>
     *         <dt>InvalidInput</dt>
     *         <dd>
     *         <p>
     *         An input parameter in the request is not valid.
     *         </p>
     *         </dd>
     * @see WorldGenerationJobErrorCode
     */
    public final String failureCodeAsString() {
        return failureCode;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (arn) of the world template.
     * </p>
     * 
     * @return The Amazon Resource Name (arn) of the world template.
     */
    public final String template() {
        return template;
    }

    /**
     * <p>
     * Information about the world count.
     * </p>
     * 
     * @return Information about the world count.
     */
    public final WorldCount worldCount() {
        return worldCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that contains tag keys and tag values that are attached to the world generator job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map that contains tag keys and tag values that are attached to the world generator job.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the WorldTags property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWorldTags() {
        return worldTags != null && !(worldTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that contains tag keys and tag values that are attached to the generated worlds.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorldTags} method.
     * </p>
     * 
     * @return A map that contains tag keys and tag values that are attached to the generated worlds.
     */
    public final Map<String, String> worldTags() {
        return worldTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(failureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(template());
        hashCode = 31 * hashCode + Objects.hashCode(worldCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasWorldTags() ? worldTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorldGenerationJobResponse)) {
            return false;
        }
        CreateWorldGenerationJobResponse other = (CreateWorldGenerationJobResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(failureCodeAsString(), other.failureCodeAsString())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(template(), other.template()) && Objects.equals(worldCount(), other.worldCount())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags()) && hasWorldTags() == other.hasWorldTags()
                && Objects.equals(worldTags(), other.worldTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorldGenerationJobResponse").add("Arn", arn()).add("Status", statusAsString())
                .add("CreatedAt", createdAt()).add("FailureCode", failureCodeAsString())
                .add("ClientRequestToken", clientRequestToken()).add("Template", template()).add("WorldCount", worldCount())
                .add("Tags", hasTags() ? tags() : null).add("WorldTags", hasWorldTags() ? worldTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "failureCode":
            return Optional.ofNullable(clazz.cast(failureCodeAsString()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "template":
            return Optional.ofNullable(clazz.cast(template()));
        case "worldCount":
            return Optional.ofNullable(clazz.cast(worldCount()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "worldTags":
            return Optional.ofNullable(clazz.cast(worldTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorldGenerationJobResponse, T> g) {
        return obj -> g.apply((CreateWorldGenerationJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateWorldGenerationJobResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the world generator job.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the world generator job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The status of the world generator job.
         * </p>
         * <dl>
         * <dt>Pending</dt>
         * <dd>
         * <p>
         * The world generator job request is pending.
         * </p>
         * </dd>
         * <dt>Running</dt>
         * <dd>
         * <p>
         * The world generator job is running.
         * </p>
         * </dd>
         * <dt>Completed</dt>
         * <dd>
         * <p>
         * The world generator job completed.
         * </p>
         * </dd>
         * <dt>Failed</dt>
         * <dd>
         * <p>
         * The world generator job failed. See <code>failureCode</code> for more information.
         * </p>
         * </dd>
         * <dt>PartialFailed</dt>
         * <dd>
         * <p>
         * Some worlds did not generate.
         * </p>
         * </dd>
         * <dt>Canceled</dt>
         * <dd>
         * <p>
         * The world generator job was cancelled.
         * </p>
         * </dd>
         * <dt>Canceling</dt>
         * <dd>
         * <p>
         * The world generator job is being cancelled.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        The status of the world generator job.</p>
         *        <dl>
         *        <dt>Pending</dt>
         *        <dd>
         *        <p>
         *        The world generator job request is pending.
         *        </p>
         *        </dd>
         *        <dt>Running</dt>
         *        <dd>
         *        <p>
         *        The world generator job is running.
         *        </p>
         *        </dd>
         *        <dt>Completed</dt>
         *        <dd>
         *        <p>
         *        The world generator job completed.
         *        </p>
         *        </dd>
         *        <dt>Failed</dt>
         *        <dd>
         *        <p>
         *        The world generator job failed. See <code>failureCode</code> for more information.
         *        </p>
         *        </dd>
         *        <dt>PartialFailed</dt>
         *        <dd>
         *        <p>
         *        Some worlds did not generate.
         *        </p>
         *        </dd>
         *        <dt>Canceled</dt>
         *        <dd>
         *        <p>
         *        The world generator job was cancelled.
         *        </p>
         *        </dd>
         *        <dt>Canceling</dt>
         *        <dd>
         *        <p>
         *        The world generator job is being cancelled.
         *        </p>
         *        </dd>
         * @see WorldGenerationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorldGenerationJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the world generator job.
         * </p>
         * <dl>
         * <dt>Pending</dt>
         * <dd>
         * <p>
         * The world generator job request is pending.
         * </p>
         * </dd>
         * <dt>Running</dt>
         * <dd>
         * <p>
         * The world generator job is running.
         * </p>
         * </dd>
         * <dt>Completed</dt>
         * <dd>
         * <p>
         * The world generator job completed.
         * </p>
         * </dd>
         * <dt>Failed</dt>
         * <dd>
         * <p>
         * The world generator job failed. See <code>failureCode</code> for more information.
         * </p>
         * </dd>
         * <dt>PartialFailed</dt>
         * <dd>
         * <p>
         * Some worlds did not generate.
         * </p>
         * </dd>
         * <dt>Canceled</dt>
         * <dd>
         * <p>
         * The world generator job was cancelled.
         * </p>
         * </dd>
         * <dt>Canceling</dt>
         * <dd>
         * <p>
         * The world generator job is being cancelled.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        The status of the world generator job.</p>
         *        <dl>
         *        <dt>Pending</dt>
         *        <dd>
         *        <p>
         *        The world generator job request is pending.
         *        </p>
         *        </dd>
         *        <dt>Running</dt>
         *        <dd>
         *        <p>
         *        The world generator job is running.
         *        </p>
         *        </dd>
         *        <dt>Completed</dt>
         *        <dd>
         *        <p>
         *        The world generator job completed.
         *        </p>
         *        </dd>
         *        <dt>Failed</dt>
         *        <dd>
         *        <p>
         *        The world generator job failed. See <code>failureCode</code> for more information.
         *        </p>
         *        </dd>
         *        <dt>PartialFailed</dt>
         *        <dd>
         *        <p>
         *        Some worlds did not generate.
         *        </p>
         *        </dd>
         *        <dt>Canceled</dt>
         *        <dd>
         *        <p>
         *        The world generator job was cancelled.
         *        </p>
         *        </dd>
         *        <dt>Canceling</dt>
         *        <dd>
         *        <p>
         *        The world generator job is being cancelled.
         *        </p>
         *        </dd>
         * @see WorldGenerationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorldGenerationJobStatus
         */
        Builder status(WorldGenerationJobStatus status);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the world generator job was created.
         * </p>
         * 
         * @param createdAt
         *        The time, in milliseconds since the epoch, when the world generator job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The failure code of the world generator job if it failed:
         * </p>
         * <dl>
         * <dt>InternalServiceError</dt>
         * <dd>
         * <p>
         * Internal service error.
         * </p>
         * </dd>
         * <dt>LimitExceeded</dt>
         * <dd>
         * <p>
         * The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
         * exceeds the maximum number allowed.
         * </p>
         * </dd>
         * <dt>ResourceNotFound</dt>
         * <dd>
         * <p>
         * The specified resource could not be found.
         * </p>
         * </dd>
         * <dt>RequestThrottled</dt>
         * <dd>
         * <p>
         * The request was throttled.
         * </p>
         * </dd>
         * <dt>InvalidInput</dt>
         * <dd>
         * <p>
         * An input parameter in the request is not valid.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param failureCode
         *        The failure code of the world generator job if it failed:</p>
         *        <dl>
         *        <dt>InternalServiceError</dt>
         *        <dd>
         *        <p>
         *        Internal service error.
         *        </p>
         *        </dd>
         *        <dt>LimitExceeded</dt>
         *        <dd>
         *        <p>
         *        The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
         *        exceeds the maximum number allowed.
         *        </p>
         *        </dd>
         *        <dt>ResourceNotFound</dt>
         *        <dd>
         *        <p>
         *        The specified resource could not be found.
         *        </p>
         *        </dd>
         *        <dt>RequestThrottled</dt>
         *        <dd>
         *        <p>
         *        The request was throttled.
         *        </p>
         *        </dd>
         *        <dt>InvalidInput</dt>
         *        <dd>
         *        <p>
         *        An input parameter in the request is not valid.
         *        </p>
         *        </dd>
         * @see WorldGenerationJobErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorldGenerationJobErrorCode
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * The failure code of the world generator job if it failed:
         * </p>
         * <dl>
         * <dt>InternalServiceError</dt>
         * <dd>
         * <p>
         * Internal service error.
         * </p>
         * </dd>
         * <dt>LimitExceeded</dt>
         * <dd>
         * <p>
         * The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
         * exceeds the maximum number allowed.
         * </p>
         * </dd>
         * <dt>ResourceNotFound</dt>
         * <dd>
         * <p>
         * The specified resource could not be found.
         * </p>
         * </dd>
         * <dt>RequestThrottled</dt>
         * <dd>
         * <p>
         * The request was throttled.
         * </p>
         * </dd>
         * <dt>InvalidInput</dt>
         * <dd>
         * <p>
         * An input parameter in the request is not valid.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param failureCode
         *        The failure code of the world generator job if it failed:</p>
         *        <dl>
         *        <dt>InternalServiceError</dt>
         *        <dd>
         *        <p>
         *        Internal service error.
         *        </p>
         *        </dd>
         *        <dt>LimitExceeded</dt>
         *        <dd>
         *        <p>
         *        The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
         *        exceeds the maximum number allowed.
         *        </p>
         *        </dd>
         *        <dt>ResourceNotFound</dt>
         *        <dd>
         *        <p>
         *        The specified resource could not be found.
         *        </p>
         *        </dd>
         *        <dt>RequestThrottled</dt>
         *        <dd>
         *        <p>
         *        The request was throttled.
         *        </p>
         *        </dd>
         *        <dt>InvalidInput</dt>
         *        <dd>
         *        <p>
         *        An input parameter in the request is not valid.
         *        </p>
         *        </dd>
         * @see WorldGenerationJobErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorldGenerationJobErrorCode
         */
        Builder failureCode(WorldGenerationJobErrorCode failureCode);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientRequestToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The Amazon Resource Name (arn) of the world template.
         * </p>
         * 
         * @param template
         *        The Amazon Resource Name (arn) of the world template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder template(String template);

        /**
         * <p>
         * Information about the world count.
         * </p>
         * 
         * @param worldCount
         *        Information about the world count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder worldCount(WorldCount worldCount);

        /**
         * <p>
         * Information about the world count.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorldCount.Builder} avoiding the need to
         * create one manually via {@link WorldCount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorldCount.Builder#build()} is called immediately and its result
         * is passed to {@link #worldCount(WorldCount)}.
         * 
         * @param worldCount
         *        a consumer that will call methods on {@link WorldCount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #worldCount(WorldCount)
         */
        default Builder worldCount(Consumer<WorldCount.Builder> worldCount) {
            return worldCount(WorldCount.builder().applyMutation(worldCount).build());
        }

        /**
         * <p>
         * A map that contains tag keys and tag values that are attached to the world generator job.
         * </p>
         * 
         * @param tags
         *        A map that contains tag keys and tag values that are attached to the world generator job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A map that contains tag keys and tag values that are attached to the generated worlds.
         * </p>
         * 
         * @param worldTags
         *        A map that contains tag keys and tag values that are attached to the generated worlds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder worldTags(Map<String, String> worldTags);
    }

    static final class BuilderImpl extends RoboMakerResponse.BuilderImpl implements Builder {
        private String arn;

        private String status;

        private Instant createdAt;

        private String failureCode;

        private String clientRequestToken;

        private String template;

        private WorldCount worldCount;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> worldTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorldGenerationJobResponse model) {
            super(model);
            arn(model.arn);
            status(model.status);
            createdAt(model.createdAt);
            failureCode(model.failureCode);
            clientRequestToken(model.clientRequestToken);
            template(model.template);
            worldCount(model.worldCount);
            tags(model.tags);
            worldTags(model.worldTags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorldGenerationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getFailureCode() {
            return failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(WorldGenerationJobErrorCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getTemplate() {
            return template;
        }

        public final void setTemplate(String template) {
            this.template = template;
        }

        @Override
        public final Builder template(String template) {
            this.template = template;
            return this;
        }

        public final WorldCount.Builder getWorldCount() {
            return worldCount != null ? worldCount.toBuilder() : null;
        }

        public final void setWorldCount(WorldCount.BuilderImpl worldCount) {
            this.worldCount = worldCount != null ? worldCount.build() : null;
        }

        @Override
        public final Builder worldCount(WorldCount worldCount) {
            this.worldCount = worldCount;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Map<String, String> getWorldTags() {
            if (worldTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return worldTags;
        }

        public final void setWorldTags(Map<String, String> worldTags) {
            this.worldTags = TagMapCopier.copy(worldTags);
        }

        @Override
        public final Builder worldTags(Map<String, String> worldTags) {
            this.worldTags = TagMapCopier.copy(worldTags);
            return this;
        }

        @Override
        public CreateWorldGenerationJobResponse build() {
            return new CreateWorldGenerationJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
