/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.robomaker.DefaultRoboMakerBaseClientBuilder;
import software.amazon.awssdk.services.robomaker.DefaultRoboMakerClient;
import software.amazon.awssdk.services.robomaker.RoboMakerClient;
import software.amazon.awssdk.services.robomaker.RoboMakerClientBuilder;
import software.amazon.awssdk.services.robomaker.RoboMakerServiceClientConfiguration;
import software.amazon.awssdk.services.robomaker.endpoints.RoboMakerEndpointProvider;

@SdkInternalApi
final class DefaultRoboMakerClientBuilder
extends DefaultRoboMakerBaseClientBuilder<RoboMakerClientBuilder, RoboMakerClient>
implements RoboMakerClientBuilder {
    DefaultRoboMakerClientBuilder() {
    }

    @Override
    public DefaultRoboMakerClientBuilder endpointProvider(RoboMakerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final RoboMakerClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultRoboMakerClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        RoboMakerServiceClientConfiguration serviceClientConfiguration = RoboMakerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultRoboMakerClient(serviceClientConfiguration, clientConfiguration);
    }
}

