/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.robomaker.model.UploadBehavior;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UploadConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UploadConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UploadConfiguration.getter(UploadConfiguration::name)).setter(UploadConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("path").getter(UploadConfiguration.getter(UploadConfiguration::path)).setter(UploadConfiguration.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()}).build();
    private static final SdkField<String> UPLOAD_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uploadBehavior").getter(UploadConfiguration.getter(UploadConfiguration::uploadBehaviorAsString)).setter(UploadConfiguration.setter(Builder::uploadBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadBehavior").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PATH_FIELD, UPLOAD_BEHAVIOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String path;
    private final String uploadBehavior;

    private UploadConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.path = builder.path;
        this.uploadBehavior = builder.uploadBehavior;
    }

    public final String name() {
        return this.name;
    }

    public final String path() {
        return this.path;
    }

    public final UploadBehavior uploadBehavior() {
        return UploadBehavior.fromValue(this.uploadBehavior);
    }

    public final String uploadBehaviorAsString() {
        return this.uploadBehavior;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadBehaviorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadConfiguration)) {
            return false;
        }
        UploadConfiguration other = (UploadConfiguration)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.uploadBehaviorAsString(), other.uploadBehaviorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UploadConfiguration").add("Name", (Object)this.name()).add("Path", (Object)this.path()).add("UploadBehavior", (Object)this.uploadBehaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "uploadBehavior": {
                return Optional.ofNullable(clazz.cast(this.uploadBehaviorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UploadConfiguration, T> g) {
        return obj -> g.apply((UploadConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String path;
        private String uploadBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadConfiguration model) {
            this.name(model.name);
            this.path(model.path);
            this.uploadBehavior(model.uploadBehavior);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        @Transient
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getUploadBehavior() {
            return this.uploadBehavior;
        }

        public final void setUploadBehavior(String uploadBehavior) {
            this.uploadBehavior = uploadBehavior;
        }

        @Override
        @Transient
        public final Builder uploadBehavior(String uploadBehavior) {
            this.uploadBehavior = uploadBehavior;
            return this;
        }

        @Override
        @Transient
        public final Builder uploadBehavior(UploadBehavior uploadBehavior) {
            this.uploadBehavior(uploadBehavior == null ? null : uploadBehavior.toString());
            return this;
        }

        public UploadConfiguration build() {
            return new UploadConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UploadConfiguration> {
        public Builder name(String var1);

        public Builder path(String var1);

        public Builder uploadBehavior(String var1);

        public Builder uploadBehavior(UploadBehavior var1);
    }
}

