/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.robomaker.RoboMakerClient;
import software.amazon.awssdk.services.robomaker.model.ListRobotsRequest;
import software.amazon.awssdk.services.robomaker.model.ListRobotsResponse;
import software.amazon.awssdk.services.robomaker.model.Robot;

public class ListRobotsIterable
implements SdkIterable<ListRobotsResponse> {
    private final RoboMakerClient client;
    private final ListRobotsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRobotsIterable(RoboMakerClient client, ListRobotsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRobotsResponseFetcher();
    }

    public Iterator<ListRobotsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Robot> robots() {
        Function<ListRobotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.robots() != null) {
                return response.robots().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRobotsResponseFetcher
    implements SyncPageFetcher<ListRobotsResponse> {
        private ListRobotsResponseFetcher() {
        }

        public boolean hasNextPage(ListRobotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRobotsResponse nextPage(ListRobotsResponse previousPage) {
            if (previousPage == null) {
                return ListRobotsIterable.this.client.listRobots(ListRobotsIterable.this.firstRequest);
            }
            return ListRobotsIterable.this.client.listRobots((ListRobotsRequest)((Object)ListRobotsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

