/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.robomaker.RoboMakerAsyncClient;
import software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesRequest;
import software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesResponse;
import software.amazon.awssdk.services.robomaker.model.SimulationJobBatchSummary;

public class ListSimulationJobBatchesPublisher
implements SdkPublisher<ListSimulationJobBatchesResponse> {
    private final RoboMakerAsyncClient client;
    private final ListSimulationJobBatchesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSimulationJobBatchesPublisher(RoboMakerAsyncClient client, ListSimulationJobBatchesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSimulationJobBatchesPublisher(RoboMakerAsyncClient client, ListSimulationJobBatchesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSimulationJobBatchesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSimulationJobBatchesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SimulationJobBatchSummary> simulationJobBatchSummaries() {
        Function<ListSimulationJobBatchesResponse, Iterator> getIterator = response -> {
            if (response != null && response.simulationJobBatchSummaries() != null) {
                return response.simulationJobBatchSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSimulationJobBatchesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSimulationJobBatchesResponseFetcher
    implements AsyncPageFetcher<ListSimulationJobBatchesResponse> {
        private ListSimulationJobBatchesResponseFetcher() {
        }

        public boolean hasNextPage(ListSimulationJobBatchesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSimulationJobBatchesResponse> nextPage(ListSimulationJobBatchesResponse previousPage) {
            if (previousPage == null) {
                return ListSimulationJobBatchesPublisher.this.client.listSimulationJobBatches(ListSimulationJobBatchesPublisher.this.firstRequest);
            }
            return ListSimulationJobBatchesPublisher.this.client.listSimulationJobBatches((ListSimulationJobBatchesRequest)((Object)ListSimulationJobBatchesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

