/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3KeyOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3KeyOutput> {
    private static final SdkField<String> S3_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Key").getter(S3KeyOutput.getter(S3KeyOutput::s3Key)).setter(S3KeyOutput.setter(Builder::s3Key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Key").build()}).build();
    private static final SdkField<String> ETAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("etag").getter(S3KeyOutput.getter(S3KeyOutput::etag)).setter(S3KeyOutput.setter(Builder::etag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("etag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_KEY_FIELD, ETAG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String s3Key;
    private final String etag;

    private S3KeyOutput(BuilderImpl builder) {
        this.s3Key = builder.s3Key;
        this.etag = builder.etag;
    }

    public String s3Key() {
        return this.s3Key;
    }

    public String etag() {
        return this.etag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Key());
        hashCode = 31 * hashCode + Objects.hashCode(this.etag());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3KeyOutput)) {
            return false;
        }
        S3KeyOutput other = (S3KeyOutput)obj;
        return Objects.equals(this.s3Key(), other.s3Key()) && Objects.equals(this.etag(), other.etag());
    }

    public String toString() {
        return ToString.builder((String)"S3KeyOutput").add("S3Key", (Object)this.s3Key()).add("Etag", (Object)this.etag()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3Key": {
                return Optional.ofNullable(clazz.cast(this.s3Key()));
            }
            case "etag": {
                return Optional.ofNullable(clazz.cast(this.etag()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3KeyOutput, T> g) {
        return obj -> g.apply((S3KeyOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3Key;
        private String etag;

        private BuilderImpl() {
        }

        private BuilderImpl(S3KeyOutput model) {
            this.s3Key(model.s3Key);
            this.etag(model.etag);
        }

        public final String getS3Key() {
            return this.s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        public final String getEtag() {
            return this.etag;
        }

        @Override
        public final Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public final void setEtag(String etag) {
            this.etag = etag;
        }

        public S3KeyOutput build() {
            return new S3KeyOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3KeyOutput> {
        public Builder s3Key(String var1);

        public Builder etag(String var1);
    }
}

