/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.robomaker.model.RoboMakerResponse;
import software.amazon.awssdk.services.robomaker.model.WorldGenerationJobSummariesCopier;
import software.amazon.awssdk.services.robomaker.model.WorldGenerationJobSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorldGenerationJobsResponse
extends RoboMakerResponse
implements ToCopyableBuilder<Builder, ListWorldGenerationJobsResponse> {
    private static final SdkField<List<WorldGenerationJobSummary>> WORLD_GENERATION_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListWorldGenerationJobsResponse.getter(ListWorldGenerationJobsResponse::worldGenerationJobSummaries)).setter(ListWorldGenerationJobsResponse.setter(Builder::worldGenerationJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("worldGenerationJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorldGenerationJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListWorldGenerationJobsResponse.getter(ListWorldGenerationJobsResponse::nextToken)).setter(ListWorldGenerationJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORLD_GENERATION_JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<WorldGenerationJobSummary> worldGenerationJobSummaries;
    private final String nextToken;

    private ListWorldGenerationJobsResponse(BuilderImpl builder) {
        super(builder);
        this.worldGenerationJobSummaries = builder.worldGenerationJobSummaries;
        this.nextToken = builder.nextToken;
    }

    public boolean hasWorldGenerationJobSummaries() {
        return this.worldGenerationJobSummaries != null && !(this.worldGenerationJobSummaries instanceof SdkAutoConstructList);
    }

    public List<WorldGenerationJobSummary> worldGenerationJobSummaries() {
        return this.worldGenerationJobSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.worldGenerationJobSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorldGenerationJobsResponse)) {
            return false;
        }
        ListWorldGenerationJobsResponse other = (ListWorldGenerationJobsResponse)((Object)obj);
        return Objects.equals(this.worldGenerationJobSummaries(), other.worldGenerationJobSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListWorldGenerationJobsResponse").add("WorldGenerationJobSummaries", this.worldGenerationJobSummaries()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "worldGenerationJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.worldGenerationJobSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWorldGenerationJobsResponse, T> g) {
        return obj -> g.apply((ListWorldGenerationJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerResponse.BuilderImpl
    implements Builder {
        private List<WorldGenerationJobSummary> worldGenerationJobSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorldGenerationJobsResponse model) {
            super(model);
            this.worldGenerationJobSummaries(model.worldGenerationJobSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<WorldGenerationJobSummary.Builder> getWorldGenerationJobSummaries() {
            return this.worldGenerationJobSummaries != null ? (Collection)this.worldGenerationJobSummaries.stream().map(WorldGenerationJobSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder worldGenerationJobSummaries(Collection<WorldGenerationJobSummary> worldGenerationJobSummaries) {
            this.worldGenerationJobSummaries = WorldGenerationJobSummariesCopier.copy(worldGenerationJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder worldGenerationJobSummaries(WorldGenerationJobSummary ... worldGenerationJobSummaries) {
            this.worldGenerationJobSummaries(Arrays.asList(worldGenerationJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder worldGenerationJobSummaries(Consumer<WorldGenerationJobSummary.Builder> ... worldGenerationJobSummaries) {
            this.worldGenerationJobSummaries(Stream.of(worldGenerationJobSummaries).map(c -> (WorldGenerationJobSummary)((WorldGenerationJobSummary.Builder)WorldGenerationJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWorldGenerationJobSummaries(Collection<WorldGenerationJobSummary.BuilderImpl> worldGenerationJobSummaries) {
            this.worldGenerationJobSummaries = WorldGenerationJobSummariesCopier.copyFromBuilder(worldGenerationJobSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListWorldGenerationJobsResponse build() {
            return new ListWorldGenerationJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RoboMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorldGenerationJobsResponse> {
        public Builder worldGenerationJobSummaries(Collection<WorldGenerationJobSummary> var1);

        public Builder worldGenerationJobSummaries(WorldGenerationJobSummary ... var1);

        public Builder worldGenerationJobSummaries(Consumer<WorldGenerationJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

