/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.robomaker.model.Compute;
import software.amazon.awssdk.services.robomaker.model.DataSourceConfig;
import software.amazon.awssdk.services.robomaker.model.DataSourceConfigsCopier;
import software.amazon.awssdk.services.robomaker.model.FailureBehavior;
import software.amazon.awssdk.services.robomaker.model.LoggingConfig;
import software.amazon.awssdk.services.robomaker.model.OutputLocation;
import software.amazon.awssdk.services.robomaker.model.RobotApplicationConfig;
import software.amazon.awssdk.services.robomaker.model.RobotApplicationConfigsCopier;
import software.amazon.awssdk.services.robomaker.model.SimulationApplicationConfig;
import software.amazon.awssdk.services.robomaker.model.SimulationApplicationConfigsCopier;
import software.amazon.awssdk.services.robomaker.model.TagMapCopier;
import software.amazon.awssdk.services.robomaker.model.VPCConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SimulationJobRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SimulationJobRequest> {
    private static final SdkField<OutputLocation> OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SimulationJobRequest.getter(SimulationJobRequest::outputLocation)).setter(SimulationJobRequest.setter(Builder::outputLocation)).constructor(OutputLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputLocation").build()}).build();
    private static final SdkField<LoggingConfig> LOGGING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SimulationJobRequest.getter(SimulationJobRequest::loggingConfig)).setter(SimulationJobRequest.setter(Builder::loggingConfig)).constructor(LoggingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingConfig").build()}).build();
    private static final SdkField<Long> MAX_JOB_DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(SimulationJobRequest.getter(SimulationJobRequest::maxJobDurationInSeconds)).setter(SimulationJobRequest.setter(Builder::maxJobDurationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxJobDurationInSeconds").build()}).build();
    private static final SdkField<String> IAM_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SimulationJobRequest.getter(SimulationJobRequest::iamRole)).setter(SimulationJobRequest.setter(Builder::iamRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRole").build()}).build();
    private static final SdkField<String> FAILURE_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SimulationJobRequest.getter(SimulationJobRequest::failureBehaviorAsString)).setter(SimulationJobRequest.setter(Builder::failureBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureBehavior").build()}).build();
    private static final SdkField<Boolean> USE_DEFAULT_APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(SimulationJobRequest.getter(SimulationJobRequest::useDefaultApplications)).setter(SimulationJobRequest.setter(Builder::useDefaultApplications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useDefaultApplications").build()}).build();
    private static final SdkField<List<RobotApplicationConfig>> ROBOT_APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SimulationJobRequest.getter(SimulationJobRequest::robotApplications)).setter(SimulationJobRequest.setter(Builder::robotApplications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robotApplications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RobotApplicationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SimulationApplicationConfig>> SIMULATION_APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SimulationJobRequest.getter(SimulationJobRequest::simulationApplications)).setter(SimulationJobRequest.setter(Builder::simulationApplications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simulationApplications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SimulationApplicationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSourceConfig>> DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SimulationJobRequest.getter(SimulationJobRequest::dataSources)).setter(SimulationJobRequest.setter(Builder::dataSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VPCConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SimulationJobRequest.getter(SimulationJobRequest::vpcConfig)).setter(SimulationJobRequest.setter(Builder::vpcConfig)).constructor(VPCConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()}).build();
    private static final SdkField<Compute> COMPUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SimulationJobRequest.getter(SimulationJobRequest::compute)).setter(SimulationJobRequest.setter(Builder::compute)).constructor(Compute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compute").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(SimulationJobRequest.getter(SimulationJobRequest::tags)).setter(SimulationJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_LOCATION_FIELD, LOGGING_CONFIG_FIELD, MAX_JOB_DURATION_IN_SECONDS_FIELD, IAM_ROLE_FIELD, FAILURE_BEHAVIOR_FIELD, USE_DEFAULT_APPLICATIONS_FIELD, ROBOT_APPLICATIONS_FIELD, SIMULATION_APPLICATIONS_FIELD, DATA_SOURCES_FIELD, VPC_CONFIG_FIELD, COMPUTE_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final OutputLocation outputLocation;
    private final LoggingConfig loggingConfig;
    private final Long maxJobDurationInSeconds;
    private final String iamRole;
    private final String failureBehavior;
    private final Boolean useDefaultApplications;
    private final List<RobotApplicationConfig> robotApplications;
    private final List<SimulationApplicationConfig> simulationApplications;
    private final List<DataSourceConfig> dataSources;
    private final VPCConfig vpcConfig;
    private final Compute compute;
    private final Map<String, String> tags;

    private SimulationJobRequest(BuilderImpl builder) {
        this.outputLocation = builder.outputLocation;
        this.loggingConfig = builder.loggingConfig;
        this.maxJobDurationInSeconds = builder.maxJobDurationInSeconds;
        this.iamRole = builder.iamRole;
        this.failureBehavior = builder.failureBehavior;
        this.useDefaultApplications = builder.useDefaultApplications;
        this.robotApplications = builder.robotApplications;
        this.simulationApplications = builder.simulationApplications;
        this.dataSources = builder.dataSources;
        this.vpcConfig = builder.vpcConfig;
        this.compute = builder.compute;
        this.tags = builder.tags;
    }

    public OutputLocation outputLocation() {
        return this.outputLocation;
    }

    public LoggingConfig loggingConfig() {
        return this.loggingConfig;
    }

    public Long maxJobDurationInSeconds() {
        return this.maxJobDurationInSeconds;
    }

    public String iamRole() {
        return this.iamRole;
    }

    public FailureBehavior failureBehavior() {
        return FailureBehavior.fromValue(this.failureBehavior);
    }

    public String failureBehaviorAsString() {
        return this.failureBehavior;
    }

    public Boolean useDefaultApplications() {
        return this.useDefaultApplications;
    }

    public boolean hasRobotApplications() {
        return this.robotApplications != null && !(this.robotApplications instanceof SdkAutoConstructList);
    }

    public List<RobotApplicationConfig> robotApplications() {
        return this.robotApplications;
    }

    public boolean hasSimulationApplications() {
        return this.simulationApplications != null && !(this.simulationApplications instanceof SdkAutoConstructList);
    }

    public List<SimulationApplicationConfig> simulationApplications() {
        return this.simulationApplications;
    }

    public boolean hasDataSources() {
        return this.dataSources != null && !(this.dataSources instanceof SdkAutoConstructList);
    }

    public List<DataSourceConfig> dataSources() {
        return this.dataSources;
    }

    public VPCConfig vpcConfig() {
        return this.vpcConfig;
    }

    public Compute compute() {
        return this.compute;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxJobDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.useDefaultApplications());
        hashCode = 31 * hashCode + Objects.hashCode(this.robotApplications());
        hashCode = 31 * hashCode + Objects.hashCode(this.simulationApplications());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSources());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.compute());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimulationJobRequest)) {
            return false;
        }
        SimulationJobRequest other = (SimulationJobRequest)obj;
        return Objects.equals(this.outputLocation(), other.outputLocation()) && Objects.equals(this.loggingConfig(), other.loggingConfig()) && Objects.equals(this.maxJobDurationInSeconds(), other.maxJobDurationInSeconds()) && Objects.equals(this.iamRole(), other.iamRole()) && Objects.equals(this.failureBehaviorAsString(), other.failureBehaviorAsString()) && Objects.equals(this.useDefaultApplications(), other.useDefaultApplications()) && Objects.equals(this.robotApplications(), other.robotApplications()) && Objects.equals(this.simulationApplications(), other.simulationApplications()) && Objects.equals(this.dataSources(), other.dataSources()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.compute(), other.compute()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"SimulationJobRequest").add("OutputLocation", (Object)this.outputLocation()).add("LoggingConfig", (Object)this.loggingConfig()).add("MaxJobDurationInSeconds", (Object)this.maxJobDurationInSeconds()).add("IamRole", (Object)this.iamRole()).add("FailureBehavior", (Object)this.failureBehaviorAsString()).add("UseDefaultApplications", (Object)this.useDefaultApplications()).add("RobotApplications", this.robotApplications()).add("SimulationApplications", this.simulationApplications()).add("DataSources", this.dataSources()).add("VpcConfig", (Object)this.vpcConfig()).add("Compute", (Object)this.compute()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "outputLocation": {
                return Optional.ofNullable(clazz.cast(this.outputLocation()));
            }
            case "loggingConfig": {
                return Optional.ofNullable(clazz.cast(this.loggingConfig()));
            }
            case "maxJobDurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maxJobDurationInSeconds()));
            }
            case "iamRole": {
                return Optional.ofNullable(clazz.cast(this.iamRole()));
            }
            case "failureBehavior": {
                return Optional.ofNullable(clazz.cast(this.failureBehaviorAsString()));
            }
            case "useDefaultApplications": {
                return Optional.ofNullable(clazz.cast(this.useDefaultApplications()));
            }
            case "robotApplications": {
                return Optional.ofNullable(clazz.cast(this.robotApplications()));
            }
            case "simulationApplications": {
                return Optional.ofNullable(clazz.cast(this.simulationApplications()));
            }
            case "dataSources": {
                return Optional.ofNullable(clazz.cast(this.dataSources()));
            }
            case "vpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "compute": {
                return Optional.ofNullable(clazz.cast(this.compute()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SimulationJobRequest, T> g) {
        return obj -> g.apply((SimulationJobRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private OutputLocation outputLocation;
        private LoggingConfig loggingConfig;
        private Long maxJobDurationInSeconds;
        private String iamRole;
        private String failureBehavior;
        private Boolean useDefaultApplications;
        private List<RobotApplicationConfig> robotApplications = DefaultSdkAutoConstructList.getInstance();
        private List<SimulationApplicationConfig> simulationApplications = DefaultSdkAutoConstructList.getInstance();
        private List<DataSourceConfig> dataSources = DefaultSdkAutoConstructList.getInstance();
        private VPCConfig vpcConfig;
        private Compute compute;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SimulationJobRequest model) {
            this.outputLocation(model.outputLocation);
            this.loggingConfig(model.loggingConfig);
            this.maxJobDurationInSeconds(model.maxJobDurationInSeconds);
            this.iamRole(model.iamRole);
            this.failureBehavior(model.failureBehavior);
            this.useDefaultApplications(model.useDefaultApplications);
            this.robotApplications(model.robotApplications);
            this.simulationApplications(model.simulationApplications);
            this.dataSources(model.dataSources);
            this.vpcConfig(model.vpcConfig);
            this.compute(model.compute);
            this.tags(model.tags);
        }

        public final OutputLocation.Builder getOutputLocation() {
            return this.outputLocation != null ? this.outputLocation.toBuilder() : null;
        }

        @Override
        public final Builder outputLocation(OutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final void setOutputLocation(OutputLocation.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        public final LoggingConfig.Builder getLoggingConfig() {
            return this.loggingConfig != null ? this.loggingConfig.toBuilder() : null;
        }

        @Override
        public final Builder loggingConfig(LoggingConfig loggingConfig) {
            this.loggingConfig = loggingConfig;
            return this;
        }

        public final void setLoggingConfig(LoggingConfig.BuilderImpl loggingConfig) {
            this.loggingConfig = loggingConfig != null ? loggingConfig.build() : null;
        }

        public final Long getMaxJobDurationInSeconds() {
            return this.maxJobDurationInSeconds;
        }

        @Override
        public final Builder maxJobDurationInSeconds(Long maxJobDurationInSeconds) {
            this.maxJobDurationInSeconds = maxJobDurationInSeconds;
            return this;
        }

        public final void setMaxJobDurationInSeconds(Long maxJobDurationInSeconds) {
            this.maxJobDurationInSeconds = maxJobDurationInSeconds;
        }

        public final String getIamRole() {
            return this.iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        public final String getFailureBehaviorAsString() {
            return this.failureBehavior;
        }

        @Override
        public final Builder failureBehavior(String failureBehavior) {
            this.failureBehavior = failureBehavior;
            return this;
        }

        @Override
        public final Builder failureBehavior(FailureBehavior failureBehavior) {
            this.failureBehavior(failureBehavior == null ? null : failureBehavior.toString());
            return this;
        }

        public final void setFailureBehavior(String failureBehavior) {
            this.failureBehavior = failureBehavior;
        }

        public final Boolean getUseDefaultApplications() {
            return this.useDefaultApplications;
        }

        @Override
        public final Builder useDefaultApplications(Boolean useDefaultApplications) {
            this.useDefaultApplications = useDefaultApplications;
            return this;
        }

        public final void setUseDefaultApplications(Boolean useDefaultApplications) {
            this.useDefaultApplications = useDefaultApplications;
        }

        public final Collection<RobotApplicationConfig.Builder> getRobotApplications() {
            return this.robotApplications != null ? (Collection)this.robotApplications.stream().map(RobotApplicationConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder robotApplications(Collection<RobotApplicationConfig> robotApplications) {
            this.robotApplications = RobotApplicationConfigsCopier.copy(robotApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder robotApplications(RobotApplicationConfig ... robotApplications) {
            this.robotApplications(Arrays.asList(robotApplications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder robotApplications(Consumer<RobotApplicationConfig.Builder> ... robotApplications) {
            this.robotApplications(Stream.of(robotApplications).map(c -> (RobotApplicationConfig)((RobotApplicationConfig.Builder)RobotApplicationConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRobotApplications(Collection<RobotApplicationConfig.BuilderImpl> robotApplications) {
            this.robotApplications = RobotApplicationConfigsCopier.copyFromBuilder(robotApplications);
        }

        public final Collection<SimulationApplicationConfig.Builder> getSimulationApplications() {
            return this.simulationApplications != null ? (Collection)this.simulationApplications.stream().map(SimulationApplicationConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder simulationApplications(Collection<SimulationApplicationConfig> simulationApplications) {
            this.simulationApplications = SimulationApplicationConfigsCopier.copy(simulationApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder simulationApplications(SimulationApplicationConfig ... simulationApplications) {
            this.simulationApplications(Arrays.asList(simulationApplications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder simulationApplications(Consumer<SimulationApplicationConfig.Builder> ... simulationApplications) {
            this.simulationApplications(Stream.of(simulationApplications).map(c -> (SimulationApplicationConfig)((SimulationApplicationConfig.Builder)SimulationApplicationConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSimulationApplications(Collection<SimulationApplicationConfig.BuilderImpl> simulationApplications) {
            this.simulationApplications = SimulationApplicationConfigsCopier.copyFromBuilder(simulationApplications);
        }

        public final Collection<DataSourceConfig.Builder> getDataSources() {
            return this.dataSources != null ? (Collection)this.dataSources.stream().map(DataSourceConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dataSources(Collection<DataSourceConfig> dataSources) {
            this.dataSources = DataSourceConfigsCopier.copy(dataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(DataSourceConfig ... dataSources) {
            this.dataSources(Arrays.asList(dataSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(Consumer<DataSourceConfig.Builder> ... dataSources) {
            this.dataSources(Stream.of(dataSources).map(c -> (DataSourceConfig)((DataSourceConfig.Builder)DataSourceConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDataSources(Collection<DataSourceConfig.BuilderImpl> dataSources) {
            this.dataSources = DataSourceConfigsCopier.copyFromBuilder(dataSources);
        }

        public final VPCConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VPCConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VPCConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final Compute.Builder getCompute() {
            return this.compute != null ? this.compute.toBuilder() : null;
        }

        @Override
        public final Builder compute(Compute compute) {
            this.compute = compute;
            return this;
        }

        public final void setCompute(Compute.BuilderImpl compute) {
            this.compute = compute != null ? compute.build() : null;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public SimulationJobRequest build() {
            return new SimulationJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SimulationJobRequest> {
        public Builder outputLocation(OutputLocation var1);

        default public Builder outputLocation(Consumer<OutputLocation.Builder> outputLocation) {
            return this.outputLocation((OutputLocation)((OutputLocation.Builder)OutputLocation.builder().applyMutation(outputLocation)).build());
        }

        public Builder loggingConfig(LoggingConfig var1);

        default public Builder loggingConfig(Consumer<LoggingConfig.Builder> loggingConfig) {
            return this.loggingConfig((LoggingConfig)((LoggingConfig.Builder)LoggingConfig.builder().applyMutation(loggingConfig)).build());
        }

        public Builder maxJobDurationInSeconds(Long var1);

        public Builder iamRole(String var1);

        public Builder failureBehavior(String var1);

        public Builder failureBehavior(FailureBehavior var1);

        public Builder useDefaultApplications(Boolean var1);

        public Builder robotApplications(Collection<RobotApplicationConfig> var1);

        public Builder robotApplications(RobotApplicationConfig ... var1);

        public Builder robotApplications(Consumer<RobotApplicationConfig.Builder> ... var1);

        public Builder simulationApplications(Collection<SimulationApplicationConfig> var1);

        public Builder simulationApplications(SimulationApplicationConfig ... var1);

        public Builder simulationApplications(Consumer<SimulationApplicationConfig.Builder> ... var1);

        public Builder dataSources(Collection<DataSourceConfig> var1);

        public Builder dataSources(DataSourceConfig ... var1);

        public Builder dataSources(Consumer<DataSourceConfig.Builder> ... var1);

        public Builder vpcConfig(VPCConfig var1);

        default public Builder vpcConfig(Consumer<VPCConfig.Builder> vpcConfig) {
            return this.vpcConfig((VPCConfig)((VPCConfig.Builder)VPCConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder compute(Compute var1);

        default public Builder compute(Consumer<Compute.Builder> compute) {
            return this.compute((Compute)((Compute.Builder)Compute.builder().applyMutation(compute)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

