/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.robomaker.RoboMakerClient;
import software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsRequest;
import software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsResponse;

public class ListSimulationApplicationsIterable
implements SdkIterable<ListSimulationApplicationsResponse> {
    private final RoboMakerClient client;
    private final ListSimulationApplicationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSimulationApplicationsIterable(RoboMakerClient client, ListSimulationApplicationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSimulationApplicationsResponseFetcher();
    }

    public Iterator<ListSimulationApplicationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListSimulationApplicationsResponseFetcher
    implements SyncPageFetcher<ListSimulationApplicationsResponse> {
        private ListSimulationApplicationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSimulationApplicationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSimulationApplicationsResponse nextPage(ListSimulationApplicationsResponse previousPage) {
            if (previousPage == null) {
                return ListSimulationApplicationsIterable.this.client.listSimulationApplications(ListSimulationApplicationsIterable.this.firstRequest);
            }
            return ListSimulationApplicationsIterable.this.client.listSimulationApplications((ListSimulationApplicationsRequest)((Object)ListSimulationApplicationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

