/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.robomaker.model.RoboMakerResponse;
import software.amazon.awssdk.services.robomaker.model.RobotApplicationSummariesCopier;
import software.amazon.awssdk.services.robomaker.model.RobotApplicationSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRobotApplicationsResponse
extends RoboMakerResponse
implements ToCopyableBuilder<Builder, ListRobotApplicationsResponse> {
    private static final SdkField<List<RobotApplicationSummary>> ROBOT_APPLICATION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListRobotApplicationsResponse.getter(ListRobotApplicationsResponse::robotApplicationSummaries)).setter(ListRobotApplicationsResponse.setter(Builder::robotApplicationSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robotApplicationSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RobotApplicationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListRobotApplicationsResponse.getter(ListRobotApplicationsResponse::nextToken)).setter(ListRobotApplicationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROBOT_APPLICATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<RobotApplicationSummary> robotApplicationSummaries;
    private final String nextToken;

    private ListRobotApplicationsResponse(BuilderImpl builder) {
        super(builder);
        this.robotApplicationSummaries = builder.robotApplicationSummaries;
        this.nextToken = builder.nextToken;
    }

    public boolean hasRobotApplicationSummaries() {
        return this.robotApplicationSummaries != null && !(this.robotApplicationSummaries instanceof SdkAutoConstructList);
    }

    public List<RobotApplicationSummary> robotApplicationSummaries() {
        return this.robotApplicationSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.robotApplicationSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRobotApplicationsResponse)) {
            return false;
        }
        ListRobotApplicationsResponse other = (ListRobotApplicationsResponse)((Object)obj);
        return Objects.equals(this.robotApplicationSummaries(), other.robotApplicationSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListRobotApplicationsResponse").add("RobotApplicationSummaries", this.robotApplicationSummaries()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "robotApplicationSummaries": {
                return Optional.ofNullable(clazz.cast(this.robotApplicationSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRobotApplicationsResponse, T> g) {
        return obj -> g.apply((ListRobotApplicationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerResponse.BuilderImpl
    implements Builder {
        private List<RobotApplicationSummary> robotApplicationSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRobotApplicationsResponse model) {
            super(model);
            this.robotApplicationSummaries(model.robotApplicationSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<RobotApplicationSummary.Builder> getRobotApplicationSummaries() {
            return this.robotApplicationSummaries != null ? (Collection)this.robotApplicationSummaries.stream().map(RobotApplicationSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder robotApplicationSummaries(Collection<RobotApplicationSummary> robotApplicationSummaries) {
            this.robotApplicationSummaries = RobotApplicationSummariesCopier.copy(robotApplicationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder robotApplicationSummaries(RobotApplicationSummary ... robotApplicationSummaries) {
            this.robotApplicationSummaries(Arrays.asList(robotApplicationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder robotApplicationSummaries(Consumer<RobotApplicationSummary.Builder> ... robotApplicationSummaries) {
            this.robotApplicationSummaries(Stream.of(robotApplicationSummaries).map(c -> (RobotApplicationSummary)((RobotApplicationSummary.Builder)RobotApplicationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRobotApplicationSummaries(Collection<RobotApplicationSummary.BuilderImpl> robotApplicationSummaries) {
            this.robotApplicationSummaries = RobotApplicationSummariesCopier.copyFromBuilder(robotApplicationSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListRobotApplicationsResponse build() {
            return new ListRobotApplicationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RoboMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRobotApplicationsResponse> {
        public Builder robotApplicationSummaries(Collection<RobotApplicationSummary> var1);

        public Builder robotApplicationSummaries(RobotApplicationSummary ... var1);

        public Builder robotApplicationSummaries(Consumer<RobotApplicationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

