/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DeploymentJobErrorCode {
    RESOURCE_NOT_FOUND("ResourceNotFound"),
    ENVIRONMENT_SETUP_ERROR("EnvironmentSetupError"),
    ETAG_MISMATCH("EtagMismatch"),
    FAILURE_THRESHOLD_BREACHED("FailureThresholdBreached"),
    ROBOT_DEPLOYMENT_ABORTED("RobotDeploymentAborted"),
    ROBOT_DEPLOYMENT_NO_RESPONSE("RobotDeploymentNoResponse"),
    ROBOT_AGENT_CONNECTION_TIMEOUT("RobotAgentConnectionTimeout"),
    GREENGRASS_DEPLOYMENT_FAILED("GreengrassDeploymentFailed"),
    MISSING_ROBOT_ARCHITECTURE("MissingRobotArchitecture"),
    MISSING_ROBOT_APPLICATION_ARCHITECTURE("MissingRobotApplicationArchitecture"),
    MISSING_ROBOT_DEPLOYMENT_RESOURCE("MissingRobotDeploymentResource"),
    GREENGRASS_GROUP_VERSION_DOES_NOT_EXIST("GreengrassGroupVersionDoesNotExist"),
    EXTRACTING_BUNDLE_FAILURE("ExtractingBundleFailure"),
    PRE_LAUNCH_FILE_FAILURE("PreLaunchFileFailure"),
    POST_LAUNCH_FILE_FAILURE("PostLaunchFileFailure"),
    BAD_PERMISSION_ERROR("BadPermissionError"),
    DOWNLOAD_CONDITION_FAILED("DownloadConditionFailed"),
    INTERNAL_SERVER_ERROR("InternalServerError"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DeploymentJobErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeploymentJobErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DeploymentJobErrorCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeploymentJobErrorCode> knownValues() {
        return Stream.of(DeploymentJobErrorCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

