/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.robomaker.model.RoboMakerRequest;
import software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuite;
import software.amazon.awssdk.services.robomaker.model.SourceConfig;
import software.amazon.awssdk.services.robomaker.model.SourceConfigsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRobotApplicationRequest
extends RoboMakerRequest
implements ToCopyableBuilder<Builder, UpdateRobotApplicationRequest> {
    private static final SdkField<String> APPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateRobotApplicationRequest.getter(UpdateRobotApplicationRequest::application)).setter(UpdateRobotApplicationRequest.setter(Builder::application)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("application").build()}).build();
    private static final SdkField<List<SourceConfig>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateRobotApplicationRequest.getter(UpdateRobotApplicationRequest::sources)).setter(UpdateRobotApplicationRequest.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RobotSoftwareSuite> ROBOT_SOFTWARE_SUITE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateRobotApplicationRequest.getter(UpdateRobotApplicationRequest::robotSoftwareSuite)).setter(UpdateRobotApplicationRequest.setter(Builder::robotSoftwareSuite)).constructor(RobotSoftwareSuite::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robotSoftwareSuite").build()}).build();
    private static final SdkField<String> CURRENT_REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateRobotApplicationRequest.getter(UpdateRobotApplicationRequest::currentRevisionId)).setter(UpdateRobotApplicationRequest.setter(Builder::currentRevisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentRevisionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_FIELD, SOURCES_FIELD, ROBOT_SOFTWARE_SUITE_FIELD, CURRENT_REVISION_ID_FIELD));
    private final String application;
    private final List<SourceConfig> sources;
    private final RobotSoftwareSuite robotSoftwareSuite;
    private final String currentRevisionId;

    private UpdateRobotApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.application = builder.application;
        this.sources = builder.sources;
        this.robotSoftwareSuite = builder.robotSoftwareSuite;
        this.currentRevisionId = builder.currentRevisionId;
    }

    public String application() {
        return this.application;
    }

    public List<SourceConfig> sources() {
        return this.sources;
    }

    public RobotSoftwareSuite robotSoftwareSuite() {
        return this.robotSoftwareSuite;
    }

    public String currentRevisionId() {
        return this.currentRevisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.application());
        hashCode = 31 * hashCode + Objects.hashCode(this.sources());
        hashCode = 31 * hashCode + Objects.hashCode(this.robotSoftwareSuite());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentRevisionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRobotApplicationRequest)) {
            return false;
        }
        UpdateRobotApplicationRequest other = (UpdateRobotApplicationRequest)((Object)obj);
        return Objects.equals(this.application(), other.application()) && Objects.equals(this.sources(), other.sources()) && Objects.equals(this.robotSoftwareSuite(), other.robotSoftwareSuite()) && Objects.equals(this.currentRevisionId(), other.currentRevisionId());
    }

    public String toString() {
        return ToString.builder((String)"UpdateRobotApplicationRequest").add("Application", (Object)this.application()).add("Sources", this.sources()).add("RobotSoftwareSuite", (Object)this.robotSoftwareSuite()).add("CurrentRevisionId", (Object)this.currentRevisionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "application": {
                return Optional.ofNullable(clazz.cast(this.application()));
            }
            case "sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "robotSoftwareSuite": {
                return Optional.ofNullable(clazz.cast(this.robotSoftwareSuite()));
            }
            case "currentRevisionId": {
                return Optional.ofNullable(clazz.cast(this.currentRevisionId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRobotApplicationRequest, T> g) {
        return obj -> g.apply((UpdateRobotApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerRequest.BuilderImpl
    implements Builder {
        private String application;
        private List<SourceConfig> sources = DefaultSdkAutoConstructList.getInstance();
        private RobotSoftwareSuite robotSoftwareSuite;
        private String currentRevisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRobotApplicationRequest model) {
            super(model);
            this.application(model.application);
            this.sources(model.sources);
            this.robotSoftwareSuite(model.robotSoftwareSuite);
            this.currentRevisionId(model.currentRevisionId);
        }

        public final String getApplication() {
            return this.application;
        }

        @Override
        public final Builder application(String application) {
            this.application = application;
            return this;
        }

        public final void setApplication(String application) {
            this.application = application;
        }

        public final Collection<SourceConfig.Builder> getSources() {
            return this.sources != null ? (Collection)this.sources.stream().map(SourceConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sources(Collection<SourceConfig> sources) {
            this.sources = SourceConfigsCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(SourceConfig ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<SourceConfig.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (SourceConfig)((SourceConfig.Builder)SourceConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSources(Collection<SourceConfig.BuilderImpl> sources) {
            this.sources = SourceConfigsCopier.copyFromBuilder(sources);
        }

        public final RobotSoftwareSuite.Builder getRobotSoftwareSuite() {
            return this.robotSoftwareSuite != null ? this.robotSoftwareSuite.toBuilder() : null;
        }

        @Override
        public final Builder robotSoftwareSuite(RobotSoftwareSuite robotSoftwareSuite) {
            this.robotSoftwareSuite = robotSoftwareSuite;
            return this;
        }

        public final void setRobotSoftwareSuite(RobotSoftwareSuite.BuilderImpl robotSoftwareSuite) {
            this.robotSoftwareSuite = robotSoftwareSuite != null ? robotSoftwareSuite.build() : null;
        }

        public final String getCurrentRevisionId() {
            return this.currentRevisionId;
        }

        @Override
        public final Builder currentRevisionId(String currentRevisionId) {
            this.currentRevisionId = currentRevisionId;
            return this;
        }

        public final void setCurrentRevisionId(String currentRevisionId) {
            this.currentRevisionId = currentRevisionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRobotApplicationRequest build() {
            return new UpdateRobotApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RoboMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRobotApplicationRequest> {
        public Builder application(String var1);

        public Builder sources(Collection<SourceConfig> var1);

        public Builder sources(SourceConfig ... var1);

        public Builder sources(Consumer<SourceConfig.Builder> ... var1);

        public Builder robotSoftwareSuite(RobotSoftwareSuite var1);

        default public Builder robotSoftwareSuite(Consumer<RobotSoftwareSuite.Builder> robotSoftwareSuite) {
            return this.robotSoftwareSuite((RobotSoftwareSuite)((RobotSoftwareSuite.Builder)RobotSoftwareSuite.builder().applyMutation(robotSoftwareSuite)).build());
        }

        public Builder currentRevisionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

