/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resourcegroups.model.ResourceGroupsRequest;
import software.amazon.awssdk.services.resourcegroups.model.ResourceQuery;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartTagSyncTaskRequest
extends ResourceGroupsRequest
implements ToCopyableBuilder<Builder, StartTagSyncTaskRequest> {
    private static final SdkField<String> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Group").getter(StartTagSyncTaskRequest.getter(StartTagSyncTaskRequest::group)).setter(StartTagSyncTaskRequest.setter(Builder::group)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").build()}).build();
    private static final SdkField<String> TAG_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TagKey").getter(StartTagSyncTaskRequest.getter(StartTagSyncTaskRequest::tagKey)).setter(StartTagSyncTaskRequest.setter(Builder::tagKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKey").build()}).build();
    private static final SdkField<String> TAG_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TagValue").getter(StartTagSyncTaskRequest.getter(StartTagSyncTaskRequest::tagValue)).setter(StartTagSyncTaskRequest.setter(Builder::tagValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagValue").build()}).build();
    private static final SdkField<ResourceQuery> RESOURCE_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceQuery").getter(StartTagSyncTaskRequest.getter(StartTagSyncTaskRequest::resourceQuery)).setter(StartTagSyncTaskRequest.setter(Builder::resourceQuery)).constructor(ResourceQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceQuery").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(StartTagSyncTaskRequest.getter(StartTagSyncTaskRequest::roleArn)).setter(StartTagSyncTaskRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_FIELD, TAG_KEY_FIELD, TAG_VALUE_FIELD, RESOURCE_QUERY_FIELD, ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartTagSyncTaskRequest.memberNameToFieldInitializer();
    private final String group;
    private final String tagKey;
    private final String tagValue;
    private final ResourceQuery resourceQuery;
    private final String roleArn;

    private StartTagSyncTaskRequest(BuilderImpl builder) {
        super(builder);
        this.group = builder.group;
        this.tagKey = builder.tagKey;
        this.tagValue = builder.tagValue;
        this.resourceQuery = builder.resourceQuery;
        this.roleArn = builder.roleArn;
    }

    public final String group() {
        return this.group;
    }

    public final String tagKey() {
        return this.tagKey;
    }

    public final String tagValue() {
        return this.tagValue;
    }

    public final ResourceQuery resourceQuery() {
        return this.resourceQuery;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTagSyncTaskRequest)) {
            return false;
        }
        StartTagSyncTaskRequest other = (StartTagSyncTaskRequest)((Object)obj);
        return Objects.equals(this.group(), other.group()) && Objects.equals(this.tagKey(), other.tagKey()) && Objects.equals(this.tagValue(), other.tagValue()) && Objects.equals(this.resourceQuery(), other.resourceQuery()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"StartTagSyncTaskRequest").add("Group", (Object)this.group()).add("TagKey", (Object)this.tagKey()).add("TagValue", (Object)this.tagValue()).add("ResourceQuery", (Object)this.resourceQuery()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "TagKey": {
                return Optional.ofNullable(clazz.cast(this.tagKey()));
            }
            case "TagValue": {
                return Optional.ofNullable(clazz.cast(this.tagValue()));
            }
            case "ResourceQuery": {
                return Optional.ofNullable(clazz.cast(this.resourceQuery()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Group", GROUP_FIELD);
        map.put("TagKey", TAG_KEY_FIELD);
        map.put("TagValue", TAG_VALUE_FIELD);
        map.put("ResourceQuery", RESOURCE_QUERY_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartTagSyncTaskRequest, T> g) {
        return obj -> g.apply((StartTagSyncTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceGroupsRequest.BuilderImpl
    implements Builder {
        private String group;
        private String tagKey;
        private String tagValue;
        private ResourceQuery resourceQuery;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTagSyncTaskRequest model) {
            super(model);
            this.group(model.group);
            this.tagKey(model.tagKey);
            this.tagValue(model.tagValue);
            this.resourceQuery(model.resourceQuery);
            this.roleArn(model.roleArn);
        }

        public final String getGroup() {
            return this.group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final String getTagKey() {
            return this.tagKey;
        }

        public final void setTagKey(String tagKey) {
            this.tagKey = tagKey;
        }

        @Override
        public final Builder tagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        public final String getTagValue() {
            return this.tagValue;
        }

        public final void setTagValue(String tagValue) {
            this.tagValue = tagValue;
        }

        @Override
        public final Builder tagValue(String tagValue) {
            this.tagValue = tagValue;
            return this;
        }

        public final ResourceQuery.Builder getResourceQuery() {
            return this.resourceQuery != null ? this.resourceQuery.toBuilder() : null;
        }

        public final void setResourceQuery(ResourceQuery.BuilderImpl resourceQuery) {
            this.resourceQuery = resourceQuery != null ? resourceQuery.build() : null;
        }

        @Override
        public final Builder resourceQuery(ResourceQuery resourceQuery) {
            this.resourceQuery = resourceQuery;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartTagSyncTaskRequest build() {
            return new StartTagSyncTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ResourceGroupsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartTagSyncTaskRequest> {
        public Builder group(String var1);

        public Builder tagKey(String var1);

        public Builder tagValue(String var1);

        public Builder resourceQuery(ResourceQuery var1);

        default public Builder resourceQuery(Consumer<ResourceQuery.Builder> resourceQuery) {
            return this.resourceQuery((ResourceQuery)((ResourceQuery.Builder)ResourceQuery.builder().applyMutation(resourceQuery)).build());
        }

        public Builder roleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

