/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourcegroups.ResourceGroupsAsyncClient;
import software.amazon.awssdk.services.resourcegroups.internal.UserAgentUtils;
import software.amazon.awssdk.services.resourcegroups.model.GroupingStatusesItem;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupingStatusesRequest;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupingStatusesResponse;

public class ListGroupingStatusesPublisher
implements SdkPublisher<ListGroupingStatusesResponse> {
    private final ResourceGroupsAsyncClient client;
    private final ListGroupingStatusesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGroupingStatusesPublisher(ResourceGroupsAsyncClient client, ListGroupingStatusesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGroupingStatusesPublisher(ResourceGroupsAsyncClient client, ListGroupingStatusesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGroupingStatusesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGroupingStatusesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GroupingStatusesItem> groupingStatuses() {
        Function<ListGroupingStatusesResponse, Iterator> getIterator = response -> {
            if (response != null && response.groupingStatuses() != null) {
                return response.groupingStatuses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGroupingStatusesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListGroupingStatusesResponseFetcher
    implements AsyncPageFetcher<ListGroupingStatusesResponse> {
        private ListGroupingStatusesResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupingStatusesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGroupingStatusesResponse> nextPage(ListGroupingStatusesResponse previousPage) {
            if (previousPage == null) {
                return ListGroupingStatusesPublisher.this.client.listGroupingStatuses(ListGroupingStatusesPublisher.this.firstRequest);
            }
            return ListGroupingStatusesPublisher.this.client.listGroupingStatuses((ListGroupingStatusesRequest)((Object)ListGroupingStatusesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

