/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourcegroups.ResourceGroupsAsyncClient;
import software.amazon.awssdk.services.resourcegroups.internal.UserAgentUtils;
import software.amazon.awssdk.services.resourcegroups.model.ListTagSyncTasksRequest;
import software.amazon.awssdk.services.resourcegroups.model.ListTagSyncTasksResponse;
import software.amazon.awssdk.services.resourcegroups.model.TagSyncTaskItem;

public class ListTagSyncTasksPublisher
implements SdkPublisher<ListTagSyncTasksResponse> {
    private final ResourceGroupsAsyncClient client;
    private final ListTagSyncTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTagSyncTasksPublisher(ResourceGroupsAsyncClient client, ListTagSyncTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTagSyncTasksPublisher(ResourceGroupsAsyncClient client, ListTagSyncTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTagSyncTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTagSyncTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TagSyncTaskItem> tagSyncTasks() {
        Function<ListTagSyncTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.tagSyncTasks() != null) {
                return response.tagSyncTasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTagSyncTasksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTagSyncTasksResponseFetcher
    implements AsyncPageFetcher<ListTagSyncTasksResponse> {
        private ListTagSyncTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListTagSyncTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTagSyncTasksResponse> nextPage(ListTagSyncTasksResponse previousPage) {
            if (previousPage == null) {
                return ListTagSyncTasksPublisher.this.client.listTagSyncTasks(ListTagSyncTasksPublisher.this.firstRequest);
            }
            return ListTagSyncTasksPublisher.this.client.listTagSyncTasks((ListTagSyncTasksRequest)((Object)ListTagSyncTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

