/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourcegroups.model.GroupingStatusesItem;
import software.amazon.awssdk.services.resourcegroups.model.GroupingStatusesListCopier;
import software.amazon.awssdk.services.resourcegroups.model.ResourceGroupsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGroupingStatusesResponse
extends ResourceGroupsResponse
implements ToCopyableBuilder<Builder, ListGroupingStatusesResponse> {
    private static final SdkField<String> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Group").getter(ListGroupingStatusesResponse.getter(ListGroupingStatusesResponse::group)).setter(ListGroupingStatusesResponse.setter(Builder::group)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").build()}).build();
    private static final SdkField<List<GroupingStatusesItem>> GROUPING_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupingStatuses").getter(ListGroupingStatusesResponse.getter(ListGroupingStatusesResponse::groupingStatuses)).setter(ListGroupingStatusesResponse.setter(Builder::groupingStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupingStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupingStatusesItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListGroupingStatusesResponse.getter(ListGroupingStatusesResponse::nextToken)).setter(ListGroupingStatusesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_FIELD, GROUPING_STATUSES_FIELD, NEXT_TOKEN_FIELD));
    private final String group;
    private final List<GroupingStatusesItem> groupingStatuses;
    private final String nextToken;

    private ListGroupingStatusesResponse(BuilderImpl builder) {
        super(builder);
        this.group = builder.group;
        this.groupingStatuses = builder.groupingStatuses;
        this.nextToken = builder.nextToken;
    }

    public final String group() {
        return this.group;
    }

    public final boolean hasGroupingStatuses() {
        return this.groupingStatuses != null && !(this.groupingStatuses instanceof SdkAutoConstructList);
    }

    public final List<GroupingStatusesItem> groupingStatuses() {
        return this.groupingStatuses;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupingStatuses() ? this.groupingStatuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupingStatusesResponse)) {
            return false;
        }
        ListGroupingStatusesResponse other = (ListGroupingStatusesResponse)((Object)obj);
        return Objects.equals(this.group(), other.group()) && this.hasGroupingStatuses() == other.hasGroupingStatuses() && Objects.equals(this.groupingStatuses(), other.groupingStatuses()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListGroupingStatusesResponse").add("Group", (Object)this.group()).add("GroupingStatuses", this.hasGroupingStatuses() ? this.groupingStatuses() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "GroupingStatuses": {
                return Optional.ofNullable(clazz.cast(this.groupingStatuses()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGroupingStatusesResponse, T> g) {
        return obj -> g.apply((ListGroupingStatusesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceGroupsResponse.BuilderImpl
    implements Builder {
        private String group;
        private List<GroupingStatusesItem> groupingStatuses = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupingStatusesResponse model) {
            super(model);
            this.group(model.group);
            this.groupingStatuses(model.groupingStatuses);
            this.nextToken(model.nextToken);
        }

        public final String getGroup() {
            return this.group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final List<GroupingStatusesItem.Builder> getGroupingStatuses() {
            List<GroupingStatusesItem.Builder> result = GroupingStatusesListCopier.copyToBuilder(this.groupingStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupingStatuses(Collection<GroupingStatusesItem.BuilderImpl> groupingStatuses) {
            this.groupingStatuses = GroupingStatusesListCopier.copyFromBuilder(groupingStatuses);
        }

        @Override
        public final Builder groupingStatuses(Collection<GroupingStatusesItem> groupingStatuses) {
            this.groupingStatuses = GroupingStatusesListCopier.copy(groupingStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupingStatuses(GroupingStatusesItem ... groupingStatuses) {
            this.groupingStatuses(Arrays.asList(groupingStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupingStatuses(Consumer<GroupingStatusesItem.Builder> ... groupingStatuses) {
            this.groupingStatuses(Stream.of(groupingStatuses).map(c -> (GroupingStatusesItem)((GroupingStatusesItem.Builder)GroupingStatusesItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListGroupingStatusesResponse build() {
            return new ListGroupingStatusesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResourceGroupsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGroupingStatusesResponse> {
        public Builder group(String var1);

        public Builder groupingStatuses(Collection<GroupingStatusesItem> var1);

        public Builder groupingStatuses(GroupingStatusesItem ... var1);

        public Builder groupingStatuses(Consumer<GroupingStatusesItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

