/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.resourcegroups.DefaultResourceGroupsAsyncClient;
import software.amazon.awssdk.services.resourcegroups.DefaultResourceGroupsBaseClientBuilder;
import software.amazon.awssdk.services.resourcegroups.ResourceGroupsAsyncClient;
import software.amazon.awssdk.services.resourcegroups.ResourceGroupsAsyncClientBuilder;
import software.amazon.awssdk.services.resourcegroups.ResourceGroupsServiceClientConfiguration;
import software.amazon.awssdk.services.resourcegroups.endpoints.ResourceGroupsEndpointProvider;

@SdkInternalApi
final class DefaultResourceGroupsAsyncClientBuilder
extends DefaultResourceGroupsBaseClientBuilder<ResourceGroupsAsyncClientBuilder, ResourceGroupsAsyncClient>
implements ResourceGroupsAsyncClientBuilder {
    DefaultResourceGroupsAsyncClientBuilder() {
    }

    @Override
    public DefaultResourceGroupsAsyncClientBuilder endpointProvider(ResourceGroupsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ResourceGroupsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultResourceGroupsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        ResourceGroupsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultResourceGroupsAsyncClient client = new DefaultResourceGroupsAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ResourceGroupsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ResourceGroupsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

