/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceFilterName {
    RESOURCE_TYPE("resource-type"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceFilterName> VALUE_MAP;
    private final String value;

    private ResourceFilterName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceFilterName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceFilterName> knownValues() {
        EnumSet<ResourceFilterName> knownValues = EnumSet.allOf(ResourceFilterName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceFilterName.class, ResourceFilterName::toString);
    }
}

